/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;

public class ScatterPlotUtils {
    static HashSet<TrackType> plottableTypes = new HashSet();

    public static void openPlot(String chr, int start, int end, int zoom) {
        List<Track> tracks = IGV.getInstance().getTrackManager().getAllTracks(false);
        ArrayList samples = new ArrayList();
        for (Track t : tracks) {
            if (!(t instanceof DataTrack)) continue;
            DataTrack dataTrack = (DataTrack)t;
            TrackType type = dataTrack.getTrackType();
            String sample = dataTrack.getSampleKey();
            if (!plottableTypes.contains((Object)type)) continue;
            double regionScore = 0.0;
            int intervalSum = 0;
            List<LocusScore> scores = dataTrack.getSummaryScores(chr, start, end, zoom);
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                regionScore += (double)(value * (float)interval);
                intervalSum += interval;
            }
            if (intervalSum <= 0) continue;
            regionScore /= regionScore / (double)intervalSum;
        }
    }

    static {
        plottableTypes.add(TrackType.COPY_NUMBER);
        plottableTypes.add(TrackType.GENE_EXPRESSION);
        plottableTypes.add(TrackType.DNA_METHYLATION);
    }
}

