/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.util.LinkedHashMap;
import org.broad.igv.scatterplot.ScatterPlotData;

public class ScatterPlotTestData
extends ScatterPlotData {
    public ScatterPlotTestData(int sampleCount) {
        String[] samples = new String[sampleCount];
        double[] cnData = new double[sampleCount];
        double[] exprData = new double[sampleCount];
        double[] methData = new double[sampleCount];
        for (int i2 = 0; i2 < sampleCount; ++i2) {
            samples[i2] = "Sample " + i2;
            cnData[i2] = (double)i2 / (double)sampleCount * 4.0 * (2.0 * Math.random());
            exprData[i2] = -2.0 + (double)i2 / (double)sampleCount * 4.0 * (2.0 * Math.random());
            methData[i2] = 1.0 - (double)i2 * Math.random() / (double)sampleCount;
            System.out.println(cnData[i2] + "\t" + exprData[i2] + "\t" + methData[i2]);
        }
        LinkedHashMap<String, double[]> dataMap = new LinkedHashMap<String, double[]>();
        dataMap.put("Copy Number", cnData);
        dataMap.put("Expression", exprData);
        dataMap.put("Methylation", methData);
        String[] treated = new String[sampleCount];
        String[] hyperMutated = new String[sampleCount];
        String[] cluster = new String[sampleCount];
        for (int i3 = 0; i3 < sampleCount; ++i3) {
            double classValue;
            String string = treated[i3] = Math.random() > 0.5 ? "AA" : "B";
            if (i3 % 6 == 0) {
                treated[i3] = "null";
            }
            String string2 = hyperMutated[i3] = Math.random() > 0.9 ? "Y" : "N";
            if (i3 % 7 == 0) {
                hyperMutated[i3] = "null";
            }
            cluster[i3] = (classValue = Math.random()) > 0.9 ? "Proneural" : (classValue > 0.8 ? "neural" : (classValue > 0.6 ? "classical" : (classValue > 0.4 ? "mesenchymal" : "unknown")));
            System.out.println(cnData[i3] + "\t" + exprData[i3] + "\t" + methData[i3]);
        }
        LinkedHashMap<String, String[]> symbolMap = new LinkedHashMap<String, String[]>();
        symbolMap.put("Treatment", treated);
        symbolMap.put("Hyper mutated", hyperMutated);
        symbolMap.put("Cluster Type", cluster);
        this.loadData(samples, symbolMap, dataMap);
    }
}

