/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.util.ArrayList;
import java.util.Map;

public class ScatterPlotData {
    private String[] igvSampleNames;
    private Map<String, double[]> igvDataMap;
    private Map<String, String[]> igvSymbolMap;
    private int igvSampleCount;
    private boolean igvDataOK;
    private ArrayList<String> igvDataNames;
    private ArrayList<String> igvSymbolNames;

    public ScatterPlotData() {
    }

    public ScatterPlotData(String[] sampleNames, Map<String, String[]> symbolMap, Map<String, double[]> dataMap) {
        this.igvSampleNames = sampleNames;
        this.igvSampleCount = sampleNames.length;
        this.igvSymbolMap = symbolMap;
        this.igvSymbolNames = new ArrayList<String>(this.igvSymbolMap.keySet());
        this.igvDataMap = dataMap;
        this.igvDataNames = new ArrayList<String>(this.igvDataMap.keySet());
        this.igvDataOK = true;
    }

    public void loadData(String[] sampleNames, Map<String, String[]> symbolMap, Map<String, double[]> dataMap) {
        this.igvSampleNames = sampleNames;
        this.igvSampleCount = sampleNames.length;
        this.igvSymbolMap = symbolMap;
        this.igvSymbolNames = new ArrayList<String>(this.igvSymbolMap.keySet());
        this.igvDataMap = dataMap;
        this.igvDataNames = new ArrayList<String>(this.igvDataMap.keySet());
        this.igvDataOK = true;
    }

    public boolean isDataOK() {
        return this.igvDataOK;
    }

    public int getSampleCount() {
        return this.igvSampleCount;
    }

    public String[] getSampleNames() {
        return this.igvSampleNames;
    }

    public int getDataMapSize() {
        return this.igvDataMap.size();
    }

    public ArrayList<String> getDataNames() {
        return this.igvDataNames;
    }

    public String getDataKeyName(int index) {
        return this.igvDataNames.get(index);
    }

    public int getDataKeyIndex(String keyName) {
        int labelIndex = -1;
        int nLabels = this.igvDataNames.size();
        for (int index = 0; index < nLabels; ++index) {
            if (!this.igvDataNames.get(index).equals(keyName)) continue;
            labelIndex = index;
            break;
        }
        return labelIndex;
    }

    public double getDataKeyValue(String keyName, int sampleIndex) {
        return this.igvDataMap.get(keyName)[sampleIndex];
    }

    public double[] getDataValues(String name) {
        return this.igvDataMap.get(name);
    }

    public int getSymbolMapSize() {
        return this.igvSymbolMap.size();
    }

    public ArrayList<String> getSymbolNames() {
        return this.igvSymbolNames;
    }

    public String getSymbolKeyName(int index) {
        return this.igvSymbolNames.get(index);
    }

    public int getSymbolKeyIndex(String name) {
        int symbolIndex = -1;
        int nSymbols = this.igvSymbolNames.size();
        for (int index = 0; index < nSymbols; ++index) {
            if (!this.igvSymbolNames.get(index).equals(name)) continue;
            symbolIndex = index;
            break;
        }
        return symbolIndex;
    }

    public String getSymbolKeyValue(String keyName, int sampleIndex) {
        return this.igvSymbolMap.get(keyName)[sampleIndex];
    }

    public String[] getSymbolValues(String keyName) {
        return this.igvSymbolMap.get(keyName);
    }

    public String[] getAttributeCategories(String attribute) {
        String[] symbolValues = this.getSymbolValues(attribute);
        ArrayList<String> uniqueVals = new ArrayList<String>();
        for (String x : symbolValues) {
            if (uniqueVals.contains(x)) continue;
            uniqueVals.add(x);
        }
        int nCategories = uniqueVals.size();
        String[] categories = new String[nCategories];
        uniqueVals.toArray(categories);
        return categories;
    }

    public String getSampleDescription(int sampleIndex, boolean isHTML) {
        String keyName;
        int index;
        String description = "<html>" + this.igvSampleNames[sampleIndex] + ": <br>";
        int keyCount = this.getDataMapSize();
        for (index = 0; index < keyCount; ++index) {
            keyName = this.getDataKeyName(index);
            Double Value2 = this.getDataKeyValue(keyName, sampleIndex);
            description = description + keyName + " = " + Value2.toString() + "<br>";
        }
        keyCount = this.getSymbolMapSize();
        if (isHTML) {
            for (index = 0; index < keyCount; ++index) {
                keyName = this.getSymbolKeyName(index);
                String Sample = this.getSymbolKeyValue(keyName, sampleIndex);
                description = description + keyName + " = " + Sample + "<br>";
            }
            description = description + "</html>";
        } else {
            for (index = 0; index < keyCount; ++index) {
                keyName = this.getSymbolKeyName(index);
                String Sample = this.getSymbolKeyValue(keyName, sampleIndex);
                description = index < keyCount - 1 ? description + keyName + " = " + Sample + ", " : description + keyName + " = " + Sample;
            }
        }
        return description;
    }
}

