/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.awt.Color;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.util.ParsingUtils;

public class BEDCodec
extends UCSCCodec {
    public BasicFeature decode(String nextLine) {
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        int tokenCount = ParsingUtils.splitWhitespace(nextLine, this.tokens);
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.tokens[0];
        int start = Integer.parseInt(this.tokens[1]) - this.startBase;
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(this.tokens[2]) - this.startBase;
        }
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = this.tokens[3].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(this.tokens[4]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = this.tokens[5].trim();
            int n2 = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 8) {
            String colorString = this.tokens[8];
            feature.setColor(this.parseColor(colorString));
        }
        if (tokenCount > 11) {
            this.createExons(start, this.tokens, feature, chr, feature.getStrand());
        }
        return feature;
    }

    private void createExons(int start, String[] tokens, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]);
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n2 = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                int exonStart = start + Integer.parseInt(startsBuffer[i2]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i2]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                exon.setNumber(exonNumber);
                gene.addExon(exon);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }

    private Color parseColor(String colorString) {
        String[] rgb = new String[3];
        int nTokens = ParsingUtils.split(this.tokens[8].replaceAll("\"", ""), rgb, ',');
        try {
            if (nTokens < 3) {
                return new Color(Integer.parseInt(rgb[0]));
            }
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

