/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class IntTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public IntTable() {
        this.table = new Entry[11];
    }

    public IntTable(int c2) {
        this.table = new Entry[c2];
    }

    public IntTable(IntTable t) {
        this.count = t.count;
        this.table = new Entry[t.table.length];
        int i2 = 0;
        while (i2 < this.table.length) {
            Entry e2 = t.table[i2];
            Entry n2 = null;
            if (e2 != null) {
                this.table[i2] = n2 = new Entry(e2.hash, e2.key, e2.value, null);
                e2 = e2.next;
                while (e2 != null) {
                    n2 = n2.next = new Entry(e2.hash, e2.key, e2.value, null);
                    e2 = e2.next;
                }
            }
            ++i2;
        }
    }

    public int size() {
        return this.count;
    }

    protected Entry find(Object key) {
        return null;
    }

    public int get(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return 0;
    }

    public int put(Object key, int value) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                int old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = new Entry(hash, key, value, this.table[index]);
        return 0;
    }

    public int inc(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                return e2.value++;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = new Entry(hash, key, 1, this.table[index]);
        return 0;
    }

    public int dec(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                return e2.value--;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = new Entry(hash, key, -1, this.table[index]);
        return 0;
    }

    public int remove(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry p2 = null;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                int result = e2.value;
                if (p2 == null) {
                    this.table[index] = e2.next;
                } else {
                    p2.next = e2.next;
                }
                --this.count;
                return result;
            }
            p2 = e2;
            e2 = e2.next;
        }
        return 0;
    }

    public void clear() {
        int i2 = 0;
        while (i2 < this.table.length) {
            this.table[i2] = null;
            ++i2;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        int i2 = oldTable.length - 1;
        while (i2 >= 0) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
            --i2;
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public int value;
        public Entry next;

        public Entry(int hash, Object key, int value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

