/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.broad.igv.scatterplot.SymbolSettings;

public class SymbolFactory {
    private Color[] IGVDefaultColor = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.yellow, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.gray, Color.darkGray, Color.lightGray, Color.white};
    private IGVSymbolShape igvDefaultSymbolShape;
    private int igvShapeWidth;
    private int igvShapeHeight;
    private boolean igvShapeOutlined;
    private boolean igvShapeFilled;
    private ArrayList<Shape> igvSymbolShapeList;
    private ArrayList<Color> igvSymbolColorList;
    private ArrayList<SymbolSettings> igvSymbolSettingsList;

    public SymbolFactory() {
        this.igvSymbolSettingsList = new ArrayList();
    }

    public SymbolFactory(String[] categories, int shapeWidth, int shapeHeight, boolean isOutlined, boolean isFilled) {
        this.igvDefaultSymbolShape = IGVSymbolShape.SeriesSpecific;
        this.igvShapeWidth = shapeWidth;
        this.igvShapeHeight = shapeHeight;
        this.igvShapeOutlined = isOutlined;
        this.igvShapeFilled = isFilled;
        this.createDefaultSymbolSettings(categories);
    }

    public SymbolFactory(String[] categories, IGVSymbolShape defaultShape, int shapeWidth, int shapeHeight, boolean isOutlined, boolean isFilled) {
        this.igvDefaultSymbolShape = defaultShape;
        this.igvShapeWidth = shapeWidth;
        this.igvShapeHeight = shapeHeight;
        this.igvShapeOutlined = isOutlined;
        this.igvShapeFilled = isFilled;
        this.createDefaultSymbolSettings(categories);
    }

    public IGVSymbolShape getDefaultSymbolShape() {
        return this.igvDefaultSymbolShape;
    }

    public int getDefaultSymbolWidth() {
        return this.igvShapeWidth;
    }

    public int getIgvShapeHeight() {
        return this.igvShapeHeight;
    }

    public boolean isDefaultShapeOutlined() {
        return this.igvShapeOutlined;
    }

    public boolean isDefaultShapeFilled() {
        return this.igvShapeFilled;
    }

    public SymbolSettings[] getSeriesSymbolSettings() {
        int nSeries = this.igvSymbolSettingsList.size();
        if (this.igvSymbolSettingsList.size() == 0) {
            return null;
        }
        SymbolSettings[] seriesSymbolSettings = new SymbolSettings[nSeries];
        return this.igvSymbolSettingsList.toArray(seriesSymbolSettings);
    }

    public void addSeriesSymbol(int series, String category, Shape shape, Color color, boolean isOutlined, boolean isFilled) {
        boolean isVisible = true;
        SymbolSettings symbolSettings = new SymbolSettings(series, category, this.igvSymbolShapeList.get(series), this.igvSymbolColorList.get(series), isOutlined, isFilled, isVisible);
        this.igvSymbolSettingsList.add(series, symbolSettings);
    }

    static Shape createSymbolShape(IGVSymbolShape symbolShape, int width, int height) {
        Shape shape;
        if (symbolShape == IGVSymbolShape.Circle) {
            float radius = Math.min(width, height);
            float xPosition = -radius / 2.0f;
            float yPosition = -radius / 2.0f;
            shape = new Arc2D.Float(xPosition, yPosition, width, height, 0.0f, 360.0f, 0);
        } else if (symbolShape == IGVSymbolShape.Ellipse) {
            float xPosition = (float)(-width) / 2.0f;
            float yPosition = (float)(-height) / 2.0f;
            shape = new Ellipse2D.Float(xPosition, yPosition, width, height);
        } else if (symbolShape == IGVSymbolShape.Triangle) {
            int baseX = (int)((float)Math.min(width, height) / 2.0f);
            int baseY = (int)((float)Math.max(width, height) / 2.0f);
            int[] xPoints = new int[]{-baseX, 0, baseX};
            int[] yPoints = new int[]{baseY, -baseY, baseY};
            shape = new Polygon(xPoints, yPoints, 3);
        } else if (symbolShape == IGVSymbolShape.Square) {
            width = Math.min(width, height);
            float xPosition = (float)(-width) / 2.0f;
            float yPosition = (float)(-height) / 2.0f;
            shape = new Rectangle2D.Float(xPosition, yPosition, width, height);
        } else if (symbolShape == IGVSymbolShape.Rectangle) {
            float xPosition = (float)(-width) / 2.0f;
            float yPosition = (float)(-height) / 2.0f;
            shape = new Rectangle2D.Float(xPosition, yPosition, width, height);
        } else if (symbolShape == IGVSymbolShape.Diamond) {
            int baseX = (int)((float)Math.min(width, height) / 2.0f);
            int baseY = (int)((float)Math.max(width, height) / 2.0f);
            int[] xPoints = new int[]{-baseX, 0, baseX, 0};
            int[] yPoints = new int[]{0, -baseY, 0, baseY};
            shape = new Polygon(xPoints, yPoints, 4);
        } else if (symbolShape == IGVSymbolShape.Gradient) {
            int baseX = (int)((float)Math.min(width, height) / 2.0f);
            int baseY = (int)((float)Math.max(width, height) / 2.0f);
            int[] xPoints = new int[]{-baseX, 0, baseX};
            int[] yPoints = new int[]{-baseY, baseY, -baseY};
            shape = new Polygon(xPoints, yPoints, 3);
        } else if (symbolShape == IGVSymbolShape.Octagon) {
            int baseX = (int)((float)Math.max(width, height) / 4.0f);
            int baseY = (int)((float)Math.max(width, height) / 4.0f);
            int[] xPoints = new int[]{-baseX * 2, -baseX, baseX, baseX * 2, baseX * 2, baseX, -baseX, -baseX * 2};
            int[] yPoints = new int[]{-baseY, -baseY * 2, -baseY * 2, -baseY, baseY, baseY * 2, baseY * 2, baseY};
            shape = new Polygon(xPoints, yPoints, 8);
        } else {
            shape = null;
        }
        return shape;
    }

    private void createDefaultSymbolSettings(String[] categories) {
        int nSeries = categories.length;
        this.setupSymbolShapes(nSeries);
        this.setupSymbolColors(nSeries);
        boolean isVisible = true;
        this.igvSymbolSettingsList = new ArrayList();
        for (int series = 0; series < nSeries; ++series) {
            SymbolSettings symbolSettings = new SymbolSettings(series, categories[series], this.igvSymbolShapeList.get(series), this.igvSymbolColorList.get(series), this.igvShapeOutlined, this.igvShapeFilled, isVisible);
            this.igvSymbolSettingsList.add(symbolSettings);
        }
    }

    private void setupSymbolShapes(int nSeries) {
        this.igvSymbolShapeList = new ArrayList();
        if (this.igvDefaultSymbolShape.compareTo(IGVSymbolShape.SeriesSpecific) != 0) {
            Shape shape = SymbolFactory.createSymbolShape(this.igvDefaultSymbolShape, this.igvShapeWidth, this.igvShapeHeight);
            for (int series = 0; series < nSeries; ++series) {
                this.igvSymbolShapeList.add(shape);
            }
        } else {
            IGVSymbolShape[] shapes = IGVSymbolShape.values();
            for (int series = 0; series < nSeries; ++series) {
                this.igvSymbolShapeList.add(SymbolFactory.createSymbolShape(shapes[series + 1], this.igvShapeWidth, this.igvShapeHeight));
            }
        }
    }

    private void setupSymbolColors(int nSeries) {
        this.igvSymbolColorList = new ArrayList();
        for (int series = 0; series < nSeries; ++series) {
            this.igvSymbolColorList.add(this.IGVDefaultColor[series + 1]);
        }
    }

    public static enum IGVSymbolShape {
        SeriesSpecific,
        Circle,
        Triangle,
        Rectangle,
        Ellipse,
        Diamond,
        Gradient,
        Pentagon,
        Hexagon,
        Octagon,
        Ring,
        Oval,
        Square;

    }
}

