/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.scatterplot.ScatterPlotData;
import org.broad.igv.scatterplot.SymbolFactory;
import org.broad.igv.scatterplot.SymbolSettings;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class ScatterPlot
extends JFrame {
    private String igvTitle;
    private ScatterPlotData igvPlotData;
    private JFreeChart igvScatterPlotChart;
    private int igvXFrameStart;
    private int igvYFrameStart;
    private int igvXFrameDimension;
    private int igvYFrameDimension;
    private Container igvFrameContent;
    private BorderLayout igvBorderLayout;
    private JPanel igvSampleListPanel;
    private ChartPanel igvPlotPanel;
    private JPanel igvAttributeLegendPanel;
    private JFreeChart igvScatterChart;
    private JButton igvUpdateButton;
    private JComboBox igvXAxisComboBox;
    private int igvXAxisIndex;
    private String igvXAxisName;
    private JComboBox igvYAxisComboBox;
    private int igvYAxisIndex;
    private String igvYAxisName;
    private JComboBox igvSymbolComboBox;
    private int igvSymbolIndex;
    private String igvAttributeName;
    private String[] igvDataNames;
    private String[] igvSymbolNames;
    private XYSeriesCollection igvXYSeriesDataset;
    private SymbolSettings[] igvSymbolSettings;
    private SymbolFactory igvSymbolFactory;

    public ScatterPlot(String title, ScatterPlotData scatterPlotData) {
        super("IGV Scatter Plot Version 1.0");
        this.igvTitle = title;
        this.igvPlotData = scatterPlotData;
        this.igvXAxisIndex = 0;
        this.igvYAxisIndex = 1;
        this.igvXAxisName = this.igvPlotData.getDataKeyName(this.igvXAxisIndex);
        this.igvYAxisName = this.igvPlotData.getDataKeyName(this.igvYAxisIndex);
        ArrayList<String> dataNameList = this.igvPlotData.getDataNames();
        this.igvDataNames = dataNameList.toArray(new String[0]);
        ArrayList<String> symbolNameList = this.igvPlotData.getSymbolNames();
        this.igvSymbolNames = symbolNameList.toArray(new String[0]);
        this.igvSymbolIndex = 0;
        this.igvAttributeName = this.igvPlotData.getSymbolKeyName(this.igvSymbolIndex);
        Toolkit theKit = this.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        this.igvXFrameStart = wndSize.width / 4;
        this.igvYFrameStart = wndSize.height / 4;
        this.igvXFrameDimension = wndSize.width / 2;
        this.igvYFrameDimension = wndSize.height / 2;
        super.setBounds(this.igvXFrameStart, this.igvYFrameStart, this.igvXFrameDimension, this.igvYFrameDimension);
        super.setDefaultCloseOperation(3);
        this.igvBorderLayout = new BorderLayout();
        this.igvFrameContent = super.getContentPane();
        this.igvFrameContent.setLayout(this.igvBorderLayout);
        EtchedBorder edge = new EtchedBorder(0);
        JPanel axisSelectPanel = this.createDataSelectionPanel(this.igvDataNames, this.igvXAxisIndex, this.igvYAxisIndex, this.igvSymbolIndex, this.igvSymbolNames);
        this.igvFrameContent.add((Component)axisSelectPanel, "North");
        this.igvAttributeLegendPanel = this.createAttributeSymbolPanel(this.igvAttributeName);
        this.igvFrameContent.add((Component)this.igvAttributeLegendPanel, "East");
        this.igvPlotPanel = this.createScatterPlotPanel(this.igvTitle, this.igvPlotData, this.igvXAxisName, this.igvYAxisName, this.igvAttributeName, this.igvSymbolSettings);
        this.igvFrameContent.add((Component)this.igvPlotPanel, "Center");
        this.setVisible(true);
    }

    private JPanel createDataSelectionPanel(String[] dataNames, int xAxisIndex, int yAxisIndex, int symbolIndex, String[] symbolNames) {
        JPanel axisSelectPanel = new JPanel();
        axisSelectPanel.setLayout(new BoxLayout(axisSelectPanel, 0));
        axisSelectPanel.add(Box.createHorizontalGlue());
        JPanel xAxisPanel = this.createXAxisSelectionPanel(dataNames, xAxisIndex);
        axisSelectPanel.add(xAxisPanel);
        axisSelectPanel.add(Box.createHorizontalStrut(20));
        JPanel yAxisPanel = this.createYAxisSelectionPanel(dataNames, yAxisIndex);
        axisSelectPanel.add(yAxisPanel);
        axisSelectPanel.add(Box.createHorizontalStrut(20));
        JPanel symbolSelectionPanel = this.createAttributeSelectionPanel(symbolNames, this.igvSymbolIndex);
        axisSelectPanel.add(symbolSelectionPanel);
        axisSelectPanel.add(Box.createHorizontalGlue());
        return axisSelectPanel;
    }

    private JPanel createXAxisSelectionPanel(String[] dataNames, int selectedIndex) {
        JPanel xAxisPanel = new JPanel();
        xAxisPanel.setLayout(new BoxLayout(xAxisPanel, 1));
        xAxisPanel.add(new JLabel("X Axis"));
        this.igvXAxisComboBox = new JComboBox<String>(dataNames);
        this.igvXAxisComboBox.setMaximumRowCount(dataNames.length);
        this.igvXAxisComboBox.setMaximumSize(new Dimension(150, 20));
        this.igvXAxisComboBox.setMinimumSize(new Dimension(150, 20));
        this.igvXAxisComboBox.setSelectedIndex(selectedIndex);
        xAxisPanel.add(this.igvXAxisComboBox);
        this.igvXAxisComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    ScatterPlot.this.igvXAxisIndex = ScatterPlot.this.igvXAxisComboBox.getSelectedIndex();
                }
                ScatterPlot.this.drawScatterplot();
            }
        });
        return xAxisPanel;
    }

    private JPanel createYAxisSelectionPanel(String[] dataNames, int selectedIndex) {
        JPanel yAxisPanel = new JPanel();
        yAxisPanel.setLayout(new BoxLayout(yAxisPanel, 1));
        yAxisPanel.add(new JLabel("Y Axis"));
        this.igvYAxisComboBox = new JComboBox<String>(dataNames);
        this.igvYAxisComboBox.setMaximumRowCount(dataNames.length);
        this.igvYAxisComboBox.setMaximumSize(new Dimension(150, 20));
        this.igvYAxisComboBox.setMinimumSize(new Dimension(150, 20));
        this.igvYAxisComboBox.setSelectedIndex(selectedIndex);
        yAxisPanel.add(this.igvYAxisComboBox);
        this.igvYAxisComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    ScatterPlot.this.igvYAxisIndex = ScatterPlot.this.igvYAxisComboBox.getSelectedIndex();
                }
                ScatterPlot.this.drawScatterplot();
            }
        });
        return yAxisPanel;
    }

    private JPanel createAttributeSelectionPanel(String[] symbolNames, int selectedIndex) {
        JPanel symbolPanel = new JPanel();
        symbolPanel.setLayout(new BoxLayout(symbolPanel, 1));
        symbolPanel.add(new JLabel("Attributes"));
        this.igvSymbolComboBox = new JComboBox<String>(symbolNames);
        this.igvSymbolComboBox.setMaximumRowCount(symbolNames.length);
        this.igvSymbolComboBox.setMaximumSize(new Dimension(150, 20));
        this.igvSymbolComboBox.setMinimumSize(new Dimension(150, 20));
        this.igvSymbolComboBox.setSelectedIndex(selectedIndex);
        symbolPanel.add(this.igvSymbolComboBox);
        this.igvSymbolComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    ScatterPlot.this.igvSymbolIndex = ScatterPlot.this.igvSymbolComboBox.getSelectedIndex();
                }
                ScatterPlot.this.drawScatterplot();
            }
        });
        return symbolPanel;
    }

    private JPanel createAttributeSymbolPanel(String attribute) {
        JPanel attributeLegendPanel = new JPanel();
        TitledBorder attributeBorder = new TitledBorder(attribute + ":");
        attributeLegendPanel.setBorder(attributeBorder);
        attributeLegendPanel.setLayout(new BoxLayout(attributeLegendPanel, 1));
        String[] categories = this.igvPlotData.getAttributeCategories(attribute);
        int shapeWidth = 4;
        int shapeHeight = 3;
        boolean isOutlined = true;
        boolean isFilled = true;
        this.igvSymbolFactory = new SymbolFactory(categories, shapeWidth, shapeHeight, isOutlined, isFilled);
        this.igvSymbolSettings = this.igvSymbolFactory.getSeriesSymbolSettings();
        int nSeries = this.igvSymbolSettings.length;
        for (int series = 0; series < nSeries; ++series) {
            SymbolPanel symbolPanel = new SymbolPanel(this.igvSymbolSettings[series]);
            attributeLegendPanel.add(symbolPanel);
        }
        return attributeLegendPanel;
    }

    private void createToolTips(XYItemRenderer renderer) {
        renderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator(){

            @Override
            public String generateToolTip(XYDataset data, int series, int item) {
                XYSeries xySeries = ((XYSeriesCollection)data).getSeries(series);
                IGVXYDataItem dataItem = (IGVXYDataItem)xySeries.getDataItem(item);
                String htmlResult = dataItem.getLabel();
                return htmlResult;
            }
        });
    }

    private ChartPanel createScatterPlotPanel(String title, ScatterPlotData igvData, String xAxisName, String yAxisName, String attribute, SymbolSettings[] symbolSettings) {
        this.igvScatterChart = this.createChart(title, igvData, xAxisName, yAxisName, attribute, symbolSettings);
        ChartPanel panel = new ChartPanel(this.igvScatterChart);
        panel.setMouseWheelEnabled(true);
        return panel;
    }

    private JFreeChart createChart(String title, ScatterPlotData igvData, String xAxisName, String yAxisName, String attribute, SymbolSettings[] symbolSettings) {
        double[] xValues = igvData.getDataValues(xAxisName);
        double[] yValues = igvData.getDataValues(yAxisName);
        if (yValues == null | xValues == null | yValues.length != xValues.length) {
            return null;
        }
        int allPoints = xValues.length;
        double[][] xyData = new double[2][allPoints];
        for (int i2 = 0; i2 < allPoints; ++i2) {
            xyData[0][i2] = xValues[i2];
            xyData[1][i2] = yValues[i2];
        }
        int nSeries = symbolSettings.length;
        String[] attributeValues = igvData.getSymbolValues(attribute);
        this.igvXYSeriesDataset = new XYSeriesCollection();
        for (int series = 0; series < nSeries; ++series) {
            String category = symbolSettings[series].getCategory();
            XYSeries xySeries = new XYSeries((Comparable)((Object)category));
            for (int dataIndex = 0; dataIndex < allPoints; ++dataIndex) {
                if (!attributeValues[dataIndex].equals(category)) continue;
                boolean isHTML = true;
                String tooltips = this.igvPlotData.getSampleDescription(dataIndex, isHTML);
                IGVXYDataItem item = new IGVXYDataItem(xyData[0][dataIndex], xyData[1][dataIndex], tooltips);
                xySeries.add(item);
            }
            this.igvXYSeriesDataset.addSeries(xySeries);
        }
        this.igvScatterPlotChart = ChartFactory.createScatterPlot(null, xAxisName, yAxisName, this.igvXYSeriesDataset, PlotOrientation.VERTICAL, false, true, false);
        TextTitle chartTitle = new TextTitle(title, new Font("Tahoma", 1, 10));
        this.igvScatterPlotChart.addSubtitle(chartTitle);
        XYPlot plot = this.igvScatterPlotChart.getXYPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        int seriesCount = this.igvXYSeriesDataset.getSeriesCount();
        for (int series = 0; series < nSeries; ++series) {
            Shape shape = symbolSettings[series].getPlotShape();
            renderer.setSeriesShape(series, shape);
            Color color = symbolSettings[series].getPlotColor();
            renderer.setSeriesPaint(series, color);
            if (symbolSettings[series].isFilled()) {
                // empty if block
            }
            if (symbolSettings[series].isOutlined()) {
                // empty if block
            }
            boolean visible = symbolSettings[series].isVisible();
            renderer.setSeriesVisible(series, (Boolean)visible);
        }
        LegendTitle legend = new LegendTitle(this.igvScatterPlotChart.getPlot());
        BlockContainer wrapper = new BlockContainer(new BorderArrangement());
        wrapper.setFrame(new BlockBorder(1.0, 1.0, 1.0, 1.0));
        LabelBlock legendTitle = new LabelBlock(attribute + ":");
        legendTitle.setPadding(5.0, 5.0, 5.0, 5.0);
        wrapper.add(legendTitle, RectangleEdge.TOP);
        BlockContainer items = legend.getItemContainer();
        items.setPadding(2.0, 10.0, 5.0, 2.0);
        wrapper.add(items);
        legend.setWrapper(wrapper);
        for (int series = 0; series < nSeries; ++series) {
            int itemCount = this.igvXYSeriesDataset.getSeries(series).getItemCount();
            Shape shape = renderer.getSeriesShape(series);
            Paint color = renderer.getSeriesPaint(series);
            Paint fillcolor = renderer.getSeriesFillPaint(series);
        }
        this.createToolTips(renderer);
        plot.setRenderer(renderer);
        plot.setDomainCrosshairVisible(true);
        plot.setDomainCrosshairLockedOnData(true);
        plot.setRangeCrosshairVisible(true);
        plot.setRangeCrosshairLockedOnData(true);
        plot.setDomainZeroBaselineVisible(true);
        plot.setRangeZeroBaselineVisible(true);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        legend.setPosition(RectangleEdge.RIGHT);
        legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.igvScatterPlotChart.addSubtitle(legend);
        ChartUtilities.applyCurrentTheme(this.igvScatterPlotChart);
        return this.igvScatterPlotChart;
    }

    private void drawScatterplot() {
        String xAxisName = this.igvPlotData.getDataKeyName(this.igvXAxisIndex);
        String yAxisName = this.igvPlotData.getDataKeyName(this.igvYAxisIndex);
        this.igvAttributeName = this.igvPlotData.getSymbolKeyName(this.igvSymbolIndex);
        this.igvFrameContent.remove(this.igvAttributeLegendPanel);
        this.igvAttributeLegendPanel = this.createAttributeSymbolPanel(this.igvAttributeName);
        this.igvFrameContent.add((Component)this.igvAttributeLegendPanel, "East");
        this.igvFrameContent.validate();
        this.igvScatterPlotChart = this.createChart(this.igvTitle, this.igvPlotData, xAxisName, yAxisName, this.igvAttributeName, this.igvSymbolSettings);
        this.igvPlotPanel.setChart(this.igvScatterPlotChart);
    }

    private void updateScatterplot() {
        XYPlot plot = this.igvScatterPlotChart.getXYPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        int nSeries = this.igvSymbolSettings.length;
        for (int series = 0; series < nSeries; ++series) {
            boolean visible = this.igvSymbolSettings[series].isVisible();
            renderer.setSeriesVisible(series, (Boolean)visible);
        }
    }

    private class IGVStandardChartTheme
    extends StandardChartTheme {
        public IGVStandardChartTheme(Title title) {
            super("IGVScatterPlotTheme");
            this.applyToTitle(title);
        }
    }

    private class IGVXYDataItem
    extends XYDataItem {
        private String label;

        public IGVXYDataItem(Number number, Number number1, String label) {
            super(number, number1);
            this.label = null;
            this.label = label;
        }

        public IGVXYDataItem(double n2, double n1, String label) {
            super(n2, n1);
            this.label = null;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private class SymbolPanel
    extends JPanel {
        private SymbolSettings settings;
        private JCheckBox categoryCheckBox;

        public SymbolPanel(SymbolSettings settings) {
            this.settings = settings;
            this.setLayout(new FlowLayout(0));
            this.setMinimumSize(new Dimension(150, 50));
            this.setMaximumSize(new Dimension(150, 50));
            this.setPreferredSize(new Dimension(150, 50));
            this.categoryCheckBox = new JCheckBox(settings.getCategory());
            this.add(this.categoryCheckBox);
            this.categoryCheckBox.setSelected(settings.isVisible());
            CheckBoxHandler handler = new CheckBoxHandler();
            this.categoryCheckBox.addItemListener(handler);
        }

        private class LegendIcon
        extends JPanel {
            private Shape shape;
            private Color color;

            public LegendIcon(Shape shape, Color color) {
                Rectangle2D.Float iconShape = new Rectangle2D.Float();
                Rectangle bounds = shape.getBounds();
                iconShape.setRect(0.0f, 0.0f, 3 * bounds.width, 3 * bounds.height);
                this.shape = iconShape;
                this.color = color;
            }

            @Override
            public void paint(Graphics g2) {
                Graphics2D g22 = (Graphics2D)g2;
                g22.setColor(this.color);
                g22.fill(this.shape);
            }

            public int getIconWidth() {
                Rectangle bounds = this.shape.getBounds();
                return bounds.width;
            }

            public int getIconHeight() {
                Rectangle bounds = this.shape.getBounds();
                return bounds.height;
            }

            public Color getColor() {
                return this.color;
            }
        }

        private class CheckBoxHandler
        implements ItemListener {
            private CheckBoxHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean visible = SymbolPanel.this.categoryCheckBox.isSelected();
                ScatterPlot.this.igvSymbolSettings[SymbolPanel.this.settings.getSeries()].setVisible(visible);
                ScatterPlot.this.updateScatterplot();
            }
        }
    }
}

