/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.graph.Edge;
import org.broad.igv.graph.Node;
import org.broad.igv.graph.SubGraph;

public class Graph {
    int maxX = Integer.MIN_VALUE;
    int minX = Integer.MAX_VALUE;
    Set<Node> nodes = new HashSet<Node>();
    List<SubGraph> subGraphs = new ArrayList<SubGraph>();

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void updateLayout() {
        this.alg2();
    }

    private void alg2() {
        NodeGrid grid = new NodeGrid();
        Collections.sort(this.subGraphs, new Comparator<SubGraph>(){

            @Override
            public int compare(SubGraph sg1, SubGraph sg2) {
                return sg2.getSize() - sg1.getSize();
            }
        });
        int level = 0;
        for (SubGraph sg : this.subGraphs) {
            for (Edge edge : sg.edges) {
                Node n2;
                Node n1 = edge.getParent();
                if (n1.getCellY() == Integer.MIN_VALUE) {
                    grid.addNode(n1, level);
                }
                if ((n2 = edge.getChild()).getCellY() != Integer.MIN_VALUE) continue;
                grid.addNode(n2, level);
            }
            ++level;
        }
    }

    private void alg1() {
        HashMap<Integer, ArrayList<Node>> nodeMap = new HashMap<Integer, ArrayList<Node>>();
        for (Node node : this.nodes) {
            Integer cellX = node.getCellX();
            ArrayList<Node> nodeList = (ArrayList<Node>)nodeMap.get(cellX);
            if (nodeList == null) {
                nodeList = new ArrayList<Node>();
                nodeMap.put(cellX, nodeList);
            }
            nodeList.add(node);
        }
        int maxY = 0;
        for (List nodeList : nodeMap.values()) {
            maxY = Math.max(nodeList.size(), maxY);
        }
        for (List nodeList : nodeMap.values()) {
            int initY = (maxY - nodeList.size()) / 2;
            for (int listPosition = 0; listPosition < nodeList.size(); ++listPosition) {
                Node node = (Node)nodeList.get(listPosition);
                node.setCellY(initY + listPosition);
            }
        }
    }

    public void addSubGraph(SubGraph sg) {
        this.subGraphs.add(sg);
        this.maxX = Math.max(this.maxX, sg.getMaxX());
        this.minX = Math.min(this.minX, sg.getMinX());
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinX() {
        return this.minX;
    }

    public List<SubGraph> getSubGraphs() {
        return this.subGraphs;
    }

    class NodeGrid {
        Map<Integer, List<Node>> nodeMap = new HashMap<Integer, List<Node>>();

        NodeGrid() {
        }

        public void addNode(Node node, int level) {
            int x = node.getCellX();
            List<Node> nodeList = this.nodeMap.get(x);
            if (nodeList == null) {
                nodeList = new ArrayList<Node>();
                this.nodeMap.put(x, nodeList);
            }
            int y = nodeList.size();
            node.setCellY(y);
            nodeList.add(node);
        }
    }
}

