/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import apple.laf.AquaImageFactory;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import sun.java2d.SunGraphics2D;

public class AquaPainter
extends BasicPainter {
    private static final Logger LOGGER = Logger.getLogger(AquaPainter.class.getName());
    private static AquaPainter _instance;
    private static final ImageIcon SELECTED;
    private static final ImageIcon ROLLOVER;
    private static final ImageIcon PRESSED;
    private static final Color ROLLOVER_BACKGROUND;
    private static final Color SELECTED_BACKGROUND;
    private static final Color PRESSED_BACKGROUND;
    private static boolean _errorOccurred;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new AquaPainter();
        }
        return _instance;
    }

    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (n3 == 0) {
            super.paintButtonBackground(jComponent, graphics, rectangle, n2, n3);
        } else if (n3 == 2) {
            this.paintImageBorder(graphics, rectangle, ROLLOVER, ROLLOVER_BACKGROUND);
        } else if (n3 == 3) {
            this.paintImageBorder(graphics, rectangle, SELECTED, SELECTED_BACKGROUND);
        } else if (n3 == 1) {
            this.paintImageBorder(graphics, rectangle, PRESSED, PRESSED_BACKGROUND);
        }
    }

    private void paintImageBorder(Graphics graphics, Rectangle rectangle, ImageIcon imageIcon, Color color) {
        JideSwingUtilities.drawImageBorder(graphics, imageIcon, rectangle, new Insets(3, 3, 3, 3), false);
        if (color != null) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(rectangle.x + 3, rectangle.y + 3, rectangle.width - 6, rectangle.height - 6);
            graphics.setColor(color2);
        }
    }

    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)graphics), (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height, (boolean)true, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception exception) {
                _errorOccurred = true;
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(jComponent, graphics, rectangle, n2, n3);
    }

    public void paintCollapsiblePaneTitlePaneBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)graphics), (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height, (boolean)false, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception exception) {
                _errorOccurred = true;
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackground(jComponent, graphics, rectangle, n2, n3);
    }

    public void paintDockableFrameTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)graphics), (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height, (n3 == 3 ? 1 : 0) != 0, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception exception) {
                _errorOccurred = true;
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
        super.paintDockableFrameTitlePane(jComponent, graphics, rectangle, n2, n3);
    }

    public void paintCommandBarTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)graphics), (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height, (boolean)true, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception exception) {
                _errorOccurred = true;
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
        super.paintCommandBarTitlePane(jComponent, graphics, rectangle, n2, n3);
    }

    static {
        SELECTED = IconsFactory.getImageIcon(AquaPainter.class, "icons/selected.gif");
        ROLLOVER = IconsFactory.getImageIcon(AquaPainter.class, "icons/rollover.gif");
        PRESSED = IconsFactory.getImageIcon(AquaPainter.class, "icons/pressed.gif");
        ROLLOVER_BACKGROUND = new Color(238, 238, 238);
        SELECTED_BACKGROUND = new Color(153, 153, 153);
        PRESSED_BACKGROUND = new Color(195, 195, 195);
    }
}

