/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.DiskBasedBAMFileIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SeekableStream;
import net.sf.samtools.util.StringLineReader;

class BAMFileReader
extends SAMFileReader.ReaderImplementation {
    private boolean mIsSeekable = false;
    private BinaryCodec mStream = null;
    private final BlockCompressedInputStream mCompressedInputStream;
    private SAMFileHeader mFileHeader = null;
    private File mIndexFile;
    private BAMIndex mIndex = null;
    private long mFirstRecordPointer = 0L;
    private CloseableIterator<SAMRecord> mCurrentIterator = null;
    private final boolean eagerDecode;
    private SAMFileReader.ValidationStringency mValidationStringency;
    private boolean mEnableIndexCaching = false;
    private boolean mEnableIndexMemoryMapping = true;
    private SAMFileReader mFileReader = null;

    BAMFileReader(InputStream stream, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency) throws IOException {
        this.mIndexFile = indexFile;
        this.mIsSeekable = false;
        this.mCompressedInputStream = new BlockCompressedInputStream(stream);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.readHeader(null);
    }

    BAMFileReader(File file, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency) throws IOException {
        this(new BlockCompressedInputStream(file), indexFile != null ? indexFile : BAMFileReader.findIndexFile(file), eagerDecode, file.getAbsolutePath(), validationStringency);
        if (this.mIndexFile != null && this.mIndexFile.lastModified() < file.lastModified()) {
            System.err.println("WARNING: BAM index file " + this.mIndexFile.getAbsolutePath() + " is older than BAM " + file.getAbsolutePath());
        }
    }

    BAMFileReader(SeekableStream strm, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency) throws IOException {
        this(new BlockCompressedInputStream(strm), indexFile, eagerDecode, strm.getSource(), validationStringency);
    }

    private BAMFileReader(BlockCompressedInputStream compressedInputStream, File indexFile, boolean eagerDecode, String source, SAMFileReader.ValidationStringency validationStringency) throws IOException {
        this.mIndexFile = indexFile;
        this.mIsSeekable = true;
        this.mCompressedInputStream = compressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.readHeader(source);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    @Override
    void enableFileSource(SAMFileReader reader, boolean enabled) {
        this.mFileReader = enabled ? reader : null;
    }

    @Override
    public void enableIndexCaching(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mEnableIndexCaching = enabled;
    }

    @Override
    public void enableIndexMemoryMapping(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mEnableIndexMemoryMapping = enabled;
    }

    @Override
    void enableCrcChecking(boolean enabled) {
        this.mCompressedInputStream.setCheckCrcs(enabled);
    }

    @Override
    public boolean hasIndex() {
        return this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (this.mIndexFile == null) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping);
        }
        return this.mIndex;
    }

    @Override
    void close() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        if (this.mIndex != null) {
            this.mIndex.close();
        }
        this.mStream = null;
        this.mFileHeader = null;
        this.mIndex = null;
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    SAMFileReader.ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIsSeekable) {
            try {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }
        this.mCurrentIterator = new BAMFileIterator();
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator(SAMFileSpan chunks) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!(chunks instanceof BAMFileSpan)) {
            throw new IllegalStateException("BAMFileReader cannot handle this type of file span.");
        }
        this.mCurrentIterator = new BAMFileIndexIterator(((BAMFileSpan)chunks).toCoordinateArray());
        return this.mCurrentIterator;
    }

    @Override
    SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.mFirstRecordPointer, Long.MAX_VALUE));
    }

    @Override
    CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(sequence, start, end, contained ? QueryType.CONTAINED : QueryType.OVERLAPPING);
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(sequence, start, -1, QueryType.STARTING_AT);
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        try {
            long startOfLastLinearBin = this.getIndex().getStartOfLastLinearBin();
            if (startOfLastLinearBin != -1L) {
                this.mCompressedInputStream.seek(startOfLastLinearBin);
            } else {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            this.mCurrentIterator = new BAMFileIndexUnmappedIterator();
            return this.mCurrentIterator;
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException seeking to unmapped reads", e2);
        }
    }

    private void readHeader(String source) throws IOException {
        byte[] buffer = new byte[4];
        this.mStream.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_MAGIC)) {
            throw new IOException("Invalid BAM file header");
        }
        int headerTextLength = this.mStream.readInt();
        String textHeader = this.mStream.readString(headerTextLength);
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        headerCodec.setValidationStringency(this.mValidationStringency);
        this.mFileHeader = headerCodec.decode(new StringLineReader(textHeader), source);
        int sequenceCount = this.mStream.readInt();
        if (this.mFileHeader.getSequenceDictionary().size() > 0) {
            if (sequenceCount != this.mFileHeader.getSequenceDictionary().size()) {
                throw new SAMFormatException("Number of sequences in text header (" + this.mFileHeader.getSequenceDictionary().size() + ") != number of sequences in binary header (" + sequenceCount + ") for file " + source);
            }
            for (int i2 = 0; i2 < sequenceCount; ++i2) {
                SAMSequenceRecord binarySequenceRecord = this.readSequenceRecord(source);
                SAMSequenceRecord sequenceRecord = this.mFileHeader.getSequence(i2);
                if (!sequenceRecord.getSequenceName().equals(binarySequenceRecord.getSequenceName())) {
                    throw new SAMFormatException("For sequence " + i2 + ", text and binary have different names in file " + source);
                }
                if (sequenceRecord.getSequenceLength() == binarySequenceRecord.getSequenceLength()) continue;
                throw new SAMFormatException("For sequence " + i2 + ", text and binary have different lengths in file " + source);
            }
        } else {
            ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>(sequenceCount);
            for (int i3 = 0; i3 < sequenceCount; ++i3) {
                sequences.add(this.readSequenceRecord(source));
            }
            this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(sequences));
        }
    }

    private SAMSequenceRecord readSequenceRecord(String source) {
        int nameLength = this.mStream.readInt();
        if (nameLength <= 1) {
            throw new SAMFormatException("Invalid BAM file header: missing sequence name in file " + source);
        }
        String sequenceName = this.mStream.readString(nameLength - 1);
        this.mStream.readByte();
        int sequenceLength = this.mStream.readInt();
        return new SAMSequenceRecord(SAMSequenceRecord.truncateSequenceName(sequenceName), sequenceLength);
    }

    private CloseableIterator<SAMRecord> createIndexIterator(String sequence, int start, int end, QueryType queryType) {
        long[] filePointers = null;
        SAMFileHeader fileHeader = this.getFileHeader();
        int referenceIndex = fileHeader.getSequenceIndex(sequence);
        if (referenceIndex != -1) {
            BAMIndex fileIndex = this.getIndex();
            BAMFileSpan fileSpan = fileIndex.getSpanOverlapping(referenceIndex, start, end);
            filePointers = fileSpan != null ? fileSpan.toCoordinateArray() : null;
        }
        BAMFileIndexIterator iterator = new BAMFileIndexIterator(filePointers);
        return new BAMQueryFilteringIterator(iterator, sequence, start, end, queryType);
    }

    private static File findIndexFile(File dataFile) {
        File indexFile;
        String bamExtension = ".bam";
        String fileName = dataFile.getName();
        if (fileName.endsWith(".bam")) {
            String bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai";
            indexFile = new File(dataFile.getParent(), bai);
            if (indexFile.exists()) {
                return indexFile;
            }
        }
        if ((indexFile = new File(dataFile.getParent(), dataFile.getName() + ".bai")).exists()) {
            return indexFile;
        }
        return null;
    }

    private class BAMFileIndexUnmappedIterator
    extends BAMFileIterator {
        private BAMFileIndexUnmappedIterator() {
            while (this.hasNext() && this.peek().getReferenceIndex() != -1) {
                this.advance();
            }
        }
    }

    private class BAMQueryFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord mNextRecord;
        private final int mReferenceIndex;
        private final int mRegionStart;
        private final int mRegionEnd;
        private final QueryType mQueryType;

        public BAMQueryFilteringIterator(CloseableIterator<SAMRecord> iterator, String sequence, int start, int end, QueryType queryType) {
            this.wrappedIterator = iterator;
            SAMFileHeader fileHeader = BAMFileReader.this.getFileHeader();
            this.mReferenceIndex = fileHeader.getSequenceIndex(sequence);
            this.mRegionStart = start;
            this.mRegionEnd = queryType == QueryType.STARTING_AT ? this.mRegionStart : (end <= 0 ? Integer.MAX_VALUE : end);
            this.mQueryType = queryType;
            this.mNextRecord = this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BAMQueryFilteringIterator: no next element available");
            }
            SAMRecord currentRead = this.mNextRecord;
            this.mNextRecord = this.advance();
            return currentRead;
        }

        @Override
        public void close() {
            if (this != BAMFileReader.this.mCurrentIterator) {
                throw new IllegalStateException("Attempt to close non-current iterator");
            }
            BAMFileReader.this.mCurrentIterator = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        SAMRecord advance() {
            SAMRecord record;
            while (true) {
                int alignmentEnd;
                if (!this.wrappedIterator.hasNext()) {
                    return null;
                }
                record = (SAMRecord)this.wrappedIterator.next();
                int referenceIndex = record.getReferenceIndex();
                if (referenceIndex != this.mReferenceIndex) {
                    if (referenceIndex >= 0 && referenceIndex <= this.mReferenceIndex) continue;
                    return null;
                }
                if (this.mRegionStart == 0 && this.mRegionEnd == Integer.MAX_VALUE) {
                    return record;
                }
                int alignmentStart = record.getAlignmentStart();
                if (this.mQueryType == QueryType.STARTING_AT) {
                    alignmentEnd = -1;
                } else {
                    int n2 = alignmentEnd = record.getAlignmentEnd() != 0 ? record.getAlignmentEnd() : alignmentStart;
                }
                if (alignmentStart > this.mRegionEnd) {
                    return null;
                }
                if (this.mQueryType == QueryType.CONTAINED ? alignmentStart >= this.mRegionStart && alignmentEnd <= this.mRegionEnd : (this.mQueryType == QueryType.OVERLAPPING ? alignmentEnd >= this.mRegionStart && alignmentStart <= this.mRegionEnd : alignmentStart == this.mRegionStart)) break;
            }
            return record;
        }
    }

    private class BAMFileIndexIterator
    extends BAMFileIterator {
        private long[] mFilePointers;
        private int mFilePointerIndex;
        private long mFilePointerLimit;

        BAMFileIndexIterator(long[] filePointers) {
            super(false);
            this.mFilePointers = null;
            this.mFilePointerIndex = 0;
            this.mFilePointerLimit = -1L;
            this.mFilePointers = filePointers;
            this.advance();
        }

        @Override
        SAMRecord getNextRecord() throws IOException {
            while (BAMFileReader.this.mCompressedInputStream.getFilePointer() >= this.mFilePointerLimit) {
                if (this.mFilePointers == null || this.mFilePointerIndex >= this.mFilePointers.length) {
                    return null;
                }
                long startOffset = this.mFilePointers[this.mFilePointerIndex++];
                long endOffset = this.mFilePointers[this.mFilePointerIndex++];
                BAMFileReader.this.mCompressedInputStream.seek(startOffset);
                this.mFilePointerLimit = endOffset;
            }
            return super.getNextRecord();
        }
    }

    static enum QueryType {
        CONTAINED,
        OVERLAPPING,
        STARTING_AT;

    }

    private class BAMFileIterator
    implements CloseableIterator<SAMRecord> {
        private SAMRecord mNextRecord = null;
        private final BAMRecordCodec bamRecordCodec = new BAMRecordCodec(BAMFileReader.this.getFileHeader());
        private long samRecordIndex = 0L;

        BAMFileIterator() {
            this(true);
        }

        BAMFileIterator(boolean advance) {
            this.bamRecordCodec.setInputStream(BAMFileReader.this.mStream.getInputStream());
            if (advance) {
                this.advance();
            }
        }

        @Override
        public void close() {
            if (BAMFileReader.this.mCurrentIterator != null && this != BAMFileReader.this.mCurrentIterator) {
                throw new IllegalStateException("Attempt to close non-current iterator");
            }
            BAMFileReader.this.mCurrentIterator = null;
        }

        @Override
        public boolean hasNext() {
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = this.mNextRecord;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        void advance() {
            try {
                this.mNextRecord = this.getNextRecord();
                if (this.mNextRecord != null) {
                    ++this.samRecordIndex;
                    this.mNextRecord.setValidationStringency(BAMFileReader.this.mValidationStringency);
                    if (BAMFileReader.this.mValidationStringency != SAMFileReader.ValidationStringency.SILENT) {
                        List<SAMValidationError> validationErrors = this.mNextRecord.isValid();
                        SAMUtils.processValidationErrors(validationErrors, this.samRecordIndex, BAMFileReader.this.getValidationStringency());
                    }
                }
                if (BAMFileReader.this.eagerDecode && this.mNextRecord != null) {
                    this.mNextRecord.eagerDecode();
                }
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }

        SAMRecord getNextRecord() throws IOException {
            long startCoordinate = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            SAMRecord next = this.bamRecordCodec.decode();
            long stopCoordinate = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            if (BAMFileReader.this.mFileReader != null && next != null) {
                next.setFileSource(new SAMFileSource(BAMFileReader.this.mFileReader, new BAMFileSpan(new Chunk(startCoordinate, stopCoordinate))));
            }
            return next;
        }

        protected SAMRecord peek() {
            return this.mNextRecord;
        }
    }
}

