/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.broad.igv.ui.AbstractDataPanelTool;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DragEventManager;

public class PanTool
extends AbstractDataPanelTool {
    private int previousYDirection = 0;
    private int cumulativeDeltaX;
    private int cumulativeDeltaY;
    private Point lastMousePoint;
    private JScrollBar verticalScrollBar;
    private boolean isDragging = false;
    private Cursor dragCursor = IGV.fistCursor;

    public PanTool(DataPanel owner) {
        super(owner, Cursor.getDefaultCursor());
        Container parentOfParent;
        this.setName("Pan");
        this.verticalScrollBar = owner.getVerticalScrollbar();
        Container parentContainer = owner.getParent();
        if (parentContainer == null || (parentOfParent = parentContainer.getParent()) == null || parentOfParent instanceof JViewport) {
            // empty if block
        }
    }

    @Override
    public Cursor getCursor() {
        return this.isDragging ? this.dragCursor : Cursor.getDefaultCursor();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            return;
        }
        this.lastMousePoint = e2.getPoint();
        this.cumulativeDeltaX = 0;
        this.cumulativeDeltaY = 0;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.isDragging) {
            this.getReferenceFame().snapToGrid();
            this.isDragging = false;
            DragEventManager.getInstance().dragStopped();
            this.getReferenceFame().recordHistory();
        }
        Component panel = (Component)e2.getSource();
        panel.setCursor(this.getCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mouseDragged(MouseEvent e2) {
        try {
            Component panel = (Component)e2.getSource();
            panel.setCursor(this.dragCursor);
            if (this.lastMousePoint == null) {
                this.lastMousePoint = e2.getPoint();
                return;
            }
            if (!this.isDragging && e2.getPoint().distance(this.lastMousePoint) < 2.0) {
                return;
            }
            this.isDragging = true;
            double deltaX = this.lastMousePoint.getX() - (double)e2.getX();
            double deltaY = this.lastMousePoint.getY() - (double)e2.getY();
            this.cumulativeDeltaX = (int)((double)this.cumulativeDeltaX + Math.abs(deltaX));
            this.cumulativeDeltaY = (int)((double)this.cumulativeDeltaY + Math.abs(deltaY));
            if (this.cumulativeDeltaX > this.cumulativeDeltaY) {
                this.getReferenceFame().shiftOriginPixels(deltaX);
            } else {
                int totalYChange = (int)(this.lastMousePoint.getY() - (double)e2.getY());
                if (totalYChange != 0) {
                    int currentYDirection = 0;
                    currentYDirection = totalYChange / Math.abs(totalYChange);
                    if (this.previousYDirection != 0) {
                        boolean changedYDirection;
                        boolean bl = changedYDirection = currentYDirection != this.previousYDirection;
                        if (!changedYDirection) {
                            this.previousYDirection = currentYDirection;
                            if (this.verticalScrollBar != null) {
                                int adjustedScrollbarValue = this.verticalScrollBar.getValue();
                                this.verticalScrollBar.setValue(adjustedScrollbarValue += totalYChange);
                            }
                        }
                    }
                    this.previousYDirection = currentYDirection;
                }
            }
        }
        finally {
            this.lastMousePoint = e2.getPoint();
        }
    }
}

