/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.AbstractDataPanelTool;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ClickTaskScheduler;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.DataPanelPainter;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.PanTool;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.DataPanelTool;

public class DataPanel
extends JComponent
implements Paintable {
    private static Logger log = Logger.getLogger(DataPanel.class);
    private boolean isWaitingForToolTipText = false;
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
    private DataPanelTool defaultTool;
    private DataPanelTool currentTool;
    private Point tooltipTextPosition;
    private ReferenceFrame frame;
    DataPanelContainer parent;
    private DataPanelPainter painter;
    private String tooltipText = "";
    static DecimalFormat locationFormatter = new DecimalFormat();

    public DataPanel(ReferenceFrame frame, DataPanelContainer parent) {
        this.init();
        this.currentTool = this.defaultTool = new PanTool(this);
        this.frame = frame;
        this.parent = parent;
        this.setFocusable(true);
        this.setAutoscrolls(true);
        this.setToolTipText("");
        this.painter = new DataPanelPainter();
        this.setBackground(PreferenceManager.getInstance().getAsColor("BACKGROUND_COLOR"));
    }

    public JScrollBar getVerticalScrollbar() {
        Container sp;
        for (sp = this.getParent(); sp != null && !(sp instanceof JScrollPane); sp = sp.getParent()) {
        }
        return sp == null ? null : ((JScrollPane)sp).getVerticalScrollBar();
    }

    public void setCurrentTool(AbstractDataPanelTool tool) {
        DataPanelTool dataPanelTool = this.currentTool = tool == null ? this.defaultTool : tool;
        if (this.currentTool != null) {
            this.setCursor(this.currentTool.getCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        RenderContext context = null;
        try {
            int startLoc;
            Rectangle clipBounds;
            List<MouseableRegion> mouseableRegions = this.parent.getMouseRegions();
            if (mouseableRegions != null) {
                mouseableRegions.clear();
            }
            Rectangle damageRect = (clipBounds = g2.getClipBounds()) == null ? this.getVisibleRect() : clipBounds.intersection(this.getVisibleRect());
            Graphics2D graphics2D = (Graphics2D)g2;
            String genomeId = IGV.getInstance().getGenomeManager().getGenomeId();
            context = new RenderContext(genomeId, this, graphics2D, this.frame, this.getVisibleRect());
            if (IS_MAC) {
                this.applyMacPerformanceHints((Graphics2D)g2);
            }
            ArrayList<TrackGroup> groups = new ArrayList<TrackGroup>(this.parent.getTrackGroups());
            boolean hasTracks = false;
            for (TrackGroup group : groups) {
                if (group.getTracks().size() <= 0) continue;
                hasTracks = true;
                break;
            }
            if (!hasTracks) {
                this.removeMousableRegions();
                return;
            }
            int trackWidth = this.getWidth();
            int trackHeight = this.getHeight();
            this.painter.paint(groups, context, trackWidth, trackHeight, this.getBackground(), damageRect, mouseableRegions);
            if (this.currentTool instanceof RegionOfInterestTool && (startLoc = ((RegionOfInterestTool)this.currentTool).getRoiStart()) > 0) {
                int start = this.frame.getScreenPosition(startLoc);
                g2.setColor(Color.BLACK);
                graphics2D.drawLine(start, 0, start, this.getHeight());
            }
            this.drawAllRegions(g2);
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        RenderContext context = null;
        try {
            String genomeId = IGV.getInstance().getGenomeManager().getGenomeId();
            context = new RenderContext(genomeId, null, g2, this.frame, rect);
            ArrayList<TrackGroup> groups = new ArrayList<TrackGroup>(this.parent.getTrackGroups());
            int width = rect.width;
            int height = rect.height;
            this.painter.paint(groups, context, width, height, this.getBackground(), rect, null);
            this.drawAllRegions(g2);
            super.paintBorder(g2);
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAllRegions(Graphics g2) {
        Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getRegionsOfInterest(this.frame.getChrName());
        if (regions == null || regions.isEmpty()) {
            return;
        }
        boolean drawBars = PreferenceManager.getInstance().getAsBoolean("SHOW_REGION_BARS");
        Graphics2D graphics2D = (Graphics2D)g2.create();
        try {
            for (RegionOfInterest regionOfInterest : regions) {
                if (!drawBars && regionOfInterest != RegionOfInterestPanel.getSelectedRegion()) continue;
                this.drawRegion(graphics2D, regionOfInterest);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    private boolean drawRegion(Graphics2D graphics2D, RegionOfInterest regionOfInterest) {
        Integer regionStart = regionOfInterest.getStart();
        if (regionStart == null) {
            return true;
        }
        Integer regionEnd = regionOfInterest.getEnd();
        if (regionEnd == null) {
            regionEnd = regionStart;
        }
        ReferenceFrame referenceFrame = this.frame;
        int start = referenceFrame.getScreenPosition(regionStart.intValue());
        int end = referenceFrame.getScreenPosition(regionEnd.intValue());
        int height = this.getHeight();
        graphics2D.setColor(regionOfInterest.getForegroundColor());
        graphics2D.drawLine(start, 0, start, height);
        graphics2D.drawLine(end, 0, end, height);
        return false;
    }

    protected String generateTileKey(String chr, int t, int zoomLevel) {
        String key = chr + "_z_" + zoomLevel + "_t_" + t;
        return key;
    }

    public void debugDump(String trackName) {
        TrackPanel trackView = (TrackPanel)this.getParent();
        if (trackView == null) {
            return;
        }
        if (trackView.hasTracks()) {
            String name = this.parent.getTrackSetID().toString();
            System.out.println("\n\n" + name + " Track COUNT:" + trackView.getTracks().size());
            System.out.println("\t\t\t\t" + name + " scrollpane height     = " + trackView.getScrollPane().getHeight());
            System.out.println("\t\t\t\t" + name + " viewport height       = " + trackView.getViewportHeight());
            System.out.println("\t\t\t\t" + name + " TrackView min height  = " + trackView.getMinimumSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView pref height = " + trackView.getPreferredSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView height      = " + trackView.getSize().getHeight());
        }
    }

    public Track getTrack(int x, int y) {
        for (MouseableRegion mouseRegion : this.parent.getMouseRegions()) {
            if (!mouseRegion.containsPoint(x, y)) continue;
            return mouseRegion.getTracks().iterator().next();
        }
        return null;
    }

    public void updateTooltipText(int x, int y) {
        String puText;
        double location = this.frame.getChromosomePosition(x);
        double displayLocation = location + 1.0;
        Track track = null;
        List<MouseableRegion> regions = this.parent.getMouseRegions();
        StringBuffer popupTextBuffer = new StringBuffer();
        for (MouseableRegion mouseRegion : regions) {
            if (!mouseRegion.containsPoint(x, y)) continue;
            track = mouseRegion.getTracks().iterator().next();
            if (track == null) break;
            List<Track> overlays = IGV.getInstance().getTrackManager().getOverlayTracks(track);
            if (overlays != null) {
                for (Track overlay : overlays) {
                    if (overlay == track || overlay.getValueStringAt(this.frame.getChrName(), displayLocation, y, this.frame) == null) continue;
                    popupTextBuffer.append(this.getPopUpText(overlay, displayLocation, y));
                    popupTextBuffer.append("<br>");
                }
            }
            popupTextBuffer.append(this.getPopUpText(track, displayLocation, y));
            break;
        }
        if ((puText = popupTextBuffer.toString().trim()).length() > 0) {
            if (!puText.equals(this.tooltipText)) {
                this.setToolTipText("<html>" + puText);
            }
        } else {
            this.setToolTipText("");
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.tooltipText = text;
        super.setToolTipText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getToolTipText() {
        if (IGV.getInstance().isSuppressTooltip() || this.currentTool instanceof RegionOfInterestTool) {
            return "";
        }
        if (!this.isWaitingForToolTipText) {
            try {
                this.isWaitingForToolTipText = true;
                if (this.tooltipTextPosition != null) {
                    this.updateTooltipText(this.tooltipTextPosition.x, this.tooltipTextPosition.y);
                }
            }
            finally {
                this.isWaitingForToolTipText = false;
            }
        }
        return super.getToolTipText();
    }

    String getPopUpText(Track track, double location, int y) {
        StringBuffer buf = new StringBuffer();
        String value = track.getValueStringAt(this.frame.getChrName(), location, y, this.frame);
        if (value != null) {
            buf.append(value);
        }
        return buf.toString();
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setRequestFocusEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyChar() == '+' || e2.getKeyCode() == 521) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.frame.incrementZoom(1);
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyChar() == '-' || e2.getKeyCode() == 521) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.frame.incrementZoom(-1);
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 39) {
                    DataPanel.this.frame.shiftOriginPixels(5.0);
                } else if (e2.getKeyCode() == 37) {
                    DataPanel.this.frame.shiftOriginPixels(-5.0);
                } else if (e2.getKeyCode() == 36) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.frame.shiftOriginPixels(-DataPanel.this.getWidth());
                        DataPanel.this.frame.recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 35) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.frame.shiftOriginPixels(DataPanel.this.getWidth());
                        DataPanel.this.frame.recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 521 || e2.getKeyCode() == 45) {
                    // empty if block
                }
            }
        };
        this.addKeyListener(keyAdapter);
        DataPanelMouseAdapter mouseAdapter = new DataPanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void applyMacPerformanceHints(Graphics2D g2D) {
        g2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    protected void addMousableRegion(MouseableRegion region) {
        this.parent.addMousableRegion(region);
    }

    protected void removeMousableRegions() {
        this.parent.getMouseRegions().clear();
    }

    public ReferenceFrame getFrame() {
        return this.frame;
    }

    class DataPanelMouseAdapter
    extends MouseInputAdapter {
        private ClickTaskScheduler clickScheduler = new ClickTaskScheduler();

        DataPanelMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            IGV.getInstance().setSelectedRegion(null);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            DataPanel.this.tooltipTextPosition = e2.getPoint();
            if (!DataPanel.this.frame.getChrName().equals("All")) {
                int location = (int)DataPanel.this.frame.getChromosomePosition(e2.getX()) + 1;
                String position = DataPanel.this.frame.getChrName() + ":" + locationFormatter.format(location);
                IGV.getInstance().setStatusBarMessage(position);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SwingUtilities.getWindowAncestor(DataPanel.this).isActive()) {
                DataPanel.this.requestFocus();
            }
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
            } else if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mousePressed(e2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
            } else if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mouseReleased(e2);
            }
        }

        private void doPopupMenu(MouseEvent e2) {
            IGV.getInstance().getTrackManager().clearSelections();
            DataPanel.this.parent.selectTracks(e2);
            TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
            DataPanel.this.parent.openPopupMenu(te);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (DataPanel.this.currentTool != null) {
                DataPanel.this.currentTool.mouseDragged(e2);
            }
        }

        @Override
        public void mouseClicked(final MouseEvent e2) {
            if (DataPanel.this.currentTool instanceof RegionOfInterestTool) {
                DataPanel.this.currentTool.mouseClicked(e2);
                return;
            }
            if (e2.isPopupTrigger()) {
                this.doPopupMenu(e2);
                return;
            }
            Object source = e2.getSource();
            if (source instanceof DataPanel && e2.getButton() == 1) {
                final Track track = ((DataPanel)e2.getSource()).getTrack(e2.getX(), e2.getY());
                if (e2.isShiftDown()) {
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.zoomBy(3, locationClicked);
                } else if (e2.isAltDown()) {
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.zoomBy(-1, locationClicked);
                } else if ((e2.isMetaDown() || e2.isControlDown()) && track != null) {
                    TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
                    track.handleDataClick(te);
                } else if (e2.getClickCount() > 1) {
                    this.clickScheduler.cancelClickTask();
                    double locationClicked = DataPanel.this.frame.getChromosomePosition(e2.getX());
                    DataPanel.this.frame.zoomBy(1, locationClicked);
                } else {
                    TimerTask clickTask = new TimerTask(){

                        @Override
                        public void run() {
                            Object source = e2.getSource();
                            if (source instanceof DataPanel && track != null) {
                                TrackClickEvent te = new TrackClickEvent(e2, DataPanel.this.frame);
                                if (track.handleDataClick(te)) {
                                    return;
                                }
                                if (DataPanel.this.currentTool != null) {
                                    DataPanel.this.currentTool.mouseClicked(e2);
                                }
                            }
                        }
                    };
                    this.clickScheduler.scheduleClickTask(clickTask);
                }
            }
        }
    }
}

