/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileChooserDialog;

public class OpenSessionMenuAction
extends MenuAction {
    private static Logger log = Logger.getLogger(OpenSessionMenuAction.class);
    private IGV mainFrame;
    private File sessionFile = null;
    private boolean autoload = false;

    public OpenSessionMenuAction(String label, File sessionFile, IGV mainFrame) {
        super(label);
        this.sessionFile = sessionFile;
        this.mainFrame = mainFrame;
        this.setToolTipText("Reload the named session");
        this.autoload = true;
    }

    public OpenSessionMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Reload the named session");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.sessionFile == null || !this.autoload) {
            OpenSessionMenuAction openSessionMenuAction = this;
            FileChooserDialog dialog = new FileChooserDialog(openSessionMenuAction.mainFrame.getMainFrame(), true);
            dialog.setTitle("Open Session");
            dialog.setSelectedFile(null);
            dialog.setFileSelectionMode(0);
            File lastSessionDirectory = PreferenceManager.getInstance().getLastSessionDirectory();
            dialog.setCurrentDirectory(lastSessionDirectory);
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            this.sessionFile = dialog.getSelectedFile();
        }
        this.doRestoreSession();
    }

    public final void doRestoreSession() {
        if (IGV.getInstance().getTrackManager().getAllTracks(false).size() > 0) {
            OpenSessionMenuAction openSessionMenuAction = this;
            int status = JOptionPane.showConfirmDialog(openSessionMenuAction.mainFrame.getMainFrame(), "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?", null, 2, -1, null);
            if (status == 2 || status == -1) {
                return;
            }
        }
        if (this.sessionFile != null) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    OpenSessionMenuAction.this.mainFrame.doRestoreSession(OpenSessionMenuAction.this.sessionFile, null);
                    return null;
                }
            };
            worker.execute();
        }
    }
}

