/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.broad.igv.util.StringUtils;

public class GraphicUtils {
    public static void drawCenteredChar(Graphics g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    public static void drawCenteredText(String text, Rectangle rect, Graphics g2) {
        GraphicUtils.drawCenteredText(text, rect.x, rect.y, rect.width, rect.height, g2);
    }

    public static void drawCenteredText(String text, int x, int y, int w, int h2, Graphics g2) {
        FontMetrics fontMetrics = g2.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2);
        int xOffset = (int)(((double)w - textBounds.getWidth()) / 2.0);
        int yOffset = (int)(((double)h2 - textBounds.getHeight()) / 2.0);
        g2.drawString(text, x + xOffset, y + h2 - yOffset - (int)(textBounds.getHeight() / 4.0));
    }

    public static void drawVerticallyCenteredText(String text, int margin, Rectangle rect, Graphics g2D, boolean rightJustify) {
        GraphicUtils.drawVerticallyCenteredText(text, margin, rect, g2D, rightJustify, false);
    }

    public static void drawVerticallyCenteredText(String text, int margin, Rectangle rect, Graphics g2D, boolean rightJustify, boolean clear) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2D);
        int yOffset = (int)((rect.getHeight() - textBounds.getHeight()) / 2.0);
        int yPos = rect.y + rect.height - yOffset - (int)(textBounds.getHeight() / 4.0);
        if (clear) {
            int h2 = 2 * (int)textBounds.getHeight();
            int y = Math.max(rect.y, yPos - h2);
            int h22 = Math.min(rect.height, 2 * h2);
            g2D.clearRect(rect.x, y, rect.width, h22);
        }
        if (rightJustify) {
            GraphicUtils.drawRightJustifiedText(text, rect.x + rect.width - margin, yPos, g2D);
        } else {
            g2D.drawString(text, margin, yPos);
        }
    }

    public static void drawRightJustifiedText(String text, int right, int y, Graphics g2) {
        FontMetrics fontMetrics = g2.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2);
        int x = right - (int)textBounds.getWidth();
        g2.drawString(text, x, y);
    }

    public static void drawDottedDashLine(Graphics2D g2, int x1, int y1, int x2, int y2) {
        BasicStroke thindashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
        GraphicUtils.drawDashedLine(g2, thindashed, x1, y1, x2, y2);
    }

    public static void drawDashedLine(Graphics2D g2, int x1, int y1, int x2, int y2) {
        BasicStroke thindashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
        GraphicUtils.drawDashedLine(g2, thindashed, x1, y1, x2, y2);
    }

    public static void drawWrappedText(String string, Rectangle rect, Graphics2D g2D, boolean clear) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(string, g2D);
        int margin = 5;
        int textHeight = (int)stringBounds.getHeight() + 5;
        double textWidth = stringBounds.getWidth() + 10.0;
        if (textWidth < (double)rect.width) {
            GraphicUtils.drawVerticallyCenteredText(string, 5, rect, g2D, false, clear);
        } else {
            int charWidth = (int)(stringBounds.getWidth() / (double)string.length());
            int charsPerLine = rect.width / charWidth;
            int nStrings = string.length() / charsPerLine + 1;
            if (nStrings * textHeight > rect.height) {
                String shortString;
                double w;
                int nChars = (rect.width - 10) / charWidth + 1;
                int nTries = 0;
                while ((w = fontMetrics.getStringBounds(shortString = StringUtils.checkLength(string, nChars), g2D).getWidth() + 10.0) > (double)rect.width && ++nTries <= 5 && --nChars > 1) {
                }
                GraphicUtils.drawVerticallyCenteredText(shortString, 5, rect, g2D, false, clear);
            } else {
                int breakPoint = 0;
                Rectangle tmp = new Rectangle(rect);
                tmp.y -= (nStrings - 1) * textHeight / 2;
                while (breakPoint < string.length()) {
                    int end = Math.min(string.length(), breakPoint + charsPerLine);
                    GraphicUtils.drawVerticallyCenteredText(string.substring(breakPoint, end), 5, tmp, g2D, false);
                    breakPoint += charsPerLine;
                    tmp.y += textHeight;
                }
            }
        }
    }

    public static void drawDashedLine(Graphics2D g2, Stroke stroke, int x1, int y1, int x2, int y2) {
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(stroke);
        g2.drawLine(x1, y1, x2, y2);
        g2.setStroke(currentStroke);
    }

    public static void drawHorizontalArrow(Graphics g2, Rectangle r, boolean direction) {
        int[] y;
        int[] x;
        int dy = r.height / 3;
        int y0 = r.y;
        int y1 = y0 + dy;
        int y3 = y0 + r.height;
        int y2 = y3 - dy;
        int yc = (y1 + y2) / 2;
        int dx = yc - y0;
        if (direction) {
            int x1 = r.x;
            int x3 = x1 + r.width;
            int x2 = x3 - dx;
            x = new int[]{x1, x2, x2, x3, x2, x2, x1};
            y = new int[]{y1, y1, y0, yc, y3, y2, y2};
        } else {
            int x1 = r.x;
            int x3 = x1 + r.width;
            int x2 = x1 + dx;
            x = new int[]{x1, x2, x2, x3, x3, x2, x2};
            y = new int[]{yc, y0, y1, y1, y2, y2, y3};
        }
        g2.fillPolygon(x, y, x.length);
    }
}

