/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.peaks.Peak;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class PeakParser {
    Map<String, Long> chrIndex;
    int nTimePoints;
    String path;

    public PeakParser(String path) throws IOException {
        this.path = path;
        this.loadIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() throws IOException {
        this.chrIndex = new HashMap<String, Long>();
        SeekableStream ss = null;
        try {
            ss = SeekableStreamFactory.getStreamFor(this.path);
            LittleEndianInputStream is = new LittleEndianInputStream(ss);
            long indexPosition = is.readLong();
            this.nTimePoints = is.readInt();
            ss.seek(indexPosition);
            is = new LittleEndianInputStream(new BufferedInputStream(ss));
            int nChrs = is.readInt();
            for (int i2 = 0; i2 < nChrs; ++i2) {
                String chr = is.readString();
                long pos = is.readLong();
                this.chrIndex.put(chr, pos);
            }
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peak> loadPeaks(String chr) throws IOException {
        Long chrPos = this.chrIndex.get(chr);
        if (chrPos == null) {
            return new ArrayList<Peak>();
        }
        ArrayList<Peak> peaks = new ArrayList<Peak>(10000);
        LittleEndianInputStream reader = null;
        SeekableStream ss = null;
        try {
            ss = SeekableStreamFactory.getStreamFor(this.path);
            ss.seek(chrPos);
            reader = new LittleEndianInputStream(ss);
            int nBytes = reader.readInt();
            byte[] compressedBytes = new byte[nBytes];
            ss.readFully(compressedBytes);
            byte[] bytes = CompressionUtils.decompress(compressedBytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            reader = new LittleEndianInputStream(bis);
            String chrRecorded = reader.readString();
            if (!chrRecorded.equals(chr)) {
                throw new RuntimeException("Error paring peak file: " + this.path + "<br>Expected: " + chr + "  found: " + chrRecorded);
            }
            int nDataPoints = reader.readInt();
            for (int n2 = 0; n2 < nDataPoints; ++n2) {
                int start = reader.readInt();
                int end = reader.readInt();
                float combinedScore = reader.readFloat();
                float[] timePointScores = new float[this.nTimePoints];
                for (int i2 = 0; i2 < this.nTimePoints; ++i2) {
                    timePointScores[i2] = reader.readFloat();
                }
                peaks.add(new Peak(chr, start, end, "", combinedScore, timePointScores));
            }
            ArrayList<Peak> arrayList = peaks;
            return arrayList;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }
}

