/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;

public class BasicFeature
extends AbstractFeature {
    private static Logger log = Logger.getLogger(BasicFeature.class);
    protected List<Exon> exons;
    protected int level = 1;
    private String type;
    protected float score = Float.NaN;
    protected float confidence;
    String identifier;
    private int thickEnd;
    private int thickStart;
    String[] parentIds;
    String link;

    public String[] getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(String[] parentIds) {
        this.parentIds = parentIds;
    }

    public BasicFeature() {
    }

    public BasicFeature(String chr, int start, int end) {
        this(chr, start, end, Strand.NONE);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(BasicFeature feature) {
        super(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getStrand());
        super.setName(feature.getName());
        this.confidence = feature.confidence;
        this.color = feature.color;
        this.description = feature.description;
        this.exons = feature.exons;
        this.level = feature.level;
        this.score = feature.score;
        this.identifier = feature.identifier;
        this.type = feature.type;
        this.link = feature.link;
        this.thickStart = feature.thickStart;
        this.thickEnd = feature.thickEnd;
    }

    @Override
    public BasicFeature copy() {
        return new BasicFeature(this);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            valueString.append(name);
        }
        if (!(this.identifier == null || name != null && name.equals(this.identifier))) {
            valueString.append("<br>" + this.identifier);
        }
        if (this.hasScore()) {
            valueString.append("<br>Score = " + this.score);
        }
        if (this.description != null) {
            valueString.append("<br>" + this.description);
        }
        valueString.append("<br>" + this.getLocusString());
        int posZero = (int)position - 1;
        if (this.exons != null) {
            for (Exon exon : this.exons) {
                String exonString;
                if (posZero < exon.getStart() || posZero >= exon.getEnd() || (exonString = exon.getValueString(position, ignored)) == null || exonString.length() <= 0) continue;
                valueString.append("<br>--------------<br>");
                valueString.append(exonString);
            }
        }
        return valueString.toString();
    }

    public void setScore(float score) {
        this.score = score;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public boolean hasScore() {
        return !Float.isNaN(this.score);
    }

    @Override
    public List<Exon> getExons() {
        return this.exons;
    }

    @Override
    public Exon getExonAt(double position) {
        if (this.exons == null) {
            return null;
        }
        for (Exon exon : this.exons) {
            if (!(position >= (double)exon.getStart()) || !(position <= (double)exon.getEnd())) continue;
            return exon;
        }
        return null;
    }

    public void sortExons() {
        if (this.exons != null) {
            Collections.sort(this.exons, new Comparator<IGVFeature>(){

                @Override
                public int compare(IGVFeature arg0, IGVFeature arg1) {
                    return arg0.getStart() - arg1.getStart();
                }
            });
        }
    }

    public void addExon(Exon region) {
        if (this.exons == null) {
            this.exons = new ArrayList<Exon>();
        }
        this.setStart(Math.min(this.getStart(), region.getStart()));
        this.setEnd(Math.max(this.getEnd(), region.getEnd()));
        this.exons.add(region);
    }

    public int compareTo(Object o2) {
        IGVFeature otherObj = (IGVFeature)o2;
        return this.getStart() - otherObj.getStart();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public int getExonCount() {
        return this.exons == null ? 0 : this.exons.size();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public void setURL(String link) {
        this.link = link;
    }

    @Override
    public String getURL() {
        return this.link;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }
}

