/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;

public class BigMatrixImpl
implements BigMatrix,
Serializable {
    private static final long serialVersionUID = -1011428905656140431L;
    private BigDecimal[][] data = null;
    private BigDecimal[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;
    private int roundingMode = 4;
    private int scale = 64;
    protected static BigDecimal TOO_SMALL = new BigDecimal(1.0E-11);
    static final BigDecimal ZERO = new BigDecimal(0.0);
    static final BigDecimal ONE = new BigDecimal(1.0);

    public BigMatrixImpl() {
    }

    public BigMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension <= 0 || columnDimension <= 0) {
            throw new IllegalArgumentException("row and column dimensions must be positive");
        }
        this.data = new BigDecimal[rowDimension][columnDimension];
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d2) {
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(double[][] d2) {
        int nRows = d2.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d2[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int row = 1;
        while (row < nRows) {
            if (d2[row].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++row;
        }
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(String[][] d2) {
        int nRows = d2.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d2[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int row = 1;
        while (row < nRows) {
            if (d2[row].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++row;
        }
        this.copyIn(d2);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[] v) {
        int nRows = v.length;
        this.data = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    public BigMatrix copy() {
        return new BigMatrixImpl(this.copyOut());
    }

    public BigMatrix add(BigMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getColumnDimension() || this.getRowDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].add(m2.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix subtract(BigMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getColumnDimension() || this.getRowDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].subtract(m2.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarAdd(BigDecimal d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].add(d2);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarMultiply(BigDecimal d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col].multiply(d2);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix multiply(BigMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("Matrices are not multiplication compatible.");
        }
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nRows][nCols];
        BigDecimal sum = ZERO;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                sum = ZERO;
                int i2 = 0;
                while (i2 < nSum) {
                    sum = sum.add(this.data[row][i2].multiply(m2.getEntry(i2, col)));
                    ++i2;
                }
                outData[row][col] = sum;
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix preMultiply(BigMatrix m2) throws IllegalArgumentException {
        return m2.multiply(this);
    }

    public BigDecimal[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataAsDoubleArray() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[][] d2 = new double[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            int j2 = 0;
            while (j2 < nCols) {
                d2[i2][j2] = this.data[i2][j2].doubleValue();
                ++j2;
            }
            ++i2;
        }
        return d2;
    }

    public BigDecimal[][] getDataRef() {
        return this.data;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public BigDecimal getNorm() {
        BigDecimal maxColSum = ZERO;
        int col = 0;
        while (col < this.getColumnDimension()) {
            BigDecimal sum = ZERO;
            int row = 0;
            while (row < this.getRowDimension()) {
                sum = sum.add(this.data[row][col].abs());
                ++row;
            }
            maxColSum = maxColSum.max(sum);
            ++col;
        }
        return maxColSum;
    }

    public BigMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(endRow - startRow + 1, endColumn - startColumn + 1);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        int i2 = startRow;
        while (i2 <= endRow) {
            int j2 = startColumn;
            while (j2 <= endColumn) {
                subMatrixData[i2 - startRow][j2 - startColumn] = this.data[i2][j2];
                ++j2;
            }
            ++i2;
        }
        return subMatrix;
    }

    public BigMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            throw new MatrixIndexException("selected row and column index arrays must be non-empty");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(selectedRows.length, selectedColumns.length);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        try {
            int i2 = 0;
            while (i2 < selectedRows.length) {
                int j2 = 0;
                while (j2 < selectedColumns.length) {
                    subMatrixData[i2][j2] = this.data[selectedRows[i2]][selectedColumns[j2]];
                    ++j2;
                }
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        return subMatrix;
    }

    public void setSubMatrix(BigDecimal[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (row < 0 || column < 0) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                throw new MatrixIndexException("matrix must be initialized to perfom this method");
            }
            this.data = new BigDecimal[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        }
        if (nRows + row > this.getRowDimension() || nCols + column > this.getColumnDimension()) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int i2 = 0;
        while (i2 < nRows) {
            System.arraycopy(subMatrix[i2], 0, this.data[row + i2], column, nCols);
            ++i2;
        }
        this.lu = null;
    }

    public BigMatrix getRowMatrix(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[][] out = new BigDecimal[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new BigMatrixImpl(out);
    }

    public BigMatrix getColumnMatrix(int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, column)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            out[row][0] = this.data[row][column];
            ++row;
        }
        return new BigMatrixImpl(out);
    }

    public BigDecimal[] getRow(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getRowAsDoubleArray(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        int i2 = 0;
        while (i2 < ncols) {
            out[i2] = this.data[row][i2].doubleValue();
            ++i2;
        }
        return out;
    }

    public BigDecimal[] getColumn(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        int i2 = 0;
        while (i2 < nRows) {
            out[i2] = this.data[i2][col];
            ++i2;
        }
        return out;
    }

    public double[] getColumnAsDoubleArray(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nrows = this.getRowDimension();
        double[] out = new double[nrows];
        int i2 = 0;
        while (i2 < nrows) {
            out[i2] = this.data[i2][col].doubleValue();
            ++i2;
        }
        return out;
    }

    public BigDecimal getEntry(int row, int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, column)) {
            throw new MatrixIndexException("matrix entry does not exist");
        }
        return this.data[row][column];
    }

    public double getEntryAsDouble(int row, int column) throws MatrixIndexException {
        return this.getEntry(row, column).doubleValue();
    }

    public BigMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigMatrixImpl out = new BigMatrixImpl(nCols, nRows);
        BigDecimal[][] outData = out.getDataRef();
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                outData[col][row] = this.data[row][col];
                ++col;
            }
            ++row;
        }
        return out;
    }

    public BigMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createBigIdentityMatrix(this.getRowDimension()));
    }

    public BigDecimal getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new InvalidMatrixException("matrix is not square");
        }
        if (this.isSingular()) {
            return ZERO;
        }
        BigDecimal det = this.parity == 1 ? ONE : ONE.negate();
        int i2 = 0;
        while (i2 < this.getRowDimension()) {
            det = det.multiply(this.lu[i2][i2]);
            ++i2;
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public BigDecimal getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("matrix is not square");
        }
        BigDecimal trace = this.data[0][0];
        int i2 = 1;
        while (i2 < this.getRowDimension()) {
            trace = trace.add(this.data[i2][i2]);
            ++i2;
        }
        return trace;
    }

    public BigDecimal[] operate(BigDecimal[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[v.length];
        int row = 0;
        while (row < nRows) {
            BigDecimal sum = ZERO;
            int i2 = 0;
            while (i2 < nCols) {
                sum = sum.add(this.data[row][i2].multiply(v[i2]));
                ++i2;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    public BigDecimal[] operate(double[] v) throws IllegalArgumentException {
        BigDecimal[] bd = new BigDecimal[v.length];
        int i2 = 0;
        while (i2 < bd.length) {
            bd[i2] = new BigDecimal(v[i2]);
            ++i2;
        }
        return this.operate(bd);
    }

    public BigDecimal[] preMultiply(BigDecimal[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nCols];
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int i2 = 0;
            while (i2 < nRows) {
                sum = sum.add(this.data[i2][col].multiply(v[i2]));
                ++i2;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    public BigDecimal[] solve(BigDecimal[] b2) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b2.length != nRows) {
            throw new IllegalArgumentException("constant vector has wrong length");
        }
        BigMatrixImpl bMatrix = new BigMatrixImpl(b2);
        BigDecimal[][] solution = ((BigMatrixImpl)this.solve(bMatrix)).getDataRef();
        BigDecimal[] out = new BigDecimal[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = solution[row][0];
            ++row;
        }
        return out;
    }

    public BigDecimal[] solve(double[] b2) throws IllegalArgumentException, InvalidMatrixException {
        BigDecimal[] bd = new BigDecimal[b2.length];
        int i2 = 0;
        while (i2 < bd.length) {
            bd[i2] = new BigDecimal(b2[i2]);
            ++i2;
        }
        return this.solve(bd);
    }

    public BigMatrix solve(BigMatrix b2) throws IllegalArgumentException, InvalidMatrixException {
        int j2;
        int col;
        if (b2.getRowDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect row dimension");
        }
        if (!this.isSquare()) {
            throw new InvalidMatrixException("coefficient matrix is not square");
        }
        if (this.isSingular()) {
            throw new InvalidMatrixException("Matrix is singular.");
        }
        int nCol = this.getColumnDimension();
        int nColB = b2.getColumnDimension();
        int nRowB = b2.getRowDimension();
        BigDecimal[][] bp = new BigDecimal[nRowB][nColB];
        int row = 0;
        while (row < nRowB) {
            col = 0;
            while (col < nColB) {
                bp[row][col] = b2.getEntry(this.permutation[row], col);
                ++col;
            }
            ++row;
        }
        col = 0;
        while (col < nCol) {
            int i2 = col + 1;
            while (i2 < nCol) {
                j2 = 0;
                while (j2 < nColB) {
                    bp[i2][j2] = bp[i2][j2].subtract(bp[col][j2].multiply(this.lu[i2][col]));
                    ++j2;
                }
                ++i2;
            }
            ++col;
        }
        int col2 = nCol - 1;
        while (col2 >= 0) {
            j2 = 0;
            while (j2 < nColB) {
                bp[col2][j2] = bp[col2][j2].divide(this.lu[col2][col2], this.scale, this.roundingMode);
                ++j2;
            }
            int i3 = 0;
            while (i3 < col2) {
                int j3 = 0;
                while (j3 < nColB) {
                    bp[i3][j3] = bp[i3][j3].subtract(bp[col2][j3].multiply(this.lu[i3][col2]));
                    ++j3;
                }
                ++i3;
            }
            --col2;
        }
        BigMatrixImpl outMat = new BigMatrixImpl(bp);
        return outMat;
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new InvalidMatrixException("LU decomposition requires that the matrix be square.");
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        int row = 0;
        while (row < nRows) {
            this.permutation[row] = row;
            ++row;
        }
        this.parity = 1;
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int row2 = 0;
            while (row2 < col) {
                sum = this.lu[row2][col];
                int i2 = 0;
                while (i2 < row2) {
                    sum = sum.subtract(this.lu[row2][i2].multiply(this.lu[i2][col]));
                    ++i2;
                }
                this.lu[row2][col] = sum;
                ++row2;
            }
            int max = col;
            BigDecimal largest = ZERO;
            int row3 = col;
            while (row3 < nRows) {
                sum = this.lu[row3][col];
                int i3 = 0;
                while (i3 < col) {
                    sum = sum.subtract(this.lu[row3][i3].multiply(this.lu[i3][col]));
                    ++i3;
                }
                this.lu[row3][col] = sum;
                if (sum.abs().compareTo(largest) == 1) {
                    largest = sum.abs();
                    max = row3;
                }
                ++row3;
            }
            if (this.lu[max][col].abs().compareTo(TOO_SMALL) <= 0) {
                this.lu = null;
                throw new InvalidMatrixException("matrix is singular");
            }
            if (max != col) {
                BigDecimal tmp = ZERO;
                int i4 = 0;
                while (i4 < nCols) {
                    tmp = this.lu[max][i4];
                    this.lu[max][i4] = this.lu[col][i4];
                    this.lu[col][i4] = tmp;
                    ++i4;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            int row4 = col + 1;
            while (row4 < nRows) {
                this.lu[row4][col] = this.lu[row4][col].divide(this.lu[col][col], this.scale, this.roundingMode);
                ++row4;
            }
            ++col;
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("BigMatrixImpl{");
        if (this.data != null) {
            int i2 = 0;
            while (i2 < this.data.length) {
                if (i2 > 0) {
                    res.append(",");
                }
                res.append("{");
                int j2 = 0;
                while (j2 < this.data[0].length) {
                    if (j2 > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i2][j2]);
                    ++j2;
                }
                res.append("}");
                ++i2;
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigMatrixImpl)) {
            return false;
        }
        BigMatrix m2 = (BigMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m2.getColumnDimension() != nCols || m2.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (!this.data[row][col].equals(m2.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * this.data[row][col].hashCode();
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected BigMatrix getIdentity(int dimension) {
        return MatrixUtils.createBigIdentityMatrix(dimension);
    }

    protected BigMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new BigMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private BigDecimal[][] copyOut() {
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][this.getColumnDimension()];
        int i2 = 0;
        while (i2 < nRows) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
            ++i2;
        }
        return out;
    }

    private void copyIn(BigDecimal[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private void copyIn(double[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            int j2 = 0;
            while (j2 < nCols) {
                this.data[i2][j2] = new BigDecimal(in[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        this.lu = null;
    }

    private void copyIn(String[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            int j2 = 0;
            while (j2 < nCols) {
                this.data[i2][j2] = new BigDecimal(in[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        this.lu = null;
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        return row >= 0 && row < nRows && col >= 0 && col < nCols;
    }
}

