/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.ComponentTransferFunction;

public class ConcreteComponentTransferFunction
implements ComponentTransferFunction {
    private int type;
    private float slope;
    private float[] tableValues;
    private float intercept;
    private float amplitude;
    private float exponent;
    private float offset;

    private ConcreteComponentTransferFunction() {
    }

    public static ComponentTransferFunction getIdentityTransfer() {
        ConcreteComponentTransferFunction f2 = new ConcreteComponentTransferFunction();
        f2.type = 0;
        return f2;
    }

    public static ComponentTransferFunction getTableTransfer(float[] tableValues) {
        ConcreteComponentTransferFunction f2 = new ConcreteComponentTransferFunction();
        f2.type = 1;
        if (tableValues == null) {
            throw new IllegalArgumentException();
        }
        if (tableValues.length < 2) {
            throw new IllegalArgumentException();
        }
        f2.tableValues = new float[tableValues.length];
        System.arraycopy(tableValues, 0, f2.tableValues, 0, tableValues.length);
        return f2;
    }

    public static ComponentTransferFunction getDiscreteTransfer(float[] tableValues) {
        ConcreteComponentTransferFunction f2 = new ConcreteComponentTransferFunction();
        f2.type = 2;
        if (tableValues == null) {
            throw new IllegalArgumentException();
        }
        if (tableValues.length < 2) {
            throw new IllegalArgumentException();
        }
        f2.tableValues = new float[tableValues.length];
        System.arraycopy(tableValues, 0, f2.tableValues, 0, tableValues.length);
        return f2;
    }

    public static ComponentTransferFunction getLinearTransfer(float slope, float intercept) {
        ConcreteComponentTransferFunction f2 = new ConcreteComponentTransferFunction();
        f2.type = 3;
        f2.slope = slope;
        f2.intercept = intercept;
        return f2;
    }

    public static ComponentTransferFunction getGammaTransfer(float amplitude, float exponent, float offset) {
        ConcreteComponentTransferFunction f2 = new ConcreteComponentTransferFunction();
        f2.type = 4;
        f2.amplitude = amplitude;
        f2.exponent = exponent;
        f2.offset = offset;
        return f2;
    }

    public int getType() {
        return this.type;
    }

    public float getSlope() {
        return this.slope;
    }

    public float[] getTableValues() {
        return this.tableValues;
    }

    public float getIntercept() {
        return this.intercept;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getExponent() {
        return this.exponent;
    }

    public float getOffset() {
        return this.offset;
    }
}

