/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polyline2D;

public class Polygon2D
implements Shape,
Cloneable,
Serializable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polygon2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polygon2D(Rectangle2D rec) {
        if (rec == null) {
            throw new IndexOutOfBoundsException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new float[4];
        this.ypoints = new float[4];
        this.xpoints[0] = (float)rec.getMinX();
        this.ypoints[0] = (float)rec.getMinY();
        this.xpoints[1] = (float)rec.getMaxX();
        this.ypoints[1] = (float)rec.getMinY();
        this.xpoints[2] = (float)rec.getMaxX();
        this.ypoints[2] = (float)rec.getMaxY();
        this.xpoints[3] = (float)rec.getMinX();
        this.ypoints[3] = (float)rec.getMaxY();
        this.calculatePath();
    }

    public Polygon2D(Polygon pol) {
        if (pol == null) {
            throw new IndexOutOfBoundsException("null Polygon");
        }
        this.npoints = pol.npoints;
        this.xpoints = new float[pol.npoints];
        this.ypoints = new float[pol.npoints];
        int i2 = 0;
        while (i2 < pol.npoints) {
            this.xpoints[i2] = pol.xpoints[i2];
            this.ypoints[i2] = pol.ypoints[i2];
            ++i2;
        }
        this.calculatePath();
    }

    public Polygon2D(float[] xpoints, float[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.calculatePath();
    }

    public Polygon2D(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        int i2 = 0;
        while (i2 < npoints) {
            this.xpoints[i2] = xpoints[i2];
            this.ypoints[i2] = ypoints[i2];
            ++i2;
        }
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polygon2D pol = new Polygon2D();
        int i2 = 0;
        while (i2 < this.npoints) {
            pol.addPoint(this.xpoints[i2], this.ypoints[i2]);
            ++i2;
        }
        return pol;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        int i2 = 1;
        while (i2 < this.npoints) {
            this.path.lineTo(this.xpoints[i2], this.ypoints[i2]);
            ++i2;
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(float x, float y) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(x, y);
            this.bounds = new Rectangle2D.Float(x, y, 0.0f, 0.0f);
        } else {
            this.path.lineTo(x, y);
            float _xmax = (float)this.bounds.getMaxX();
            float _ymax = (float)this.bounds.getMaxY();
            float _xmin = (float)this.bounds.getMinX();
            float _ymin = (float)this.bounds.getMinY();
            if (x < _xmin) {
                _xmin = x;
            } else if (x > _xmax) {
                _xmax = x;
            }
            if (y < _ymin) {
                _ymin = y;
            } else if (y > _ymax) {
                _ymax = y;
            }
            this.bounds = new Rectangle2D.Float(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
        }
    }

    public Polyline2D getPolyline2D() {
        Polyline2D pol = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        pol.addPoint(this.xpoints[0], this.ypoints[0]);
        return pol;
    }

    public Polygon getPolygon() {
        int[] _xpoints = new int[this.npoints];
        int[] _ypoints = new int[this.npoints];
        int i2 = 0;
        while (i2 < this.npoints) {
            _xpoints[i2] = (int)this.xpoints[i2];
            _ypoints[i2] = (int)this.ypoints[i2];
            ++i2;
        }
        return new Polygon(_xpoints, _ypoints, this.npoints);
    }

    public void addPoint(Point2D p2) {
        this.addPoint((float)p2.getX(), (float)p2.getY());
    }

    public void addPoint(float x, float y) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.updatePath(x, y);
    }

    public boolean contains(Point p2) {
        return this.contains(p2.x, p2.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.bounds.contains(x, y)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(x, y);
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    public boolean contains(Point2D p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    public boolean intersects(double x, double y, double w, double h2) {
        if (this.npoints <= 0 || !this.bounds.intersects(x, y, w, h2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(x, y, w, h2);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h2) {
        if (this.npoints <= 0 || !this.bounds.intersects(x, y, w, h2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(x, y, w, h2);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        this.updateComputingPath();
        if (this.closedPath == null) {
            return null;
        }
        return this.closedPath.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

