/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class CharBigArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final char[][] EMPTY_BIG_ARRAY = new char[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private CharBigArrays() {
    }

    public static char get(char[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(char[][] array, long index, char value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(char[][] array, long first, long second) {
        char t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static void add(char[][] array, long index, char incr) {
        char[] cArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        cArray[n2] = (char)(cArray[n2] + incr);
    }

    public static void mul(char[][] array, long index, char factor) {
        char[] cArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        cArray[n2] = (char)(cArray[n2] * factor);
    }

    public static void incr(char[][] array, long index) {
        char[] cArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        cArray[n2] = (char)(cArray[n2] + '\u0001');
    }

    public static void decr(char[][] array, long index) {
        char[] cArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        cArray[n2] = (char)(cArray[n2] - '\u0001');
    }

    public static long length(char[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(char[][] srcArray, long srcPos, char[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l2 = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l2);
                if ((srcDispl += l2) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l2) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l2;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l3 = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l3, destArray[destSegment], destDispl - l3, l3);
                srcDispl -= l3;
                destDispl -= l3;
                length -= (long)l3;
            }
        }
    }

    public static void copyFromBig(char[][] srcArray, long srcPos, char[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l2 = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l2);
            if ((srcDispl += l2) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l2;
            length -= l2;
        }
    }

    public static void copyToBig(char[] srcArray, int srcPos, char[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l2 = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l2);
            if ((destDispl += l2) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l2;
            length -= (long)l2;
        }
    }

    public static char[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        char[][] base = new char[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new char[0x8000000];
            }
            base[baseLength - 1] = new char[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new char[0x8000000];
            }
        }
        return base;
    }

    public static char[][] wrap(char[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new char[][]{array};
        }
        char[][] bigArray = CharBigArrays.newBigArray(array.length);
        for (int i2 = 0; i2 < bigArray.length; ++i2) {
            System.arraycopy(array, (int)BigArrays.start(i2), bigArray[i2], 0, bigArray[i2].length);
        }
        return bigArray;
    }

    public static char[][] ensureCapacity(char[][] array, long length) {
        return CharBigArrays.ensureCapacity(array, length, CharBigArrays.length(array));
    }

    public static char[][] ensureCapacity(char[][] array, long length, long preserve) {
        long oldLength = CharBigArrays.length(array);
        if (length > oldLength) {
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
            char[][] base = (char[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i2 = valid; i2 < baseLength - 1; ++i2) {
                    base[i2] = new char[0x8000000];
                }
                base[baseLength - 1] = new char[residual];
            } else {
                for (int i3 = valid; i3 < baseLength; ++i3) {
                    base[i3] = new char[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                CharBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static char[][] grow(char[][] array, long length) {
        long oldLength = CharBigArrays.length(array);
        return length > oldLength ? CharBigArrays.grow(array, length, oldLength) : array;
    }

    public static char[][] grow(char[][] array, long length, long preserve) {
        long oldLength = CharBigArrays.length(array);
        return length > oldLength ? CharBigArrays.ensureCapacity(array, Math.max(106039L * oldLength >>> 16, length), preserve) : array;
    }

    public static char[][] trim(char[][] array, long length) {
        long oldLength = CharBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        char[][] base = (char[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = CharArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static char[][] setLength(char[][] array, long length) {
        long oldLength = CharBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return CharBigArrays.trim(array, length);
        }
        return CharBigArrays.ensureCapacity(array, length);
    }

    public static char[][] copy(char[][] array, long offset, long length) {
        CharBigArrays.ensureOffsetLength(array, offset, length);
        char[][] a2 = CharBigArrays.newBigArray(length);
        CharBigArrays.copy(array, offset, a2, 0L, length);
        return a2;
    }

    public static char[][] copy(char[][] array) {
        char[][] base = (char[][])array.clone();
        int i2 = base.length;
        while (i2-- != 0) {
            base[i2] = (char[])array[i2].clone();
        }
        return base;
    }

    public static void fill(char[][] array, char value) {
        int i2 = array.length;
        while (i2-- != 0) {
            CharArrays.fill(array[i2], value);
        }
    }

    public static void fill(char[][] array, long from, long to, char value) {
        long length = CharBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            CharArrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            CharArrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            CharArrays.fill(array[toSegment], value);
        }
        CharArrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(char[][] a1, char[][] a2) {
        if (CharBigArrays.length(a1) != CharBigArrays.length(a2)) {
            return false;
        }
        int i2 = a1.length;
        while (i2-- != 0) {
            char[] t = a1[i2];
            char[] u = a2[i2];
            int j2 = t.length;
            while (j2-- != 0) {
                if (t[j2] == u[j2]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(char[][] a2) {
        if (a2 == null) {
            return "null";
        }
        long last = CharBigArrays.length(a2) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        long i2 = 0L;
        while (true) {
            b2.append(String.valueOf(CharBigArrays.get(a2, i2)));
            if (i2 == last) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    public static void ensureFromTo(char[][] a2, long from, long to) {
        BigArrays.ensureFromTo(CharBigArrays.length(a2), from, to);
    }

    public static void ensureOffsetLength(char[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(CharBigArrays.length(a2), offset, length);
    }

    private static void vecSwap(char[][] x, long a2, long b2, long n2) {
        int i2 = 0;
        while ((long)i2 < n2) {
            CharBigArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(char[][] x, long a2, long b2, long c2, CharComparator comp) {
        int ab = comp.compare(CharBigArrays.get(x, a2), CharBigArrays.get(x, b2));
        int ac = comp.compare(CharBigArrays.get(x, a2), CharBigArrays.get(x, c2));
        int bc = comp.compare(CharBigArrays.get(x, b2), CharBigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(char[][] x, long from, long to, CharComparator comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && comp.compare(CharBigArrays.get(x, j2 - 1L), CharBigArrays.get(x, j2)) > 0; --j2) {
                    CharBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = CharBigArrays.med3(x, l2, l2 + s, l2 + 2L * s, comp);
                m2 = CharBigArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = CharBigArrays.med3(x, n2 - 2L * s, n2 - s, n2, comp);
            }
            m2 = CharBigArrays.med3(x, l2, m2, n2, comp);
        }
        char v = CharBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(CharBigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    CharBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(CharBigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    CharBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            CharBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        CharBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        CharBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            CharBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1L) {
            CharBigArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    private static long med3(char[][] x, long a2, long b2, long c2) {
        int bc;
        int ac;
        int ab;
        int n2 = CharBigArrays.get(x, a2) < CharBigArrays.get(x, b2) ? -1 : (ab = CharBigArrays.get(x, a2) == CharBigArrays.get(x, b2) ? 0 : 1);
        int n3 = CharBigArrays.get(x, a2) < CharBigArrays.get(x, c2) ? -1 : (ac = CharBigArrays.get(x, a2) == CharBigArrays.get(x, c2) ? 0 : 1);
        int n4 = CharBigArrays.get(x, b2) < CharBigArrays.get(x, c2) ? -1 : (bc = CharBigArrays.get(x, b2) == CharBigArrays.get(x, c2) ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(char[][] x, CharComparator comp) {
        CharBigArrays.quickSort(x, 0L, CharBigArrays.length(x), comp);
    }

    public static void quickSort(char[][] x, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && (CharBigArrays.get(x, j2 - 1L) < CharBigArrays.get(x, j2) ? -1 : (CharBigArrays.get(x, j2 - 1L) == CharBigArrays.get(x, j2) ? 0 : 1)) > 0; --j2) {
                    CharBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = CharBigArrays.med3(x, l2, l2 + s, l2 + 2L * s);
                m2 = CharBigArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = CharBigArrays.med3(x, n2 - 2L * s, n2 - s, n2);
            }
            m2 = CharBigArrays.med3(x, l2, m2, n2);
        }
        char v = CharBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (CharBigArrays.get(x, b2) < v ? -1 : (comparison = CharBigArrays.get(x, b2) == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    CharBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (CharBigArrays.get(x, c2) < v ? -1 : (comparison = CharBigArrays.get(x, c2) == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    CharBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            CharBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        CharBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        CharBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            CharBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1L) {
            CharBigArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(char[][] x) {
        CharBigArrays.quickSort(x, 0L, CharBigArrays.length(x));
    }

    public static long binarySearch(char[][] a2, long from, long to, char key) {
        while (from <= to) {
            long mid = from + to >>> 1;
            char midVal = CharBigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(char[][] a2, char key) {
        return CharBigArrays.binarySearch(a2, 0L, CharBigArrays.length(a2), key);
    }

    public static long binarySearch(char[][] a2, long from, long to, char key, CharComparator c2) {
        while (from <= to) {
            long mid = from + to >>> 1;
            char midVal = CharBigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(char[][] a2, char key, CharComparator c2) {
        return CharBigArrays.binarySearch(a2, 0L, CharBigArrays.length(a2), key, c2);
    }

    public static char[][] shuffle(char[][] a2, long from, long to, Random random) {
        long i2 = to - from;
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            char t = CharBigArrays.get(a2, from + i2);
            CharBigArrays.set(a2, from + i2, CharBigArrays.get(a2, from + p2));
            CharBigArrays.set(a2, from + p2, t);
        }
        return a2;
    }

    public static char[][] shuffle(char[][] a2, Random random) {
        long i2 = CharBigArrays.length(a2);
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            char t = CharBigArrays.get(a2, i2);
            CharBigArrays.set(a2, i2, CharBigArrays.get(a2, p2));
            CharBigArrays.set(a2, p2, t);
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BigArrayHashStrategy
    implements Hash.Strategy<char[][]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[][] o2) {
            return Arrays.deepHashCode((Object[])o2);
        }

        @Override
        public boolean equals(char[][] a2, char[][] b2) {
            return CharBigArrays.equals(a2, b2);
        }
    }
}

