/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.TreeIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class DialogPageTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color _textSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
    protected Color _textNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
    protected Color _bkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
    protected Color _bkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
    protected Color _borderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
    protected boolean m_selected;
    private static final Icon SELECTED = TreeIconsFactory.getImageIcon("icons/selected-b16.gif");
    private static final Icon BLANK = TreeIconsFactory.getImageIcon("icons/blank-16.gif");

    public DialogPageTreeCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof Boolean) {
            this.setText("Retrieving data...");
        }
        if (object2 instanceof AbstractDialogPage) {
            AbstractDialogPage abstractDialogPage = (AbstractDialogPage)object2;
            this.setText(abstractDialogPage.getTitle());
        } else {
            this.setText(object2.toString());
            this.setIcon(null);
        }
        this.setFont(jTree.getFont());
        this.setForeground(bl ? this._textSelectionColor : this._textNonSelectionColor);
        this.setBackground(bl ? this._bkSelectionColor : this._bkNonSelectionColor);
        if (bl3) {
            if (bl) {
                this.setIcon(SELECTED);
            } else {
                this.setIcon(BLANK);
            }
        } else if (bl2) {
            this.setIcon(UIDefaultsLookup.getIcon("Tree.openIcon"));
        } else {
            this.setIcon(UIDefaultsLookup.getIcon("Tree.closedIcon"));
        }
        this.m_selected = bl;
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        graphics.setColor(color);
        int n2 = 0;
        if (icon != null && this.getText() != null) {
            n2 = icon.getIconWidth() + this.getIconTextGap() - 1;
        }
        graphics.fillRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
        if (this.m_selected) {
            graphics.setColor(this._borderSelectionColor);
            graphics.drawRect(n2, 0, this.getWidth() - n2 - 1, this.getHeight() - 1);
        }
        super.paintComponent(graphics);
    }
}

