/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.tribble.util.HTTPHelper;
import org.broad.tribble.util.SeekableFTPStream;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableHTTPStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.URLHelper;

public class SeekableStreamFactory {
    private static Logger log = Logger.getLogger(SeekableStreamFactory.class);
    private static Class httpHelperClass = HTTPHelper.class;

    public static SeekableStream getStreamFor(String path) throws IOException {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            URL url = new URL(path);
            return SeekableStreamFactory.getHttpStream(url);
        }
        if (path.startsWith("ftp:")) {
            return new SeekableFTPStream(new URL(path));
        }
        return new SeekableFileStream(new File(path));
    }

    public static SeekableStream getHttpStream(URL url) {
        try {
            URLHelper helper = SeekableStreamFactory.getURLHelper(url);
            return new SeekableHTTPStream(helper);
        }
        catch (Exception e2) {
            log.error("Error creating URL helper: ", e2);
            throw new RuntimeException("Error creating URL helper: " + e2.toString());
        }
    }

    public static void registerHelperClass(Class helperClass) {
        if (!helperClass.isAssignableFrom(URLHelper.class)) {
            // empty if block
        }
        httpHelperClass = helperClass;
    }

    public static URLHelper getURLHelper(URL url) {
        try {
            Constructor constr = httpHelperClass.getConstructor(URL.class);
            URLHelper helper = (URLHelper)constr.newInstance(url);
            return helper;
        }
        catch (Exception e2) {
            log.error("Error instantiating url helper for class: " + httpHelperClass, e2);
            return new HTTPHelper(url);
        }
    }
}

