/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.index.AbstractIndex;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class LinearIndex
extends AbstractIndex
implements Index {
    public static final double MAX_FEATURES_PER_BIN = Double.valueOf(System.getProperty("MAX_FEATURES_PER_BIN", "100"));
    private static final int MAX_BIN_WIDTH = 1000000000;
    private static final long MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX = Long.valueOf(System.getProperty("MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX", "1024000"));
    private static Logger log = Logger.getLogger(LinearIndex.class);
    public static boolean enableAdaptiveIndexing = true;

    public LinearIndex() {
    }

    @Override
    public boolean isCurrentVersion() {
        if (!super.isCurrentVersion()) {
            return false;
        }
        for (org.broad.tribble.index.ChrIndex chrIndex : this.chrIndeces.values()) {
            if (!((ChrIndex)chrIndex).OLD_V3_INDEX) continue;
            return false;
        }
        return true;
    }

    public LinearIndex(List<ChrIndex> indicies, File inputFile) {
        super(inputFile.getAbsolutePath());
        for (ChrIndex index : indicies) {
            this.chrIndeces.put(index.getName(), index);
        }
    }

    private LinearIndex(LinearIndex parent, List<ChrIndex> indicies) {
        super(parent);
        for (ChrIndex index : indicies) {
            this.chrIndeces.put(index.getName(), index);
        }
    }

    public LinearIndex(String featureFile) {
        super(featureFile);
    }

    @Override
    protected int getType() {
        return IndexFactory.IndexType.LINEAR.getHeaderValue();
    }

    @Override
    public LinkedHashSet<String> getSequenceNames() {
        return this.chrIndeces == null ? new LinkedHashSet<String>() : new LinkedHashSet(this.chrIndeces.keySet());
    }

    @Override
    public Class getIndexClass() {
        return ChrIndex.class;
    }

    public Index optimize(double threshold) {
        if (enableAdaptiveIndexing) {
            log.debug("Adaptive optimization of " + this.indexedFile + " with threshold " + threshold);
            if (log.isDebugEnabled()) {
                this.printIndexInfo();
            }
            ArrayList<ChrIndex> newIndices = new ArrayList<ChrIndex>(this.chrIndeces.size());
            for (String name : this.chrIndeces.keySet()) {
                ChrIndex oldIdx = (ChrIndex)this.chrIndeces.get(name);
                ChrIndex newIdx = oldIdx.optimize(threshold);
                newIndices.add(newIdx);
            }
            LinearIndex newIndex = new LinearIndex(this, newIndices);
            log.debug(String.format("Old index %s vs. new %s", this.statsSummary(), newIndex.statsSummary()));
            return newIndex;
        }
        return this;
    }

    public Index optimize() {
        return this.optimize(MAX_FEATURES_PER_BIN);
    }

    public void writeTable(PrintStream out) {
        out.printf("chr binWidth avg.feature.size nFeatures.total block.id start.pos size nFeatures%n", new Object[0]);
        for (String name : this.chrIndeces.keySet()) {
            ChrIndex chrIdx = (ChrIndex)this.chrIndeces.get(name);
            int blockCount = 0;
            for (Block b2 : chrIdx.getBlocks()) {
                out.printf("%s %d %.2f %d %d %d %d %d%n", name, chrIdx.binWidth, chrIdx.getAverageFeatureSize(), chrIdx.getNFeatures(), blockCount, blockCount * chrIdx.binWidth, b2.getSize(), (int)((double)b2.getSize() / chrIdx.getAverageFeatureSize()));
                ++blockCount;
            }
        }
    }

    public static class ChrIndex
    implements org.broad.tribble.index.ChrIndex {
        private String name = "";
        private int binWidth;
        private int longestFeature;
        private int nFeatures;
        private List<Block> blocks;
        private boolean OLD_V3_INDEX = false;

        public ChrIndex() {
        }

        ChrIndex(String name, int binWidth) {
            this.name = name;
            this.binWidth = binWidth;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.nFeatures = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
        }

        public int getNBlocks() {
            return this.blocks.size();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            if (this.blocks == null || this.blocks.isEmpty()) {
                return null;
            }
            int adjustedPosition = Math.max(start - this.longestFeature, 0);
            int startBinNumber = Math.min(adjustedPosition / this.binWidth, this.blocks.size() - 1);
            int endBinNumber = Math.min(end / this.binWidth, this.blocks.size() - 1);
            return this.blocks.subList(startBinNumber, endBinNumber + 1);
        }

        public void updateLongestFeature(int featureLength) {
            this.longestFeature = Math.max(this.longestFeature, featureLength);
        }

        public int getNFeatures() {
            return this.nFeatures;
        }

        public void incrementFeatureCount() {
            ++this.nFeatures;
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            dos.writeInt(this.binWidth);
            dos.writeInt(this.blocks.size());
            dos.writeInt(this.longestFeature);
            dos.writeInt(0);
            dos.writeInt(this.nFeatures);
            long pos = 0L;
            int size = 0;
            for (Block block : this.blocks) {
                pos = block.getStartPosition();
                size = block.getSize();
                dos.writeLong(pos);
            }
            dos.writeLong(pos + (long)size);
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.name = dis.readString();
            this.binWidth = dis.readInt();
            int nBins = dis.readInt();
            this.longestFeature = dis.readInt();
            this.OLD_V3_INDEX = dis.readInt() > 0;
            this.nFeatures = dis.readInt();
            this.blocks = new ArrayList<Block>(nBins);
            long pos = dis.readLong();
            for (int binNumber = 0; binNumber < nBins; ++binNumber) {
                long nextPos = dis.readLong();
                int size = (int)(nextPos - pos);
                this.blocks.add(new Block(pos, size));
                pos = nextPos;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChrIndex)) {
                return false;
            }
            ChrIndex other = (ChrIndex)obj;
            return this.binWidth == other.binWidth && this.longestFeature == other.longestFeature && this.nFeatures == other.nFeatures && this.name.equals(other.name) && ((Object)this.blocks).equals(other.blocks);
        }

        public int getTotalSize() {
            int n2 = 0;
            for (Block b2 : this.getBlocks()) {
                n2 += b2.getSize();
            }
            return n2;
        }

        public double getAverageFeatureSize() {
            return 1.0 * (double)this.getTotalSize() / (double)this.getNFeatures();
        }

        public double getFeaturesPerBlock() {
            return 1.0 * (double)this.getNFeatures() / (double)this.getNBlocks();
        }

        private double getNFeaturesOfMostDenseBlock(double featureSize) {
            double m2 = -1.0;
            for (Block b2 : this.getBlocks()) {
                double n2 = (double)b2.getSize() / featureSize;
                if (m2 != -1.0 && !(n2 > m2)) continue;
                m2 = n2;
            }
            return m2;
        }

        private double optimizeScore() {
            return this.getNFeaturesOfMostDenseBlock(this.getAverageFeatureSize());
        }

        public ChrIndex optimize(double threshold) {
            return ChrIndex.optimize(this, threshold, 0);
        }

        private static boolean badBinWidth(ChrIndex idx) {
            if (idx.binWidth > 1000000000 || idx.binWidth < 0) {
                return true;
            }
            if (MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX != 0L && idx.getNFeatures() > 1 && (long)idx.binWidth > MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX) {
                log.debug(String.format("No longer merging up bins on %s with %d features as binWidth %d > max %d for occupied indices", idx.getName(), idx.getNFeatures(), idx.binWidth, MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX));
                return true;
            }
            return false;
        }

        private static ChrIndex optimize(ChrIndex idx, double threshold, int level) {
            ChrIndex best;
            block1: {
                best = idx;
                do {
                    double score = idx.optimizeScore();
                    log.debug(String.format("  %s%6s with %8d bins of size %6d: feature size est.  is %.2f, features per block %.5f, most dense %.5f, score %.5f", ChrIndex.dupString(' ', level * 2), idx.getName(), idx.getNBlocks(), idx.binWidth, idx.getAverageFeatureSize(), idx.getFeaturesPerBlock(), idx.getNFeaturesOfMostDenseBlock(idx.getAverageFeatureSize()), score));
                    if (score > threshold || idx.getNBlocks() == 1 || ChrIndex.badBinWidth(idx)) break block1;
                    best = idx;
                    idx = ChrIndex.mergeBlocks(idx);
                } while (++level <= 30);
                throw new IllegalStateException("Too many iterations");
            }
            return best;
        }

        private static ChrIndex mergeBlocks(ChrIndex idx) {
            ChrIndex merged = new ChrIndex(idx.name, idx.binWidth * 2);
            merged.longestFeature = idx.longestFeature;
            merged.nFeatures = idx.nFeatures;
            Iterator<Block> blocks = idx.getBlocks().iterator();
            if (!blocks.hasNext()) {
                throw new IllegalStateException("Block iterator cannot be empty at the start for " + idx.getName());
            }
            while (blocks.hasNext()) {
                Block b2;
                Block b1 = blocks.next();
                Block block = b2 = blocks.hasNext() ? blocks.next() : null;
                if (b2 == null) {
                    merged.addBlock(b1);
                    continue;
                }
                merged.addBlock(new Block(b1.getStartPosition(), b1.getSize() + b2.getSize()));
            }
            return merged;
        }

        private static String dupString(char c2, int nCopies) {
            char[] chars = new char[nCopies];
            Arrays.fill(chars, c2);
            return new String(chars);
        }
    }
}

