/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.MouseableRegion;

public class DataPanelPainter {
    private static Logger log = Logger.getLogger(DataPanelPainter.class);

    public void paint(Collection<TrackGroup> groups, RenderContext context, int width, int height, Color background, Rectangle visibleRect, List<MouseableRegion> mouseableRegions) {
        Graphics graphics2D = null;
        try {
            graphics2D = (Graphics2D)context.getGraphics().create();
            ((Graphics2D)graphics2D).setBackground(background);
            graphics2D.clearRect(0, 0, width, height);
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = context.getGraphic2DForColor(UIConstants.ZOOMED_OUT_COLOR);
            int trackX = 0;
            int trackY = 0;
            for (TrackGroup group : groups) {
                if (visibleRect != null && trackY > visibleRect.y + visibleRect.height) {
                    break;
                }
                if (!group.isVisible()) continue;
                if (groups.size() > 1) {
                    greyGraphics.fillRect(0, trackY + 1, width, 9);
                    trackY += 10;
                }
                if (group.isDrawBorder()) {
                    graphics2D.drawLine(0, trackY - 1, width, trackY - 1);
                }
                List<Track> trackList = group.getTracks();
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (visibleRect != null) {
                        if (trackY > visibleRect.y + visibleRect.height) break;
                        if (trackY + trackHeight < visibleRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, width, trackHeight);
                    this.draw(track, rect, context);
                    if (mouseableRegions != null) {
                        mouseableRegions.add(new MouseableRegion(rect, track));
                    }
                    trackY += trackHeight;
                }
                if (!group.isDrawBorder()) continue;
                graphics2D.drawLine(0, trackY, width, trackY);
            }
        }
        catch (RuntimeException e2) {
            log.error(e2);
            throw e2;
        }
        finally {
            graphics2D.dispose();
        }
    }

    private final void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getTrackManager().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }
}

