/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.fraction;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.fraction.Fraction;
import org.apache.commons.math.fraction.ProperFractionFormat;

public class FractionFormat
extends Format
implements Serializable {
    private static final long serialVersionUID = -6337346779577272306L;
    private NumberFormat denominatorFormat;
    private NumberFormat numeratorFormat;

    public FractionFormat() {
        this(FractionFormat.getDefaultNumberFormat());
    }

    public FractionFormat(NumberFormat format) {
        this(format, (NumberFormat)format.clone());
    }

    public FractionFormat(NumberFormat numeratorFormat, NumberFormat denominatorFormat) {
        this.numeratorFormat = numeratorFormat;
        this.denominatorFormat = denominatorFormat;
    }

    public static String formatFraction(Fraction f2) {
        return FractionFormat.getImproperInstance().format(f2);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static FractionFormat getImproperInstance() {
        return FractionFormat.getImproperInstance(Locale.getDefault());
    }

    public static FractionFormat getImproperInstance(Locale locale) {
        NumberFormat f2 = FractionFormat.getDefaultNumberFormat(locale);
        return new FractionFormat(f2);
    }

    public static FractionFormat getProperInstance() {
        return FractionFormat.getProperInstance(Locale.getDefault());
    }

    public static FractionFormat getProperInstance(Locale locale) {
        NumberFormat f2 = FractionFormat.getDefaultNumberFormat(locale);
        return new ProperFractionFormat(f2);
    }

    protected static NumberFormat getDefaultNumberFormat() {
        return FractionFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    private static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        nf.setMaximumFractionDigits(0);
        nf.setParseIntegerOnly(true);
        return nf;
    }

    public StringBuffer format(Fraction fraction, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        this.getNumeratorFormat().format(fraction.getNumerator(), toAppendTo, pos);
        toAppendTo.append(" / ");
        this.getDenominatorFormat().format(fraction.getDenominator(), toAppendTo, pos);
        return toAppendTo;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer ret = null;
        if (obj instanceof Fraction) {
            ret = this.format((Fraction)obj, toAppendTo, pos);
        } else if (obj instanceof Number) {
            try {
                ret = this.format(new Fraction(((Number)obj).doubleValue()), toAppendTo, pos);
            }
            catch (ConvergenceException ex) {
                throw new IllegalArgumentException("Cannot convert given object to a fraction.");
            }
        } else {
            throw new IllegalArgumentException("Cannot format given object as a fraction");
        }
        return ret;
    }

    public NumberFormat getDenominatorFormat() {
        return this.denominatorFormat;
    }

    public NumberFormat getNumeratorFormat() {
        return this.numeratorFormat;
    }

    public Fraction parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Fraction result = this.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable fraction number: \"" + source + "\"", parsePosition.getErrorIndex());
        }
        return result;
    }

    public Fraction parse(String source, ParsePosition pos) {
        int initialIndex = pos.getIndex();
        FractionFormat.parseAndIgnoreWhitespace(source, pos);
        Number num = this.getNumeratorFormat().parse(source, pos);
        if (num == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        int startIndex = pos.getIndex();
        char c2 = FractionFormat.parseNextCharacter(source, pos);
        switch (c2) {
            case '\u0000': {
                return new Fraction(num.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                pos.setIndex(initialIndex);
                pos.setErrorIndex(startIndex);
                return null;
            }
        }
        FractionFormat.parseAndIgnoreWhitespace(source, pos);
        Number den = this.getDenominatorFormat().parse(source, pos);
        if (den == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        return new Fraction(num.intValue(), den.intValue());
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setDenominatorFormat(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("denominator format can not be null.");
        }
        this.denominatorFormat = format;
    }

    public void setNumeratorFormat(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("numerator format can not be null.");
        }
        this.numeratorFormat = format;
    }

    protected static void parseAndIgnoreWhitespace(String source, ParsePosition pos) {
        FractionFormat.parseNextCharacter(source, pos);
        pos.setIndex(pos.getIndex() - 1);
    }

    protected static char parseNextCharacter(String source, ParsePosition pos) {
        int index = pos.getIndex();
        int n2 = source.length();
        char ret = '\u0000';
        if (index < n2) {
            char c2;
            while (Character.isWhitespace(c2 = source.charAt(index++)) && index < n2) {
            }
            pos.setIndex(index);
            if (index < n2) {
                ret = c2;
            }
        }
        return ret;
    }
}

