/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.util.MathUtils;

public class HypergeometricDistributionImpl
extends AbstractIntegerDistribution
implements HypergeometricDistribution,
Serializable {
    private static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistributionImpl(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (numberOfSuccesses > populationSize) {
            throw new IllegalArgumentException("number of successes must be less than or equal to population size");
        }
        if (sampleSize > populationSize) {
            throw new IllegalArgumentException("sample size must be less than or equal to population size");
        }
        this.setPopulationSize(populationSize);
        this.setSampleSize(sampleSize);
        this.setNumberOfSuccesses(numberOfSuccesses);
    }

    public double cumulativeProbability(int x) {
        int k2;
        int m2;
        int n2 = this.getPopulationSize();
        int[] domain = this.getDomain(n2, m2 = this.getNumberOfSuccesses(), k2 = this.getSampleSize());
        double ret = x < domain[0] ? 0.0 : (x >= domain[1] ? 1.0 : this.innerCumulativeProbability(domain[0], x, 1, n2, m2, k2));
        return ret;
    }

    private int[] getDomain(int n2, int m2, int k2) {
        return new int[]{this.getLowerDomain(n2, m2, k2), this.getUpperDomain(m2, k2)};
    }

    protected int getDomainLowerBound(double p2) {
        return this.getLowerDomain(this.getPopulationSize(), this.getNumberOfSuccesses(), this.getSampleSize());
    }

    protected int getDomainUpperBound(double p2) {
        return this.getUpperDomain(this.getSampleSize(), this.getNumberOfSuccesses());
    }

    private int getLowerDomain(int n2, int m2, int k2) {
        return Math.max(0, m2 - (n2 - k2));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m2, int k2) {
        return Math.min(k2, m2);
    }

    public double probability(int x) {
        int k2;
        int m2;
        int n2 = this.getPopulationSize();
        int[] domain = this.getDomain(n2, m2 = this.getNumberOfSuccesses(), k2 = this.getSampleSize());
        double ret = x < domain[0] || x > domain[1] ? 0.0 : this.probability(n2, m2, k2, x);
        return ret;
    }

    private double probability(int n2, int m2, int k2, int x) {
        return Math.exp(MathUtils.binomialCoefficientLog(m2, x) + MathUtils.binomialCoefficientLog(n2 - m2, k2 - x) - MathUtils.binomialCoefficientLog(n2, k2));
    }

    public void setNumberOfSuccesses(int num) {
        if (num < 0) {
            throw new IllegalArgumentException("number of successes must be non-negative.");
        }
        this.numberOfSuccesses = num;
    }

    public void setPopulationSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("population size must be positive.");
        }
        this.populationSize = size;
    }

    public void setSampleSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("sample size must be non-negative.");
        }
        this.sampleSize = size;
    }

    public double upperCumulativeProbability(int x) {
        int k2;
        int m2;
        int n2 = this.getPopulationSize();
        int[] domain = this.getDomain(n2, m2 = this.getNumberOfSuccesses(), k2 = this.getSampleSize());
        double ret = x < domain[0] ? 1.0 : (x > domain[1] ? 0.0 : this.innerCumulativeProbability(domain[1], x, -1, n2, m2, k2));
        return ret;
    }

    private double innerCumulativeProbability(int x0, int x1, int dx, int n2, int m2, int k2) {
        double ret = this.probability(n2, m2, k2, x0);
        while (x0 != x1) {
            ret += this.probability(n2, m2, k2, x0 += dx);
        }
        return ret;
    }
}

