/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    private static ProxySettings proxySettings = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderField(URL url, String name) {
        HttpURLConnection conn = null;
        try {
            conn = HttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            String string = conn.getHeaderField(name);
            return string;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
        }
    }

    public static long getContentLength(URL url) {
        String contentLengthString = HttpUtils.getHeaderField(url, "Content-length");
        if (contentLengthString == null) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error parsing content length string: " + contentLengthString);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = HttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            if (conn.getHeaderField("ETag") != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
        }
    }

    public static HttpURLConnection openConnection(URL url) throws IOException {
        if (proxySettings != null && HttpUtils.proxySettings.useProxy && HttpUtils.proxySettings.proxyHost != null && HttpUtils.proxySettings.proxyPort > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(HttpUtils.proxySettings.proxyHost, HttpUtils.proxySettings.proxyPort));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
            if (HttpUtils.proxySettings.auth && HttpUtils.proxySettings.user != null && HttpUtils.proxySettings.pw != null) {
                String encodedUserPwd = HttpUtils.base64Encode(HttpUtils.proxySettings.user + ":" + HttpUtils.proxySettings.pw);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
            return conn;
        }
        return (HttpURLConnection)url.openConnection();
    }

    public static String base64Encode(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] bytes = str.getBytes();
        return encoder.encode(bytes);
    }

    public static String base64Decode(String str) {
        try {
            return new String(new BASE64Decoder().decodeBuffer(str));
        }
        catch (IOException e2) {
            log.error("Error decoding string: " + str, e2);
            return str;
        }
    }

    public static void setProxySettings(ProxySettings ps) {
        proxySettings = ps;
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

