/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.GridLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ftp.FTPClient;
import org.broad.igv.util.ftp.FTPStream;
import org.broad.igv.util.ftp.FTPUtils;
import org.broad.tribble.util.SeekableHTTPStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class IGVHttpUtils {
    private static Logger log = Logger.getLogger(IGVHttpUtils.class);
    private static ProxySettings proxySettings = null;
    static boolean byteRangeTested = false;
    static boolean useByteRange = true;
    private static Map<String, List<String>> gsCookies = new HashMap<String, List<String>>();

    private static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new URL(testURL));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            log.error("Error while testing byte range ", e2);
            return false;
        }
    }

    public static synchronized boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().getAsBoolean("UseHttpByteRange");
        if (useByteRange && !byteRangeTested) {
            useByteRange = IGVHttpUtils.testByteRange();
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public static void disconnect(URLConnection serverConnection) {
        if (serverConnection != null && serverConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)serverConnection).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(URL url, File outputFile) throws IOException {
        int maxTries = 1000;
        int nTries = 0;
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        int downloaded = 0;
        byte[] buf = new byte[65536];
        FileOutputStream out = null;
        InputStream is = null;
        try {
            boolean bl;
            int bytesRead;
            out = new FileOutputStream(outputFile);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            int contentLength = connection.getContentLength();
            if (contentLength <= 0) {
                log.debug("Content-length = " + contentLength);
                is = connection.getInputStream();
                while ((bytesRead = is.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, bytesRead);
                    downloaded += bytesRead;
                }
            } else {
                while (downloaded < contentLength && nTries < maxTries) {
                    is = connection.getInputStream();
                    while ((bytesRead = is.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, bytesRead);
                        downloaded += bytesRead;
                    }
                    if (contentLength <= downloaded) continue;
                    is.close();
                    connection = IGVHttpUtils.openConnection(url);
                    connection.setRequestProperty("Range", "bytes=" + downloaded + "-");
                    ++nTries;
                    log.info("Restarting download from position: " + downloaded);
                }
            }
            if (downloaded < contentLength) {
                ((OutputStream)out).close();
                out = null;
                outputFile.delete();
                MessageUtils.showMessage("Error downloading file: " + outputFile.getAbsoluteFile());
                bl = false;
                return bl;
            }
            log.info("Download complete.  Transferred " + downloaded + " bytes");
            bl = true;
            return bl;
        }
        catch (Exception e2) {
            ((OutputStream)out).close();
            out = null;
            outputFile.delete();
            MessageUtils.showMessage("<html>Error downloading file: " + outputFile.getAbsoluteFile() + "<br/>" + e2.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    public static InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo);
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        if (url.toString().contains("genomespace.org")) {
            return IGVHttpClientUtils.openGSConnectionStream(url);
        }
        return IGVHttpUtils.openHttpStream(url);
    }

    public static InputStream openHttpStream(URL url) throws IOException {
        HttpURLConnection conn = IGVHttpUtils.openConnection(url);
        InputStream is = conn.getInputStream();
        return new URLInputStream(conn, is);
    }

    public static HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection conn = null;
        if (IGVHttpUtils.useProxy()) {
            Proxy proxy = IGVHttpUtils.getProxy();
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (IGVHttpUtils.proxySettings.auth && IGVHttpUtils.proxySettings.user != null && IGVHttpUtils.proxySettings.pw != null) {
                String encodedUserPwd = IGVHttpUtils.base64Encode(IGVHttpUtils.proxySettings.user + ":" + IGVHttpUtils.proxySettings.pw);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestProperty("Connection", "close");
        if (conn.getResponseCode() == 401) {
            final String userPass = IGVHttpUtils.getUserPass(url.toExternalForm());
            if (userPass == null) {
                throw new RuntimeException("A password is required to access " + url.toString());
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    String[] tokens = userPass.split(":");
                    return new PasswordAuthentication(tokens[0], tokens[1].toCharArray());
                }
            });
            IGVHttpUtils.disconnect(conn);
            return IGVHttpUtils.openConnection(url);
        }
        return conn;
    }

    public static Proxy getProxy() {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(IGVHttpUtils.proxySettings.proxyHost, IGVHttpUtils.proxySettings.proxyPort));
        return proxy;
    }

    public static boolean useProxy() {
        return proxySettings != null && IGVHttpUtils.proxySettings.useProxy && IGVHttpUtils.proxySettings.proxyHost != null && IGVHttpUtils.proxySettings.proxyPort > 0;
    }

    public static String getUserPass(String locationString) {
        JPanel passPanel = new JPanel();
        passPanel.setLayout(new GridLayout(6, 1));
        JLabel message = new JLabel("Please enter your username and password");
        if (locationString.length() > 80) {
            locationString = "..." + locationString.substring(locationString.length() - 80);
        }
        JLabel location = new JLabel(locationString);
        JLabel username = new JLabel("User:");
        JLabel password = new JLabel("Pass:");
        JTextField userField = new JTextField();
        JPasswordField passwordField = new JPasswordField();
        passPanel.add(message);
        passPanel.add(location);
        passPanel.add(username);
        passPanel.add(userField);
        passPanel.add(password);
        passPanel.add(passwordField);
        int a2 = JOptionPane.showConfirmDialog(null, passPanel, "Authentication Required", 2, 3);
        if (a2 == 2) {
            return null;
        }
        String userString = userField.getText();
        String userPass = new String(passwordField.getPassword());
        return userString + ":" + userPass;
    }

    public static void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        ProxySettings proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort);
        IGVHttpUtils.setProxySettings(proxySettings);
    }

    public static String base64Encode(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] bytes = str.getBytes();
        return encoder.encode(bytes);
    }

    public static String base64Decode(String str) {
        try {
            return new String(new BASE64Decoder().decodeBuffer(str));
        }
        catch (IOException e2) {
            log.error("Error decoding string: " + str, e2);
            return str;
        }
    }

    public static void setProxySettings(ProxySettings ps) {
        proxySettings = ps;
    }

    public static String getETag(URL url) {
        return IGVHttpUtils.getHeaderField(url, "ETag");
    }

    public static long getContentLength(URL url) {
        String contentLengthString = IGVHttpUtils.getHeaderField(url, "Content-Length");
        try {
            return Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error getting content length from: " + url.toString() + "\n" + "Content-length=" + contentLengthString);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderField(URL url, String name) {
        if (url.toString().contains("genomespace.org")) {
            try {
                return IGVHttpClientUtils.getGSHeaderField(url, name);
            }
            catch (IOException e2) {
                log.error("Error getting header field: " + name, e2);
                return null;
            }
        }
        InputStream is = null;
        try {
            is = IGVHttpUtils.openConnectionStream(url);
        }
        catch (IOException e3) {
            log.error("Error getting header field", e3);
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e4) {
                log.error("", e4);
            }
        }
        HttpURLConnection conn = null;
        try {
            conn = IGVHttpUtils.openConnection(url);
            conn.setReadTimeout(5000);
            String string = conn.getHeaderField(name);
            return string;
        }
        catch (Exception e5) {
            log.error("Error getting header field: " + name, e5);
            String string = null;
            return string;
        }
        finally {
            if (conn != null && conn instanceof HttpURLConnection) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL url) {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return FTPUtils.resourceAvailable(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            int rc = conn.getResponseCode();
            boolean bl = rc < 400;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static class URLInputStream
    extends FilterInputStream {
        HttpURLConnection connection;

        protected URLInputStream(HttpURLConnection connection, InputStream inputStream) {
            super(inputStream);
            this.connection = connection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.connection.disconnect();
        }
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

