/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.broad.igv.gs.GSLoginDialog;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;

public class IGVHttpClientUtils {
    private static Logger log = Logger.getLogger(IGVHttpClientUtils.class);
    static DefaultHttpClient client = null;

    public static InputStream openGSConnectionStream(URL url) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url);
        return response.getEntity().getContent();
    }

    public static String getGSHeaderField(URL url, String key) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url);
        return response.getFirstHeader(key).getValue();
    }

    private static HttpResponse executeGet(URL url) throws IOException {
        if (client == null) {
            client = new DefaultHttpClient();
        }
        HttpRequestBase getMethod = null;
        try {
            if (GSUtils.isGenomeSpace(url)) {
                GSUtils.checkForCookie(client, url);
            }
            getMethod = new HttpGet(url.toExternalForm());
            client.getParams().setParameter("http.protocol.allow-circular-redirects", true);
            HttpResponse response = client.execute(getMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                getMethod.abort();
                client.getCredentialsProvider().clear();
                IGVHttpClientUtils.login(url);
                return IGVHttpClientUtils.executeGet(url);
            }
            if (statusCode != 200) {
                getMethod.abort();
                throw new RuntimeException("Error connecting.  Status code = " + statusCode);
            }
            return response;
        }
        catch (RuntimeException e2) {
            if (getMethod != null) {
                getMethod.abort();
            }
            throw e2;
        }
    }

    private static void login(URL url) {
        Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
        String userpass = IGVHttpClientUtils.getGSUserPass(owner);
        if (userpass == null) {
            throw new RuntimeException("Access denied to: " + url.toString());
        }
        UsernamePasswordCredentials GENOME_SPACE_CREDS = new UsernamePasswordCredentials(userpass);
        String host = GSUtils.isGenomeSpace(url) ? "identitytest.genomespace.org" : url.getHost();
        client.getCredentialsProvider().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), GENOME_SPACE_CREDS);
        if (GSUtils.isGenomeSpace(url)) {
            try {
                HttpGet httpget = new HttpGet("https://identitytest.genomespace.org:8443/identityServer/basic");
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = client.execute((HttpUriRequest)httpget, responseHandler);
                if (responseBody != null && responseBody.length() > 0) {
                    String[] tokens = userpass.split(":");
                    String user = tokens[0];
                    GSUtils.saveLoginForSSO(responseBody, user);
                }
            }
            catch (IOException e2) {
                log.error("Error fetching GS token", e2);
            }
        }
    }

    public static String getGSUserPass(Frame owner) {
        GSLoginDialog dlg = new GSLoginDialog(owner);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        String userString = dlg.getUsername();
        String userPass = new String(dlg.getPassword());
        return userString + ":" + userPass;
    }
}

