/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class DataPanelLayout
implements LayoutManager {
    private static Logger log = Logger.getLogger(DataPanelLayout.class);
    int hgap = 5;

    @Override
    public void addLayoutComponent(String s, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                dim.height = Math.max(dim.height, d2.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d2.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            return new Dimension(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] children = container.getComponents();
            List<ReferenceFrame> frames = FrameManager.getFrames();
            int h2 = container.getHeight();
            try {
                for (int i2 = 0; i2 < children.length; ++i2) {
                    Component c2 = children[i2];
                    ReferenceFrame frame = frames.get(i2);
                    c2.setBounds(frame.pixelX, 0, frame.getWidthInPixels(), h2);
                    if (c2 instanceof JComponent) {
                        if (frame.getWidthInPixels() > 5) {
                            ((JComponent)c2).setBorder(BorderFactory.createLineBorder(Color.gray));
                        } else {
                            ((JComponent)c2).setBorder(null);
                        }
                    }
                    log.debug("Layout: " + frame.name + "  x=" + frame.pixelX + "  w=" + frame.getWidthInPixels());
                }
            }
            catch (Exception e2) {
                log.error("Error laying out data panel", e2);
            }
        }
    }
}

