/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelLayout;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;

public class DataPanelContainer
extends TrackPanelComponent
implements Paintable {
    private static Logger log = Logger.getLogger(DataPanelContainer.class);
    TrackPanel parent;

    public DataPanelContainer(TrackPanel trackPanel) {
        super(trackPanel);
        DropTarget target = new DropTarget(this, new FileDropTargetListener(trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
        this.setLayout(new DataPanelLayout());
        this.parent = trackPanel;
        this.createDataPanels();
    }

    public void createDataPanels() {
        this.removeAll();
        for (ReferenceFrame f2 : FrameManager.getFrames()) {
            DataPanel dp = new DataPanel(f2, this);
            this.add(dp);
        }
        this.invalidate();
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    public void setCurrentTool(RegionOfInterestTool regionOfInterestTool) {
        for (Component c2 : this.getComponents()) {
            if (!(c2 instanceof DataPanel)) continue;
            ((DataPanel)c2).setCurrentTool(regionOfInterestTool);
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        Component[] components = this.getComponents();
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component1) {
                return component.getX() - component1.getX();
            }
        });
        for (Component c2 : this.getComponents()) {
            if (!(c2 instanceof DataPanel)) continue;
            Graphics2D g2d = (Graphics2D)g2.create();
            Rectangle clipRect = new Rectangle(c2.getBounds());
            clipRect.height = rect.height;
            g2d.setClip(clipRect);
            g2d.translate(c2.getX(), 0);
            ((DataPanel)c2).paintOffscreen(g2d, rect);
        }
        super.paintBorder(g2);
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(TrackPanel dataPanel) {
            this.panel = dataPanel;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            MessageCollection messages = new MessageCollection();
            try {
                List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    try {
                        IGV.getInstance().getTrackManager().load(file, this.panel);
                    }
                    catch (DataLoadException de) {
                        messages.append(de.getMessage());
                    }
                }
                String obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                if (IGVHttpUtils.isURL(obj)) {
                    IGV.getInstance().loadTracks(Arrays.asList(new ResourceLocator(obj)));
                }
                if (messages != null && !messages.isEmpty()) {
                    MessageUtils.showAndLogErrorMessage(IGV.getMainFrame(), messages.getFormattedMessage(), log);
                }
            }
            catch (Exception e2) {
                String obj = null;
                try {
                    obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                    if (IGVHttpUtils.isURL(obj)) {
                        IGV.getInstance().loadTracks(Arrays.asList(new ResourceLocator(obj)));
                    }
                }
                catch (Exception e1) {
                    log.error(e1);
                }
            }
            IGV.getMainFrame().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

