/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.ClearRegionsMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;

public class ExportTrackNamesMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(ClearRegionsMenuAction.class);
    IGV mainFrame;

    public ExportTrackNamesMenuAction(String label, IGV mainFrame) {
        super(label, null);
        this.mainFrame = mainFrame;
        this.setToolTipText("Allows currently selected regions to be exported to a file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        ExportTrackNamesMenuAction exportTrackNamesMenuAction = this;
        FileDialog fd = new FileDialog(exportTrackNamesMenuAction.mainFrame.getMainFrame());
        fd.setModal(true);
        fd.setMode(1);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        File outputFile = new File(fd.getDirectory(), fname);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            for (Track t : this.mainFrame.getTrackManager().getAllTracks(false)) {
                pw.println(t.getName());
            }
        }
        catch (IOException ex) {
            MessageUtils.showMessage("IO Error: " + ex.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }
}

