/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.data.seg.FreqData;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class CNFreqTrack
extends AbstractTrack {
    FreqData data;
    BarChartRenderer renderer;

    public CNFreqTrack(ResourceLocator rl, String id, String name, FreqData fd) {
        super(rl, id, "CNV Summary");
        this.data = fd;
        float nSamples = this.data.getNumberOfSamples();
        this.setDataRange(new DataRange(-nSamples, 0.0f, nSamples));
        this.setColor(Color.red);
        this.setAltColor(Color.blue);
        this.renderer = new BarChartRenderer();
        this.setMinimumHeight(25);
        this.setHeight(50);
        this.setSortable(false);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.renderer.render(this.data.getDelCounts(context.getChr()), context, rect, (Track)this);
        this.renderer.render(this.data.getAmpCounts(context.getChr()), context, rect, (Track)this);
        this.renderer.setMarginFraction(0.0);
        this.renderer.renderBorder(this, context, rect);
        context.getGraphic2DForColor(Color.black).drawRect(rect.x, rect.y, rect.width, rect.height - 1);
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        int startIdx;
        StringBuffer buf = new StringBuffer();
        List<LocusScore> ampScores = this.data.getAmpCounts(chr);
        List<LocusScore> delScores = this.data.getDelCounts(chr);
        for (int i2 = startIdx = Math.max(0, FeatureUtils.getIndexBefore(position, ampScores)); i2 < ampScores.size(); ++i2) {
            LocusScore ampScore = ampScores.get(i2);
            if (!(position >= (double)ampScore.getStart()) || !(position <= (double)ampScore.getEnd())) continue;
            buf.append("<br>Amplifications: ");
            buf.append(ampScore.getValueString(position, null));
            buf.append("<br>Deletions     : ");
            buf.append(delScores.get(i2).getValueString(position, null));
        }
        return buf.toString();
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return -2.1474836E9f;
    }
}

