/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;

public class SpliceJunctionRenderer
extends IGVFeatureRenderer {
    private static Logger log = Logger.getLogger(SpliceJunctionRenderer.class);
    Color ARC_COLOR_NEG = new Color(50, 50, 150, 140);
    Color ARC_COLOR_POS = new Color(150, 50, 50, 140);
    Color COLOR_CENTERLINE = new Color(0, 0, 0, 100);
    protected int MAX_DEPTH = 50;

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        this.lastFeatureLineMaxY = 0.0;
        this.lastFeatureBoundsMaxY = 0.0;
        this.lastRegionMaxY = 0.0;
        if (featureList != null && !featureList.isEmpty()) {
            Font font = FontManager.getFont(track.getFontSize());
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(Color.BLACK).create();
            fontGraphics.setFont(font);
            double trackRectangleX = trackRectangle.getX();
            double trackRectangleMaxX = trackRectangle.getMaxX();
            for (IGVFeature feature : featureList) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                int flankingStart = junctionFeature.getStart();
                int flankingEnd = junctionFeature.getEnd();
                int junctionStart = junctionFeature.getJunctionStart();
                int junctionEnd = junctionFeature.getJunctionEnd();
                double virtualPixelStart = Math.round(((double)flankingStart - origin) / locScale);
                double virtualPixelEnd = Math.round(((double)flankingEnd - origin) / locScale);
                double virtualPixelJunctionStart = Math.round(((double)junctionStart - origin) / locScale);
                double virtualPixelJunctionEnd = Math.round(((double)junctionEnd - origin) / locScale);
                if (!(virtualPixelEnd >= trackRectangleX) || !(virtualPixelStart <= trackRectangleMaxX)) continue;
                int displayPixelEnd = (int)Math.min(trackRectangleMaxX, virtualPixelEnd);
                int displayPixelStart = (int)Math.max(trackRectangleX, virtualPixelStart);
                float depth = junctionFeature.getJunctionDepth();
                this.drawFeature((int)virtualPixelStart, (int)virtualPixelEnd, (int)virtualPixelJunctionStart, (int)virtualPixelJunctionEnd, depth, trackRectangle, context, feature.getStrand(), junctionFeature);
                int pixelYCenter = trackRectangle.y + 7;
                if (this.getHighlightFeature() != feature) continue;
                int yStart = pixelYCenter - 7 - 1;
                Graphics2D highlightGraphics = context.getGraphic2DForColor(Color.cyan);
                highlightGraphics.drawRect(displayPixelStart - 1, yStart, displayPixelEnd - displayPixelStart + 2, 16);
            }
            Graphics2D g2D = context.getGraphic2DForColor(this.COLOR_CENTERLINE);
            g2D.drawLine((int)trackRectangleX, (int)trackRectangle.getCenterY(), (int)trackRectangleMaxX, (int)trackRectangle.getCenterY());
        }
    }

    protected void drawFlankingRegion(Graphics g2D, int pixelStart, int pixelLength, int[] regionDepthArray, int maxPossibleArcHeight, Rectangle trackRectangle, boolean isPositiveStrand) {
        for (int i2 = 0; i2 < pixelLength; ++i2) {
            float arrayIndicesPerPixel = (float)regionDepthArray.length / (float)pixelLength;
            int flankingRegionArrayPixelMinIndex = (int)((float)i2 * arrayIndicesPerPixel);
            int flankingRegionArrayPixelMaxIndex = (int)((float)(i2 + 1) * arrayIndicesPerPixel);
            flankingRegionArrayPixelMinIndex = Math.max(0, Math.min(flankingRegionArrayPixelMinIndex, regionDepthArray.length - 1));
            flankingRegionArrayPixelMaxIndex = Math.max(0, Math.min(flankingRegionArrayPixelMaxIndex, regionDepthArray.length - 1));
            int meanDepthThisPixel = 0;
            for (int j2 = flankingRegionArrayPixelMinIndex; j2 <= flankingRegionArrayPixelMaxIndex; ++j2) {
                meanDepthThisPixel += regionDepthArray[j2];
            }
            meanDepthThisPixel /= flankingRegionArrayPixelMaxIndex - flankingRegionArrayPixelMinIndex + 1;
            meanDepthThisPixel = Math.min(this.MAX_DEPTH, meanDepthThisPixel);
            int pixelHeight = Math.max(maxPossibleArcHeight * meanDepthThisPixel / this.MAX_DEPTH, 2);
            g2D.fillRect(pixelStart + i2, (int)trackRectangle.getCenterY() + (isPositiveStrand ? -pixelHeight : 0), 1, pixelHeight);
        }
    }

    protected void drawFeature(int pixelFeatureStart, int pixelFeatureEnd, int pixelJunctionStart, int pixelJunctionEnd, float depth, Rectangle trackRectangle, RenderContext context, Strand strand, SpliceJunctionFeature junctionFeature) {
        boolean isPositiveStrand = true;
        if (strand != null && strand.equals((Object)Strand.NEGATIVE)) {
            isPositiveStrand = false;
        }
        Color color = isPositiveStrand ? this.ARC_COLOR_POS : this.ARC_COLOR_NEG;
        Graphics2D g2D = context.getGraphic2DForColor(color);
        int maxPossibleArcHeight = (trackRectangle.height - 1) / 2;
        if (junctionFeature.hasFlankingRegionDepthArrays()) {
            int startFlankingRegionPixelLength = pixelJunctionStart - pixelFeatureStart;
            int endFlankingRegionPixelLength = pixelFeatureEnd - pixelJunctionEnd;
            this.drawFlankingRegion(g2D, pixelFeatureStart, startFlankingRegionPixelLength, junctionFeature.getStartFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
            this.drawFlankingRegion(g2D, pixelJunctionEnd + 1, endFlankingRegionPixelLength, junctionFeature.getEndFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
        } else {
            int overlapRectHeight = 3;
            int overlapRectTopX = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -2 : 0);
            if (pixelFeatureStart < pixelJunctionStart) {
                g2D.fillRect(pixelFeatureStart, overlapRectTopX, pixelJunctionStart - pixelFeatureStart, overlapRectHeight);
            }
            if (pixelJunctionEnd < pixelFeatureEnd) {
                g2D.fillRect(pixelJunctionEnd, overlapRectTopX, pixelFeatureEnd - pixelJunctionEnd, overlapRectHeight);
            }
        }
        double minArcHeightProportion = 0.33;
        int innerArcHeight = (int)((double)maxPossibleArcHeight * minArcHeightProportion);
        float depthProportionOfMax = Math.min(1.0f, depth / (float)this.MAX_DEPTH);
        int arcWidth = Math.max(1, (int)((1.0 - minArcHeightProportion) * (double)maxPossibleArcHeight * (double)depthProportionOfMax));
        int outerArcHeight = innerArcHeight + arcWidth;
        int arcBeginY = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -1 : 1);
        int outerArcPeakY = isPositiveStrand ? arcBeginY - outerArcHeight : arcBeginY + outerArcHeight;
        int innerArcPeakY = isPositiveStrand ? arcBeginY - innerArcHeight : arcBeginY + innerArcHeight;
        int outerBezierY = arcBeginY + (int)(1.5 * (double)(outerArcPeakY - arcBeginY));
        int innerBezierY = arcBeginY + (int)(1.5 * (double)(innerArcPeakY - arcBeginY));
        int bezierXPad = Math.max(1, (pixelJunctionEnd - pixelJunctionStart) / 30);
        GeneralPath arcPath = new GeneralPath();
        arcPath.moveTo(pixelJunctionStart, arcBeginY);
        arcPath.curveTo(pixelJunctionStart - bezierXPad, outerBezierY, pixelJunctionEnd + bezierXPad, outerBezierY, pixelJunctionEnd, arcBeginY);
        arcPath.curveTo(pixelJunctionEnd + bezierXPad, innerBezierY, pixelJunctionStart - bezierXPad, innerBezierY, pixelJunctionStart, arcBeginY);
        g2D.draw(arcPath);
        g2D.fill(arcPath);
        this.lastFeatureLineMaxY = Math.max(outerArcPeakY, arcBeginY);
    }
}

