/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.data.seg.Segment;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.util.ColorUtilities;

public class HeatmapRenderer
extends DataRenderer {
    static Map<Integer, Color> lowConfColorCache = new Hashtable<Integer, Color>();

    public String getDisplayName() {
        return "Heatmap";
    }

    @Override
    public void renderScores(Track track, List<LocusScore> scores, RenderContext context, Rectangle rect) {
        ContinuousColorScale colorScale = track.getColorScale();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color bgColor = colorScale.getNoDataColor();
        context.getGraphic2DForColor(bgColor).fill(rect);
        double maxX = rect.getMaxX();
        int minY = (int)rect.getMinY();
        int height = (int)rect.getHeight();
        int lastPEnd = 0;
        int lastPStart = 0;
        int lastW = 0;
        Color lastColor = null;
        float[] buffer1 = new float[3];
        float[] buffer2 = new float[3];
        for (LocusScore score : scores) {
            if ((double)lastPStart > maxX) break;
            float fStart = (float)(((double)score.getStart() - origin) / locScale);
            float fEnd = (float)(((double)score.getEnd() - origin) / locScale);
            float fw = fEnd - fStart;
            int pStart = (int)fStart;
            int pEnd = (int)fEnd;
            int w = Math.max(1, pEnd - pStart);
            float dataY = track.logScaleData(score.getScore());
            Color graphColor = colorScale.getColor(dataY);
            if (fw < 1.0f) {
                float alpha = Math.max(0.25f, fw);
                graphColor = lastColor == null || pStart > lastPEnd ? ColorUtilities.getCompositeColor(graphColor.getColorComponents(buffer1), alpha) : ColorUtilities.getCompositeColor(lastColor.getColorComponents(buffer1), graphColor.getColorComponents(buffer2), alpha);
            }
            if (pStart + w >= 0 && (double)lastPStart <= maxX) {
                if (pStart < lastPEnd && w > 1 && lastW == 1) {
                    ++pStart;
                    --w;
                }
                if (!Float.isNaN(dataY)) {
                    RNAIGeneScore rnaiScore;
                    if (score instanceof RNAIGeneScore && (rnaiScore = (RNAIGeneScore)score).getConfidence() < 2.0f) {
                        graphColor = HeatmapRenderer.getLowConfColor(context.getZoom());
                    }
                    Graphics2D g2D = context.getGraphic2DForColor(graphColor);
                    if ((double)pStart < maxX) {
                        int pLeft = Math.max(rect.x, pStart);
                        int pRight = Math.min(rect.x + rect.width, pStart + w);
                        int adjustedW = pRight - pLeft;
                        g2D.fillRect(pLeft, minY, adjustedW, height);
                    }
                    if (score instanceof Segment && PreferenceManager.getInstance().getAsBoolean("IGV.join.adjacent.segments") && lastColor != null && pStart - lastPEnd > 1) {
                        int midPoint = (pStart + lastPEnd) / 2;
                        context.getGraphic2DForColor(lastColor).fillRect(lastPEnd, minY, midPoint - lastPEnd, height);
                        g2D.fillRect(midPoint, minY, pStart - midPoint, height);
                        if (!context.getChr().equals("All") && pStart - lastPEnd > 4 && height > 2) {
                            Color c2 = new Color(0.4f, 0.4f, 0.4f, 0.5f);
                            Graphics2D gLine = context.getGraphic2DForColor(c2);
                            int midpoint = minY + height / 2;
                            if (height > 4) {
                                gLine.drawLine(lastPEnd, minY + 3, lastPEnd, minY + height - 3);
                                gLine.drawLine(pStart, minY + 3, pStart, minY + height - 3);
                            }
                            gLine.drawLine(lastPEnd, minY + height / 2, pStart - 1, minY + height / 2);
                        }
                    }
                }
            }
            lastPStart = pStart;
            lastPEnd = pStart + w;
            lastW = w;
            lastColor = graphColor;
        }
    }

    private static Color getLowConfColor(int zoom) {
        Color lowConfColor = lowConfColorCache.get(zoom);
        if (lowConfColor == null) {
            int value = 225 - Math.min(70, zoom * 10);
            lowConfColor = new Color(value, value, value);
            lowConfColorCache.put(zoom, lowConfColor);
        }
        return lowConfColor;
    }
}

