/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf.conservation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.maf.conservation.OmegaFileParser;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.LRUCache;

public class OmegaDataSource
extends AbstractDataSource
implements DataSource {
    File rootDir = new File("/Volumes/igv/annotations/hg18/conservation/omega/12mer");
    LRUCache<String, DataTile> tileCache = new LRUCache(this, 3);

    public OmegaDataSource(Genome genome) {
        super(genome);
    }

    @Override
    public double getDataMax() {
        return 1.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public int getLongestFeature(String chr) {
        return 1;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.OTHER;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    public String getFileNameForPosition(String chr, int pos) {
        int mb = pos / 1000000 * 1000000;
        int end = mb + 999999;
        return chr + "_" + mb + "-" + end + ".omega";
    }

    @Override
    protected int getNumZoomLevels(String chr) {
        return 0;
    }

    @Override
    public DataTile getRawData(String chr, int startLocation, int endLocation) {
        startLocation = 55240000;
        endLocation = 55242525;
        int bStart = startLocation / 1000000;
        int bEnd = endLocation / 1000000;
        String key = chr + bStart + "_" + bEnd;
        if (this.tileCache.containsKey(key)) {
            return this.tileCache.get(key);
        }
        File chrDir = new File(this.rootDir, chr.substring(3));
        ArrayList<File> files = new ArrayList<File>(bEnd - bStart + 1);
        for (int i2 = bStart; i2 <= bEnd; ++i2) {
            int start = i2 * 1000000;
            int end = start + 999999;
            File f2 = new File(chrDir, chr + "_" + start + "-" + end + ".omega");
            if (!f2.exists()) continue;
            files.add(f2);
        }
        if (files.isEmpty()) {
            return null;
        }
        int sz = endLocation - startLocation;
        int[] starts = new int[sz];
        float[] data = new float[sz];
        OmegaFileParser parser = new OmegaFileParser();
        int offset = 0;
        for (File f3 : files) {
            parser.getDataAsArrays(f3, starts, data, offset, startLocation, endLocation);
            offset += 1000000;
        }
        DataTile dt = new DataTile(starts, null, data, null);
        this.tileCache.put(key, dt);
        return dt;
    }
}

