/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.h5.DataAccessException;
import org.broad.igv.h5.HDF5Reader;
import org.broad.igv.h5.ObjectNotFoundException;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;

public class HDF5RemoteReader
implements HDF5Reader {
    static Map<String, List<Integer>> allFileIds = new HashMap<String, List<Integer>>();
    public static final int OBJECT_NOT_FOUND_CODE = -1;
    static Logger log = Logger.getLogger(HDF5RemoteReader.class);
    ResourceLocator locator;
    public int fileId;
    private Map<String, Integer> entityCache = new HashMap<String, Integer>(1000);

    public static void shutdown() {
        String fileIdString = new String();
        for (String server : allFileIds.keySet()) {
            for (Integer fileId : allFileIds.get(server)) {
                fileIdString = fileIdString + fileId.toString() + ",";
            }
            try {
                URL url = new URL(server + "?method=closeFiles&fileId=" + fileIdString);
                HttpURLConnection connection = IGVHttpUtils.openConnection(url);
                connection.getInputStream().read();
            }
            catch (IOException ex) {
                log.error("Error closing files on server: " + server);
            }
        }
    }

    private synchronized void recordFile(String server, Integer fileId) {
        List<Integer> fileIds = allFileIds.get(server);
        if (fileIds == null) {
            fileIds = new ArrayList<Integer>();
            allFileIds.put(server, fileIds);
        }
        fileIds.add(fileId);
    }

    public HDF5RemoteReader(ResourceLocator locator) {
        InputStream urlStream = null;
        try {
            this.locator = locator;
            URL url = new URL(locator.getServerURL() + "?method=openFile&file=" + locator.getPath());
            urlStream = IGVHttpUtils.openConnectionStream(url);
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            this.fileId = is.readInt();
            this.recordFile(locator.getServerURL(), this.fileId);
        }
        catch (IOException ex) {
            log.error("Error opening file", ex);
            String exceptionMessage = ex.getMessage();
            String message = ex.toString();
            if (exceptionMessage != null) {
                message = exceptionMessage.contains("response code: 403") ? "Access forbidden" : (exceptionMessage.contains("response code: 404") ? "Resource not found" : exceptionMessage);
            }
            log.error("Error loading remote h5 file", ex);
            throw new DataAccessException(message);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public void closeFile() {
        String method = "closeFile";
        this.closeEntity("closeFile", this.fileId);
    }

    @Override
    public int openDataset(String name) {
        String method = "openDataset";
        return this.openEntity("openDataset", this.fileId, name);
    }

    @Override
    public void closeDataset(int datasetId) {
        String closeEntity = "closeDataset";
        this.closeEntity("closeDataset", datasetId);
    }

    @Override
    public int openGroup(String groupPath) {
        String method = "openGroup";
        return this.openEntity("openGroup", this.fileId, groupPath);
    }

    @Override
    public void closeGroup(int groupId) {
        String method = "closeGroup";
        this.closeEntity("closeGroup", groupId);
    }

    @Override
    public int readIntegerAttribute(int groupId, String attrName) throws ObjectNotFoundException {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readIntegerAttribute&id=" + groupId + "&name=" + attrName);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            int value = is.readInt();
            is.close();
            if (value == -1) {
                throw new ObjectNotFoundException("Attribute: " + attrName + " not found");
            }
            int n2 = value;
            return n2;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public String readStringAttribute(int groupId, String attrName) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readStringAttribute&id=" + groupId + "&name=" + attrName);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            urlStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
            String value = reader.readLine().replace('\u02c7', ' ').trim();
            reader.close();
            String string = value.length() == 0 ? null : value;
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public double readDoubleAttribute(int groupId, String attrName) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readDoubleAttribute&id=" + groupId + "&name=" + attrName);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            double value = is.readDouble();
            is.close();
            double d2 = value;
            return d2;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public float[] readAllFloats(int datasetId) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readAllFloats&id=" + datasetId);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            int byteLength = connection.getContentLength();
            int nFloats = byteLength / 4;
            float[] data = new float[nFloats];
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            for (int i2 = 0; i2 < nFloats; ++i2) {
                data[i2] = is.readFloat();
            }
            is.close();
            float[] fArray = data;
            return fArray;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public int[] readAllInts(int datasetId) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readAllInts&id=" + datasetId);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            int byteLength = connection.getContentLength();
            int nInts = byteLength / 4;
            int[] data = new int[nInts];
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            for (int i2 = 0; i2 < nInts; ++i2) {
                data[i2] = is.readInt();
            }
            is.close();
            int[] nArray = data;
            return nArray;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public List<String> readAllStrings(int datasetId) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readAllStrings&id=" + datasetId);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            ArrayList<String> strings = new ArrayList<String>(100);
            urlStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                String nextString = nextLine.trim();
                if (nextString.length() <= 0) continue;
                strings.add(nextString);
            }
            reader.close();
            ArrayList<String> arrayList = strings;
            return arrayList;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public float[] readFloats(int datasetId, int fromIndex, int toIndex) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readFloats&id=" + datasetId + "&from=" + fromIndex + "&to=" + toIndex);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            int byteLength = connection.getContentLength();
            int nFloats = byteLength / 4;
            float[] data = new float[nFloats];
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            for (int i2 = 0; i2 < nFloats; ++i2) {
                data[i2] = is.readFloat();
            }
            is.close();
            float[] fArray = data;
            return fArray;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public int[] readInts(int datasetId, int fromIndex, int toIndex) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readInts&id=" + datasetId + "&from=" + fromIndex + "&to=" + toIndex);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            int byteLength = connection.getContentLength();
            int nInts = byteLength / 4;
            int[] data = new int[nInts];
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            for (int i2 = 0; i2 < nInts; ++i2) {
                data[i2] = is.readInt();
            }
            is.close();
            int[] nArray = data;
            return nArray;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    @Override
    public float[][] readDataSlice(int datasetId, int fromIndex, int toIndex) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=readDataSlice&id=" + datasetId + "&from=" + fromIndex + "&to=" + toIndex);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            int nRows = is.readInt();
            int nColumns = is.readInt();
            float[][] dataSlice = new float[nRows][nColumns];
            for (int i2 = 0; i2 < nRows; ++i2) {
                for (int j2 = 0; j2 < nColumns; ++j2) {
                    dataSlice[i2][j2] = is.readFloat();
                }
            }
            is.close();
            float[][] fArray = dataSlice;
            return fArray;
        }
        catch (IOException ex) {
            log.error("Error in readAllFloats", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    private void closeEntity(String method, int datasetId) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=" + method + "&id=" + datasetId);
            urlStream = IGVHttpUtils.openConnectionStream(url);
        }
        catch (IOException ex) {
            log.error("Error closing entity", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }

    private int openEntity(String method, int parentNodeId, String name) {
        String key = method + "_" + name + "_" + parentNodeId;
        Integer entityId = this.entityCache.get(key);
        if (entityId == null) {
            entityId = this.openRemoteEntity(method, parentNodeId, name);
            this.entityCache.put(key, entityId);
        }
        return entityId;
    }

    private Integer openRemoteEntity(String method, int parentNodeId, String name) {
        InputStream urlStream = null;
        try {
            URL url = new URL(this.locator.getServerURL() + "?method=" + method + "&id=" + parentNodeId + "&name=" + name);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            connection.setDoOutput(true);
            urlStream = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(urlStream));
            int id = is.readInt();
            if (id < 0) {
                throw new ObjectNotFoundException("Entity not found: " + name);
            }
            Integer n2 = new Integer(id);
            return n2;
        }
        catch (IOException ex) {
            log.error("Error opening entity", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing url stream", iOException);
                }
            }
        }
    }
}

