/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.log4j.Logger;

public class GSUtils {
    static final Logger log = Logger.getLogger(GSUtils.class);
    public static final String AUTH_TOKEN_COOKIE_NAME = "gs-token";
    public static final String AUTH_TOKEN_COOKIE_DEFAULT_PATH = "/";
    private static String tokenSaveDir = ".gs";
    private static String tokenSaveFileName = ".gstoken";
    private static String usernameSaveFileName = ".gsusername";
    public static final String GENOME_SPACE_ID_SERVER = "identitytest.genomespace.org";
    public static final String identityServerUrl = "https://identitytest.genomespace.org:8443/identityServer/basic";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForCookie(DefaultHttpClient httpClient, URL serviceURL) {
        File file = GSUtils.getTokenFile();
        if (file.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String token = br.readLine();
                GSUtils.setAuthenticationToken(httpClient, serviceURL, token);
            }
            catch (IOException e2) {
                log.error("Error reading GS cookie", e2);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {}
                }
            }
        }
    }

    public static void setAuthenticationToken(DefaultHttpClient httpClient, URL serviceURL, String token) {
        BasicClientCookie cookie = new BasicClientCookie(AUTH_TOKEN_COOKIE_NAME, token);
        cookie.setDomain(GSUtils.getCookieDomainPattern(serviceURL.getHost()));
        cookie.setPath(AUTH_TOKEN_COOKIE_DEFAULT_PATH);
        GSCookieStore cookieStore = new GSCookieStore();
        cookieStore.addCookie(cookie);
        httpClient.setCookieStore(cookieStore);
    }

    private static String getCookieDomainPattern(String serverName) {
        int firstDotIdx = serverName.indexOf(".");
        if (firstDotIdx > 0 && firstDotIdx != serverName.lastIndexOf(".")) {
            return serverName.substring(serverName.indexOf("."));
        }
        return serverName;
    }

    private static File getTokenSaveDir() {
        String userDir = System.getProperty("user.home");
        File gsDir = new File(userDir, tokenSaveDir);
        if (!gsDir.exists()) {
            gsDir.mkdir();
        }
        return gsDir;
    }

    private static File getTokenFile() {
        File gsDir = GSUtils.getTokenSaveDir();
        File f2 = new File(gsDir, tokenSaveFileName);
        return f2;
    }

    private static File getUsernameFile() {
        File gsDir = GSUtils.getTokenSaveDir();
        File f2 = new File(gsDir, usernameSaveFileName);
        return f2;
    }

    public static void saveLoginForSSO(String newToken, String username) {
        File userFile;
        Object bw = null;
        File gsDir = GSUtils.getTokenSaveDir();
        if (!gsDir.isDirectory()) {
            log.error("Could not store token for SSO.  File " + gsDir.getAbsolutePath() + "exists and is not a directory.");
            return;
        }
        File tokenFile = GSUtils.getTokenFile();
        if (tokenFile.exists()) {
            tokenFile.delete();
        }
        if ((userFile = GSUtils.getUsernameFile()).exists()) {
            userFile.delete();
        }
        GSUtils.writeToFile(newToken, tokenFile);
        GSUtils.writeToFile(username, userFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String line, File aFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(aFile));
            bw.write(line);
            bw.close();
        }
        catch (Exception e2) {
            log.error("Failed to save the token for later Single Sign on", e2);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCachedUsernameForSSO() throws Exception {
        String user = null;
        BufferedReader br = null;
        try {
            File tokenFile = GSUtils.getUsernameFile();
            if (tokenFile.exists()) {
                br = new BufferedReader(new FileReader(tokenFile));
                user = br.readLine().trim();
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return user;
    }

    public static boolean isGenomeSpace(URL url) {
        return url.toString().contains("genomespace.org");
    }

    static class GSCookieStore
    implements CookieStore {
        List<Cookie> cookieList = new ArrayList<Cookie>();

        GSCookieStore() {
        }

        @Override
        public void addCookie(Cookie cookie) {
            this.cookieList.add(cookie);
        }

        @Override
        public List<Cookie> getCookies() {
            return this.cookieList;
        }

        @Override
        public boolean clearExpired(Date date) {
            boolean removed = false;
            ArrayList<Cookie> newCookieList = new ArrayList<Cookie>(this.cookieList.size());
            for (Cookie cookie : this.cookieList) {
                if (cookie.getExpiryDate().after(date)) {
                    newCookieList.add(cookie);
                    continue;
                }
                removed = true;
            }
            this.cookieList = newCookieList;
            return removed;
        }

        @Override
        public void clear() {
            this.cookieList.clear();
        }
    }
}

