/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.tribble.VCFFeature;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.readers.LineReader;

public class VCFCodec
implements FeatureCodec {
    String[] buffer = new String[8];
    List<String> headerStrings = new ArrayList<String>();

    @Override
    public Object readHeader(LineReader reader) {
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("##")) {
                    this.headerStrings.add(line);
                    continue;
                }
                if (!line.startsWith("#")) continue;
                this.headerStrings.add(line);
                break;
            }
            return this.headerStrings;
        }
        catch (IOException e2) {
            throw new RuntimeException("IO Exception ", e2);
        }
    }

    public Class getFeatureType() {
        return VCFFeature.class;
    }

    public Object getHeader() throws ClassCastException {
        return null;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public VCFFeature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        int nTokens = ParsingUtils.split(line, this.buffer, '\t');
        if (nTokens >= 8) {
            String chr = this.buffer[0];
            Integer start = Integer.parseInt(this.buffer[1]) - 1;
            float quality = Float.parseFloat(this.buffer[5]);
            return new VCFFeature(chr, start, this.buffer[2], this.buffer[3], this.buffer[4], quality, this.buffer[6], this.buffer[7]);
        }
        return null;
    }
}

