/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.tribble.BEDCodec;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.SAMCodec;
import org.broad.igv.peaks.PeakCodec;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.vcf.VCFCodec;

public class CodecFactory {
    public static FeatureCodec getCodec(String file) {
        String fn = file.toLowerCase();
        if (fn.endsWith(".gz")) {
            int l2 = fn.length() - 3;
            fn = fn.substring(0, l2);
        }
        if (fn.endsWith(".vcf") || fn.endsWith(".vcf4")) {
            return new VCFCodec();
        }
        if (fn.endsWith(".bed")) {
            return new BEDCodec();
        }
        if (fn.endsWith(".repmask")) {
            return new REPMaskCodec();
        }
        if (fn.endsWith(".gff3")) {
            return new GFFCodec(GFFCodec.Version.GFF3);
        }
        if (fn.endsWith(".gff")) {
            return new GFFCodec();
        }
        if (fn.endsWith(".sam")) {
            return new SAMCodec();
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec();
        }
        if (fn.endsWith(".peak")) {
            return new PeakCodec();
        }
        throw new DataLoadException("Unknown file type", file);
    }
}

