/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.DataTile2D;
import org.broad.igv.data.FeatureBin;
import org.broad.igv.data.FeatureBinCalculator;
import org.broad.igv.data.ProcessingUtils;
import org.broad.igv.data.SummaryScore;
import org.broad.igv.data.SummaryTile2D;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.h5.DataAccessException;
import org.broad.igv.h5.HDF5Reader;
import org.broad.igv.h5.HDF5ReaderFactory;
import org.broad.igv.h5.ObjectNotFoundException;
import org.broad.igv.session.RendererFactory;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class HDFDataManager {
    private static Logger log = Logger.getLogger(HDFDataManager.class);
    private static Integer rawIndex = -1;
    private ObjectCache<String, SummaryTile2D> summaryTileCache = new ObjectCache();
    private ObjectCache<String, int[]> intArrayCache = new ObjectCache();
    private Map<String, float[]> dataMaxCache = new HashMap<String, float[]>(25);
    private Map<String, float[]> dataMinCache = new HashMap<String, float[]>(25);
    private Map<String, Double> rawTileSizeCache = new HashMap<String, Double>();
    private Map<String, int[]> rawIndecesCache = new HashMap<String, int[]>();
    private Map<String, Integer> longestFeatureCache = new HashMap<String, Integer>();
    private Map<String, Integer> numZoomLevels = new HashMap<String, Integer>();
    private Map<String, Integer> chrLengths = new HashMap<String, Integer>();
    private Map<String, Double> binWidthCache = new HashMap<String, Double>();
    private LRUCache<String, ZoomParameters> zoomParameterCache = new LRUCache(this, 100);
    private ObjectCache<String, Object> locationsCache = new ObjectCache(100);
    private HDF5Reader dataReader;
    TrackType trackType = TrackType.OTHER;
    int windowSpan = 1;
    int locationUnit = 1;
    private boolean hasData = true;
    private boolean hasEnd = true;
    private String dataGroupPath;
    private String featureGroupPath;
    private String[] trackNames;
    private boolean normalized;
    private int version;
    private WindowFunction windowFunction;
    private TrackProperties trackProperties;
    private ResourceLocator locator;
    private Genome genome;
    ObjectCache<String, DataTile2D> rawDataCache = new ObjectCache(100);

    public HDFDataManager(ResourceLocator locator) throws DataAccessException {
        this(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFDataManager(ResourceLocator locator, Genome genome) throws DataAccessException {
        this.genome = genome;
        int rootGroup = -1;
        try {
            this.setGroupPaths();
            this.locator = locator;
            this.dataReader = HDF5ReaderFactory.getReader(locator);
            rootGroup = this.dataReader.openGroup("/");
            this.readRootAttributes(rootGroup);
            this.readTrackProperties(rootGroup);
            this.windowFunction = this.isCopyNumber() ? WindowFunction.median : WindowFunction.mean;
        }
        finally {
            if (rootGroup > 0) {
                this.dataReader.closeGroup(rootGroup);
            }
        }
    }

    public boolean isCopyNumber() {
        TrackType tt = this.getTrackType();
        return tt == TrackType.COPY_NUMBER || tt == TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
    }

    public ResourceLocator getResourceLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTrackNames() {
        if (this.trackNames == null) {
            int datasetId = -1;
            try {
                String dsName = "/data/track.id";
                datasetId = this.dataReader.openDataset(dsName);
                List<String> names = this.dataReader.readAllStrings(datasetId);
                this.trackNames = new String[names.size()];
                if (this.getTrackType() == TrackType.CHIP) {
                    String strip = ".aligned";
                    for (int i2 = 0; i2 < names.size(); ++i2) {
                        String nm = names.get(i2);
                        this.trackNames[i2] = nm.endsWith(strip) ? nm.substring(0, nm.length() - strip.length()) : nm;
                    }
                } else {
                    for (int i3 = 0; i3 < names.size(); ++i3) {
                        this.trackNames[i3] = names.get(i3);
                    }
                }
            }
            finally {
                if (datasetId > 0) {
                    this.dataReader.closeDataset(datasetId);
                }
            }
        }
        return this.trackNames;
    }

    int getNumZoomLevels(String chr) {
        Integer nz = this.numZoomLevels.get(chr);
        if (nz == null) {
            if (chr.equals("All")) {
                nz = 1;
            } else {
                int featureGroup = this.dataReader.openGroup(this.featureGroupPath + chr);
                nz = this.dataReader.readIntegerAttribute(featureGroup, "zoom.levels");
                this.dataReader.closeGroup(featureGroup);
            }
            this.numZoomLevels.put(chr, nz);
        }
        return nz;
    }

    public int getChrLength(String chr) {
        Integer len = this.chrLengths.get(chr);
        if (len == null) {
            if (chr.equals("All")) {
                len = 1;
            } else {
                int featureGroup = this.dataReader.openGroup(this.featureGroupPath + chr);
                len = this.dataReader.readIntegerAttribute(featureGroup, "length");
                this.dataReader.closeGroup(featureGroup);
            }
            this.chrLengths.put(chr, len);
        }
        return len;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float[][] readData(String dsName, int startIndex, int endIndex) {
        int datasetId = -1;
        try {
            float[][] dataArray;
            datasetId = this.dataReader.openDataset(dsName);
            float[][] fArray = dataArray = this.dataReader.readDataSlice(datasetId, startIndex, endIndex);
            return fArray;
        }
        finally {
            if (datasetId > 0) {
                this.dataReader.closeDataset(datasetId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataMax(int trackNumber, String chr) {
        if (this.trackProperties != null && !Float.isNaN(this.trackProperties.getMaxValue())) {
            return this.trackProperties.getMaxValue();
        }
        String rawMeansPath = this.dataGroupPath + chr + "/raw/mean";
        String rawStdPath = this.dataGroupPath + chr + "/raw/stddev";
        String key = rawMeansPath;
        float[] tmp = this.dataMaxCache.get(key);
        if (tmp == null) {
            int meanDatasetId = -1;
            int stdDatasetId = -1;
            try {
                meanDatasetId = this.dataReader.openDataset(rawMeansPath);
                float[] means = this.dataReader.readAllFloats(meanDatasetId);
                stdDatasetId = this.dataReader.openDataset(rawStdPath);
                float[] stds = this.dataReader.readAllFloats(stdDatasetId);
                if (means.length == 0 || stds.length == 0) {
                    double d2 = 10.0;
                    return d2;
                }
                tmp = new float[means.length];
                for (int i2 = 0; i2 < means.length; ++i2) {
                    tmp[i2] = means[i2] + 2.0f * stds[i2];
                }
            }
            catch (Exception objectNotFoundException) {
                double d3 = 10.0;
                return d3;
            }
            finally {
                if (meanDatasetId > 0) {
                    this.dataReader.closeDataset(meanDatasetId);
                }
                if (stdDatasetId > 0) {
                    this.dataReader.closeDataset(stdDatasetId);
                }
            }
        }
        return tmp[trackNumber];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataMin(int trackNumber, String chr) {
        if (this.trackProperties != null && !Float.isNaN(this.trackProperties.getMinValue())) {
            return this.trackProperties.getMinValue();
        }
        String dataset = this.dataGroupPath + chr + "/raw/min";
        String key = dataset;
        float[] tmp = this.dataMinCache.get(key);
        if (tmp == null) {
            int datasetId = -1;
            try {
                datasetId = this.dataReader.openDataset(dataset);
                tmp = this.dataReader.readAllFloats(datasetId);
                this.dataMinCache.put(key, tmp);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                double d2 = 0.0;
                return d2;
            }
            finally {
                if (datasetId > 0) {
                    this.dataReader.closeDataset(datasetId);
                }
            }
        }
        if (tmp.length == 0) {
            return 0.0;
        }
        double min = tmp[trackNumber];
        if (min < 30000.0) {
            min = 0.0;
        }
        return min;
    }

    protected double getAttributeForGroup(String groupName, String attribute) {
        int group = this.dataReader.openGroup(groupName);
        double att = this.dataReader.readDoubleAttribute(group, attribute);
        this.dataReader.closeGroup(group);
        return att;
    }

    protected void setGroupPaths() {
        this.dataGroupPath = "/data/";
        this.featureGroupPath = "/features/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoomParameters getZoomParameters(int zoom, String chr) {
        String zoomGroupPath = this.featureGroupPath + chr + (zoom == rawIndex ? "/raw" : "/z" + zoom);
        String key = zoomGroupPath;
        ZoomParameters params = this.zoomParameterCache.get(key);
        if (params == null) {
            int zoomGroup = this.dataReader.openGroup(zoomGroupPath);
            double tileWidth = this.dataReader.readDoubleAttribute(zoomGroup, "tile.width");
            String h5Name = zoomGroupPath + "/tile.boundary";
            int datasetId = this.dataReader.openDataset(h5Name);
            int[] tileBoundaries = this.dataReader.readAllInts(datasetId);
            this.dataReader.closeDataset(datasetId);
            params = new ZoomParameters();
            params.zoom = zoom;
            params.tileWidth = tileWidth;
            ZoomParameters.access$202(params, tileBoundaries);
            if (zoom != rawIndex) {
                double maxCount = this.dataReader.readDoubleAttribute(zoomGroup, "max.count");
                double meanCount = this.dataReader.readDoubleAttribute(zoomGroup, "mean.count");
                double medianCount = this.dataReader.readDoubleAttribute(zoomGroup, "median.count");
                params.maxCount = maxCount;
                params.medianCount = medianCount;
                params.meanCount = meanCount;
                LRUCache<String, ZoomParameters> lRUCache = this.zoomParameterCache;
                synchronized (lRUCache) {
                    this.zoomParameterCache.put(key, params);
                }
            }
            this.dataReader.closeGroup(zoomGroup);
        }
        return params;
    }

    private double estimateMeanCount(int zoom, String chr) {
        int nz = this.getNumZoomLevels(chr);
        if (zoom < nz) {
            return this.getZoomParameters(zoom, chr).meanCount;
        }
        ZoomParameters zp = this.getZoomParameters(nz - 1, chr);
        if (zp != null) {
            double factor = Math.pow(2.0, zoom - nz + 1);
            return Math.max(1.0, zp.meanCount / factor);
        }
        return 1.0;
    }

    protected List<SummaryTile2D> getPrecomputedSummaryTiles(String chr, int startLocation, int endLocation, int zoom, WindowFunction windowFunction) {
        ZoomParameters zParams = this.getZoomParameters(zoom, chr);
        int startTile = (int)((double)startLocation / zParams.tileWidth);
        int endTile = (int)Math.min((double)(zParams.tileBoundaries.length - 1), (double)endLocation / zParams.tileWidth);
        int nTiles = endTile - startTile + 1;
        if (nTiles <= 0) {
            log.debug("Negative tile count.  ntiles = " + nTiles + " startLoction = " + startLocation + " endLocation = " + endLocation + " startTile = " + startTile + " endTile = " + endTile);
            return new ArrayList<SummaryTile2D>();
        }
        ArrayList<SummaryTile2D> tiles = new ArrayList<SummaryTile2D>(nTiles);
        for (int t = 0; t < nTiles; ++t) {
            int tileNumber = startTile + t;
            int tileStart = (int)((double)tileNumber * zParams.tileWidth);
            SummaryTile2D summaryTile = this.getSummaryTile(chr, tileNumber, tileStart, zoom);
            if (summaryTile == null) continue;
            tiles.add(summaryTile);
        }
        return tiles;
    }

    protected SummaryTile2D getSummaryTile(String chr, int tileNumber, int startLocation, int zoom) {
        String key = "" + chr + "_" + zoom + "_" + tileNumber + "_" + (Object)((Object)this.windowFunction);
        SummaryTile2D summaryTile = this.summaryTileCache.get(key);
        if (summaryTile == null) {
            SummaryDataTile tile = this.loadSummaryDataTile(chr, tileNumber, zoom);
            if (tile.isEmpty()) {
                return null;
            }
            double meanCount = this.estimateMeanCount(zoom, chr);
            summaryTile = new SummaryTile2D(tileNumber, startLocation);
            for (int i2 = 0; i2 < tile.getSize(); ++i2) {
                for (int j2 = 0; j2 < tile.getNTracks(); ++j2) {
                    float value = tile.getValue(j2, i2);
                    if (Float.isNaN(value)) continue;
                    summaryTile.addScore(j2, new SummaryScore(tile.getStart(i2) * this.locationUnit, (int)(tile.getEnd(i2) * (float)this.locationUnit), value));
                }
            }
            this.summaryTileCache.put(key, summaryTile);
        }
        return summaryTile;
    }

    private SummaryDataTile loadSummaryDataTile(String chr, int tileNumber, int zoom) {
        ZoomParameters zParams = this.getZoomParameters(zoom, chr);
        int startIndex = tileNumber == 0 ? 0 : zParams.tileBoundaries[tileNumber - 1];
        int endIndex = zParams.tileBoundaries[tileNumber];
        double binWidth = 1.0;
        try {
            String key = this.featureGroupPath + chr + "/z" + zoom;
            Double tmp = this.binWidthCache.get(key);
            if (tmp == null) {
                int featureGroup = this.dataReader.openGroup(key);
                tmp = new Double(this.dataReader.readDoubleAttribute(featureGroup, "bin.size"));
                this.binWidthCache.put(key, tmp);
                this.dataReader.closeGroup(featureGroup);
            }
            binWidth = tmp.floatValue();
        }
        catch (ObjectNotFoundException e2) {
            // empty catch block
        }
        SummaryDataTile tile = new SummaryDataTile(tileNumber, binWidth);
        if (startIndex == endIndex) {
            return tile;
        }
        if (startIndex > endIndex) {
            System.err.println("Start index > end index!");
            return tile;
        }
        try {
            String dsName;
            String cacheKey;
            int[] startLocations;
            float[][] data = null;
            if (this.windowFunction == null || this.windowFunction == WindowFunction.count) {
                String dsName2 = this.featureGroupPath + chr + "/z" + zoom + "/" + "count";
                int datasetId = this.dataReader.openDataset(dsName2);
                float[] counts = this.dataReader.readFloats(datasetId, startIndex, endIndex);
                this.dataReader.closeDataset(datasetId);
                tile.setCounts(counts);
            }
            if (this.windowFunction != null && this.windowFunction != WindowFunction.count) {
                String dsName3 = this.dataGroupPath + chr + "/z" + zoom + "/" + (Object)((Object)this.windowFunction);
                try {
                    data = this.readData(dsName3, startIndex, endIndex);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((startLocations = (int[])this.locationsCache.get(cacheKey = (dsName = this.featureGroupPath + chr + "/z" + zoom + "/" + "start") + "_" + tileNumber)) == null) {
                int ds = this.dataReader.openDataset(dsName);
                startLocations = this.dataReader.readInts(ds, startIndex, endIndex);
                this.dataReader.closeDataset(ds);
                this.locationsCache.put(cacheKey, startLocations);
            }
            tile.setLocations(startLocations);
            tile.setValues(data);
        }
        catch (Exception ex) {
            log.error("Warning: problem loading data tile: z= " + zoom + " start= " + startIndex + " end= " + endIndex, ex);
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SummaryTile2D> getSummaryTilesForRange(String chr, int startLocation, int endLocation, int zoom) {
        int startTile = 0;
        int endTile = 0;
        if (zoom < this.getNumZoomLevels(chr)) {
            return this.getPrecomputedSummaryTiles(chr, startLocation, endLocation, zoom, this.windowFunction);
        }
        int chrLength = this.getChrLength(chr);
        endLocation = Math.min(endLocation, chrLength);
        int longestFeature = this.getLongestFeature(chr);
        int adjustedStart = Math.max(0, startLocation - longestFeature);
        int adjustedEnd = Math.min(chrLength, endLocation);
        int tmp = Math.max(15, this.getNumZoomLevels(chr) + 1);
        int z = Math.min(tmp, zoom);
        int nTiles = (int)Math.pow(2.0, z);
        double tileWidth = (double)chrLength / (double)nTiles;
        startTile = (int)((double)adjustedStart / tileWidth);
        endTile = (int)((double)Math.min(chrLength, adjustedEnd) / tileWidth);
        ArrayList<SummaryTile2D> tiles = new ArrayList<SummaryTile2D>(nTiles);
        for (int tileNumber = startTile; tileNumber <= endTile; ++tileNumber) {
            int tileStart = (int)((double)tileNumber * tileWidth);
            int tileEnd = Math.min(chrLength, (int)((double)(tileNumber + 1) * tileWidth));
            String key = chr + "_" + zoom + "_" + tileNumber + "_" + (Object)((Object)this.windowFunction);
            SummaryTile2D tile = this.summaryTileCache.get(key);
            if (tile == null && (tile = this.computeSummaryTile(chr, tileNumber, tileStart, tileEnd)) != null) {
                ObjectCache<String, SummaryTile2D> objectCache = this.summaryTileCache;
                synchronized (objectCache) {
                    this.summaryTileCache.put(key, tile);
                }
            }
            tiles.add(tile);
        }
        return tiles;
    }

    private synchronized int getLongestFeature(String chr) {
        if (!this.longestFeatureCache.containsKey(chr)) {
            int longestFeature;
            int maxLongestFeature;
            block4: {
                maxLongestFeature = 1000;
                if (this.genome != null) {
                    String genomeId = this.genome.getId();
                    maxLongestFeature = 5000;
                }
                longestFeature = 1000;
                String groupName = this.featureGroupPath + chr + "/raw";
                int groupId = this.dataReader.openGroup(groupName);
                try {
                    longestFeature = this.dataReader.readIntegerAttribute(groupId, "longest.feature");
                }
                catch (Exception e2) {
                    if (this.getTrackType() == TrackType.GENE_EXPRESSION || this.hasEnd) break block4;
                    longestFeature = this.windowSpan;
                }
            }
            longestFeature = Math.min(longestFeature, maxLongestFeature);
            this.longestFeatureCache.put(chr, longestFeature);
        }
        return this.longestFeatureCache.get(chr);
    }

    private SummaryTile2D computeSummaryTile(String chr, int tileNumber, int startLocation, int endLocation) {
        double binWidth = FrameManager.getDefaultFrame().getScale();
        List<DataTile2D> tiles = this.getRawData(chr, startLocation, endLocation);
        ArrayList smallFeatures = new ArrayList();
        SummaryTile2D tile = new SummaryTile2D(tileNumber, startLocation);
        for (DataTile2D dataTile2D : tiles) {
            if (dataTile2D == null || dataTile2D.isEmpty()) continue;
            int[] starts = dataTile2D.getStartLocations();
            int[] ends = dataTile2D.getEndLocations();
            float[][] values = dataTile2D.getValues();
            ArrayList scoresToSegregate = new ArrayList();
            ArrayList scoresToBin = new ArrayList();
            for (int i2 = 0; i2 < values.length; ++i2) {
                scoresToSegregate.add(new ArrayList(1000));
                scoresToBin.add(new ArrayList(1000));
            }
            for (int i2 = 0; i2 < starts.length; ++i2) {
                int start = starts[i2];
                int end = ends == null ? start + 1 : Math.max(start + 1, ends[i2]);
                for (int trackNumber = 0; trackNumber < values.length; ++trackNumber) {
                    float val = values[trackNumber][i2];
                    if (Float.isNaN(val)) continue;
                    SummaryScore ss = new SummaryScore(start, end, val);
                    double pixelWidth = (double)(end - start) / binWidth;
                    if (pixelWidth < 1.0) {
                        ((List)scoresToBin.get(trackNumber)).add(ss);
                        continue;
                    }
                    ((List)scoresToSegregate.get(trackNumber)).add(ss);
                }
            }
            for (int trackNumber = 0; trackNumber < scoresToSegregate.size(); ++trackNumber) {
                List locusScores = (List)scoresToSegregate.get(trackNumber);
                for (LocusScore score : locusScores) {
                    tile.addScore(trackNumber, score);
                }
                List<FeatureBin> bins = HDFDataManager.computeBins(startLocation, endLocation, (List)scoresToBin.get(trackNumber));
                for (FeatureBin fBin : bins) {
                    float[] tmp;
                    int binStart = fBin.getStart();
                    int binEnd = (int)((double)binStart + binWidth);
                    int counts = fBin.getFeatureCount();
                    float binValue = 0.0f;
                    binValue = this.windowFunction == null || this.windowFunction == WindowFunction.count ? (float)counts : ((tmp = fBin.getFeatureScores()) == null ? Float.NaN : ProcessingUtils.computeStat(tmp, this.windowFunction));
                    if (Float.isNaN(binValue)) continue;
                    tile.addScore(trackNumber, new SummaryScore(binStart, binEnd, binValue));
                }
            }
        }
        if (tile != null) {
            for (List list : tile.getSummaryScores().values()) {
                if (list == null) continue;
                FeatureUtils.sortFeatureList(list);
            }
        }
        return tile;
    }

    private static List<FeatureBin> computeBins(int startLocation, int endLocation, List<LocusScore> features) {
        double binSize = FrameManager.getDefaultFrame().getScale();
        int nBins = (int)Math.ceil((double)(endLocation - startLocation) / binSize);
        double correctedBinSize = (double)(endLocation - startLocation) / (double)nBins;
        return new FeatureBinCalculator().computeFeatureBins(features, nBins, correctedBinSize, startLocation, endLocation);
    }

    private List<LocusScore> aggregateScores(int trackNumber, List<SummaryTile2D> tiles) {
        ArrayList<LocusScore> joinedScores = new ArrayList<LocusScore>(tiles.size() * 700);
        LocusScore previousScore = null;
        for (SummaryTile2D tile : tiles) {
            for (LocusScore score : tile.getScores(trackNumber)) {
                if (Float.isNaN(score.getScore())) continue;
                if (previousScore == null) {
                    previousScore = new SummaryScore(score);
                    joinedScores.add(previousScore);
                    continue;
                }
                if (score.getScore() == previousScore.getScore()) {
                    previousScore.setEnd(score.getEnd());
                    continue;
                }
                SummaryScore newScore = new SummaryScore(score);
                int delta = newScore.getStart() - previousScore.getEnd();
                previousScore.setEnd(previousScore.getEnd() + delta / 2);
                newScore.setStart(previousScore.getEnd());
                joinedScores.add(newScore);
                previousScore = newScore;
            }
        }
        return joinedScores;
    }

    public List<IGVFeature> getFeaturesForRange(String chr, int startLocation, int endLocation) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataTile2D> getRawData(String chr, int startLocation, int endLocation) {
        String key;
        DataTile2D tile;
        int endIndex;
        ArrayList<DataTile2D> tiles = new ArrayList<DataTile2D>();
        if (!this.rawTileSizeCache.containsKey(chr)) {
            String groupName = this.featureGroupPath + chr + "/raw";
            int groupId = this.dataReader.openGroup(groupName);
            Map<String, Double> map = this.rawTileSizeCache;
            synchronized (map) {
                this.rawTileSizeCache.put(chr, this.dataReader.readDoubleAttribute(groupId, "index.span"));
            }
        }
        double rawTileSize = this.rawTileSizeCache.get(chr);
        if (!this.rawIndecesCache.containsKey(chr)) {
            String dsName = this.featureGroupPath + chr + "/raw/index";
            Map<String, int[]> map = this.rawIndecesCache;
            synchronized (map) {
                this.rawIndecesCache.put(chr, this.readAllInts(dsName));
            }
        }
        int[] rawIndeces = this.rawIndecesCache.get(chr);
        int startTile = Math.max(0, (int)((double)startLocation / rawTileSize) - 1);
        if (startTile >= rawIndeces.length) {
            ArrayList<DataTile2D> tmp = new ArrayList<DataTile2D>();
            tmp.add(DataTile2D.getNullDataTile());
            return tmp;
        }
        int startIndex = rawIndeces[startTile];
        int endTile = (int)((double)endLocation / rawTileSize) + 1;
        int n2 = endIndex = endTile >= rawIndeces.length ? rawIndeces[rawIndeces.length - 1] : rawIndeces[endTile];
        if (endIndex <= startIndex) {
            tiles.add(DataTile2D.getNullDataTile());
            return tiles;
        }
        String keyPrefix = "raw_" + chr + "_";
        while (startTile < endTile && (tile = this.rawDataCache.get(key = keyPrefix + startTile)) != null) {
            tiles.add(tile);
            ++startTile;
        }
        if (startTile == endTile) {
            return tiles;
        }
        startIndex = rawIndeces[startTile];
        if (endIndex <= startIndex) {
            for (int t = startTile; t < endTile; ++t) {
                tiles.add(DataTile2D.getNullDataTile());
            }
        } else {
            String dsName = this.featureGroupPath + chr + "/raw/start";
            int[] starts = this.readInts(dsName, startIndex, endIndex);
            int[] ends = null;
            if (this.hasEnd) {
                try {
                    dsName = this.featureGroupPath + chr + "/raw/end";
                    ends = this.readInts(dsName, startIndex, endIndex);
                }
                catch (Exception ex) {
                    this.hasEnd = false;
                }
            }
            if (ends == null) {
                ends = new int[starts.length];
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    ends[i2] = starts[i2] + this.windowSpan;
                }
            }
            float[][] data = null;
            if (this.hasData) {
                dsName = this.dataGroupPath + chr + "/raw/value";
                try {
                    data = this.readData(dsName, startIndex, endIndex);
                }
                catch (ObjectNotFoundException ex) {
                    log.info("No data object found for: " + dsName);
                    this.hasData = false;
                    ArrayList<DataTile2D> tmp = new ArrayList<DataTile2D>();
                    tmp.add(DataTile2D.getNullDataTile());
                    return tmp;
                }
            }
            List<DataTile2D> newTiles = this.createDataTiles(startTile, endTile, rawIndeces, starts, ends, data);
            tiles.addAll(newTiles);
            int tileNumber = startTile;
            for (DataTile2D tile2 : newTiles) {
                String key2 = keyPrefix + tileNumber;
                ObjectCache<String, DataTile2D> objectCache = this.rawDataCache;
                synchronized (objectCache) {
                    this.rawDataCache.put(key2, tile2);
                }
                ++tileNumber;
            }
        }
        return tiles;
    }

    public List<DataTile2D> createDataTiles(int startTile, int endTile, int[] indeces, int[] startLocations, int[] endLocations, float[][] data) {
        ArrayList<DataTile2D> tiles = new ArrayList<DataTile2D>();
        if (indeces.length <= startTile) {
            return tiles;
        }
        int nTracks = data.length;
        int i0 = indeces[startTile];
        for (int tile = startTile; tile < endTile; ++tile) {
            int endIdx;
            int startIdx = tile >= indeces.length ? startLocations.length - 1 : indeces[tile];
            int n2 = endIdx = tile + 1 >= indeces.length ? startLocations.length - 1 : indeces[tile + 1];
            if (endIdx <= startIdx) {
                tiles.add(DataTile2D.getNullDataTile());
                continue;
            }
            int nPts = endIdx - startIdx;
            int[] s = new int[nPts];
            int[] e2 = new int[nPts];
            float[][] d2 = new float[nTracks][nPts];
            int idx = startIdx - i0;
            System.arraycopy(startLocations, idx, s, 0, nPts);
            System.arraycopy(endLocations, idx, e2, 0, nPts);
            for (int t = 0; t < nTracks; ++t) {
                System.arraycopy(data[t], idx, d2[t], 0, nPts);
            }
            tiles.add(new DataTile2D(s, e2, d2));
        }
        return tiles;
    }

    int[] readInts(String dsName, int startIndex, int endIndex) {
        String key = dsName + "_" + startIndex + "_" + endIndex;
        int[] dataArray = this.intArrayCache.get(key);
        if (dataArray == null) {
            int datasetId = this.dataReader.openDataset(dsName);
            dataArray = this.dataReader.readInts(datasetId, startIndex, endIndex);
            this.dataReader.closeDataset(datasetId);
            this.intArrayCache.put(key, dataArray);
        }
        return dataArray;
    }

    int[] readAllInts(String dsName) {
        String key = dsName + "_ALL";
        int[] dataArray = this.intArrayCache.get(key);
        if (dataArray == null) {
            int datasetId = this.dataReader.openDataset(dsName);
            dataArray = this.dataReader.readAllInts(datasetId);
            this.dataReader.closeDataset(datasetId);
            this.intArrayCache.put(key, dataArray);
        }
        return dataArray;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    private void readRootAttributes(int rootGroup) throws DataAccessException {
        try {
            this.version = this.dataReader.readIntegerAttribute(rootGroup, "version");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new DataAccessException("Unsupported HDF5 version number: 0");
        }
        if (this.version < 2) {
            throw new DataAccessException("Unsupported HDF5 version number: " + this.version);
        }
        try {
            this.normalized = this.dataReader.readIntegerAttribute(rootGroup, "normalized") > 0;
        }
        catch (Exception e2) {
            this.normalized = false;
        }
        try {
            this.trackType = TrackType.valueOf(this.dataReader.readStringAttribute(rootGroup, "type").toUpperCase());
        }
        catch (Exception e3) {
            this.trackType = TrackType.OTHER;
        }
        try {
            this.windowSpan = this.dataReader.readIntegerAttribute(rootGroup, "window.span");
        }
        catch (ObjectNotFoundException e4) {
            this.windowSpan = 1;
        }
        try {
            this.locationUnit = this.dataReader.readIntegerAttribute(rootGroup, "locationUnit");
        }
        catch (Exception e5) {
            this.locationUnit = 1;
        }
    }

    private void readTrackProperties(int group) {
        this.trackProperties = new TrackProperties();
        boolean foundProperties = false;
        String propertyString = null;
        try {
            propertyString = this.dataReader.readStringAttribute(group, "trackline");
        }
        catch (ObjectNotFoundException e2) {
            // empty catch block
        }
        if (propertyString != null && propertyString.trim().length() > 10) {
            foundProperties = ParsingUtils.parseTrackLine(propertyString, this.trackProperties);
        }
        if (!foundProperties) {
            try {
                String altColorString = this.dataReader.readStringAttribute(group, "track.altColor");
                this.getTrackProperties().setAltColor(ColorUtilities.stringToColor(altColorString));
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                String midColorString = this.dataReader.readStringAttribute(group, "track.midColor");
                this.getTrackProperties().setMidColor(ColorUtilities.stringToColor(midColorString));
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                String colorString = this.dataReader.readStringAttribute(group, "track.color");
                this.getTrackProperties().setColor(ColorUtilities.stringToColor(colorString));
            }
            catch (Exception e5) {
                // empty catch block
            }
            try {
                String description = this.dataReader.readStringAttribute(group, "track.description");
                this.getTrackProperties().setDescription(description);
            }
            catch (Exception e6) {
                // empty catch block
            }
            try {
                int height = this.dataReader.readIntegerAttribute(group, "track.height");
                this.getTrackProperties().setHeight(height);
            }
            catch (Exception e7) {
                // empty catch block
            }
            try {
                String autoscale = this.dataReader.readStringAttribute(group, "track.autoscale");
                this.getTrackProperties().setAutoScale(Boolean.valueOf(autoscale));
            }
            catch (Exception e8) {
                // empty catch block
            }
            try {
                float minValue = (float)this.dataReader.readDoubleAttribute(group, "track.minValue");
                this.getTrackProperties().setMinValue(minValue);
            }
            catch (Exception e9) {
                // empty catch block
            }
            try {
                float midValue = (float)this.dataReader.readDoubleAttribute(group, "track.midValue");
                this.getTrackProperties().setMidValue(midValue);
            }
            catch (Exception e10) {
                // empty catch block
            }
            try {
                float maxValue = (float)this.dataReader.readDoubleAttribute(group, "track.maxValue");
                this.getTrackProperties().setMaxValue(maxValue);
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                String drawMidValue = this.dataReader.readStringAttribute(group, "track.drawMidValue");
                this.getTrackProperties().setDrawYLine(Boolean.valueOf(drawMidValue));
            }
            catch (Exception e12) {
                // empty catch block
            }
            try {
                String name = this.dataReader.readStringAttribute(group, "track.name");
                this.getTrackProperties().setName(name);
            }
            catch (Exception e13) {
                // empty catch block
            }
            try {
                String rendererClass = this.dataReader.readStringAttribute(group, "track.renderer");
                this.getTrackProperties().setRendererClass(RendererFactory.getRendererClass(rendererClass));
            }
            catch (Exception e14) {
                // empty catch block
            }
            try {
                String windowFunction = this.dataReader.readStringAttribute(group, "track.windowFunction");
                this.getTrackProperties().setWindowingFunction(WindowFunction.valueOf(windowFunction));
            }
            catch (Exception e15) {
                // empty catch block
            }
        }
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    public void setWindowFunction(WindowFunction windowFunction) {
        this.windowFunction = windowFunction;
    }

    class ZoomParameters {
        private int zoom;
        private int[] tileBoundaries;
        private double tileWidth;
        private double maxCount;
        private double meanCount;
        private double medianCount;

        ZoomParameters() {
        }

        static /* synthetic */ int[] access$202(ZoomParameters x0, int[] x1) {
            x0.tileBoundaries = x1;
            return x1;
        }
    }

    class SummaryDataTile {
        private int tileNumber;
        private int binWidth = 1;
        int[] locations;
        private float[] counts;
        float[][] values;

        public SummaryDataTile(int tileNumber, double binWidth) {
            this.tileNumber = tileNumber;
            this.binWidth = (int)Math.round(binWidth);
        }

        public int getNTracks() {
            return this.values == null ? 0 : this.values.length;
        }

        public void setLocations(int[] locations) {
            this.locations = locations;
        }

        public void setValues(float[][] scores) {
            this.values = scores;
        }

        public int getSize() {
            assert (this.values.length == this.locations.length);
            return this.locations.length;
        }

        public boolean isEmpty() {
            return this.locations == null || this.locations.length == 0;
        }

        public int getStart(int index) {
            return this.locations[index];
        }

        public float getEnd(int index) {
            return this.locations[index] + this.binWidth;
        }

        public float getValue(int trackNumber, int index) {
            return this.values == null ? Float.NaN : this.values[trackNumber][index];
        }

        public float getCount(int index) {
            return this.counts[index];
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public float[] getCounts() {
            return this.counts;
        }

        public void setCounts(float[] counts) {
            this.counts = counts;
        }
    }
}

