/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.CompositeScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.NamedScore;
import org.broad.igv.data.SummaryTile;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.collections.FloatArrayList;

public abstract class AbstractDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(AbstractDataSource.class);
    boolean cacheSummaryTiles = true;
    WindowFunction windowFunction = WindowFunction.mean;
    LRUCache<String, SummaryTile> summaryTileCache = new LRUCache(this, 20);
    Genome genome;
    static List<WindowFunction> wfs = new ArrayList<WindowFunction>();

    public AbstractDataSource(Genome genome) {
        this.genome = genome;
    }

    protected abstract int getNumZoomLevels(String var1);

    protected abstract DataTile getRawData(String var1, int var2, int var3);

    protected List<SummaryTile> getPrecomputedSummaryTiles(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    public int getChrLength(String chr) {
        if (chr.equals("All")) {
            return (int)(this.genome.getLength() / 1000L);
        }
        Chromosome c2 = this.genome.getChromosome(chr);
        return c2 == null ? 0 : c2.getLength();
    }

    @Override
    public void refreshData(long timestamp) {
    }

    public abstract int getLongestFeature(String var1);

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<SummaryTile> tiles = this.getSummaryTilesForRange(chr, startLocation, endLocation, zoom);
        ArrayList<LocusScore> summaryScores = new ArrayList<LocusScore>(tiles.size() * 700);
        for (SummaryTile tile : tiles) {
            summaryScores.addAll(tile.getScores());
        }
        return summaryScores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SummaryTile> getSummaryTilesForRange(String chr, int startLocation, int endLocation, int zReq) {
        if (zReq < this.getNumZoomLevels(chr)) {
            return this.getPrecomputedSummaryTiles(chr, startLocation, endLocation, zReq);
        }
        int chrLength = this.getChrLength(chr);
        if (chrLength == 0) {
            return Collections.emptyList();
        }
        endLocation = Math.min(endLocation, chrLength);
        int z = zReq;
        int nTiles = (int)Math.pow(2.0, z);
        int adjustedStart = Math.max(0, startLocation);
        int adjustedEnd = Math.min(chrLength, endLocation);
        if (this.cacheSummaryTiles && !FrameManager.isGeneListMode()) {
            double tileWidth = (double)chrLength / (double)nTiles;
            int startTile = (int)((double)adjustedStart / tileWidth);
            int endTile = (int)((double)Math.min(chrLength, adjustedEnd) / tileWidth) + 1;
            ArrayList<SummaryTile> tiles = new ArrayList<SummaryTile>(nTiles);
            for (int t = startTile; t <= endTile; ++t) {
                int tileStart = (int)((double)t * tileWidth);
                int tileEnd = Math.min(chrLength, (int)((double)(t + 1) * tileWidth));
                String key = chr + "_" + z + "_" + t + (Object)((Object)this.getWindowFunction());
                SummaryTile summaryTile = this.summaryTileCache.get(key);
                if (summaryTile == null) {
                    summaryTile = this.computeSummaryTile(chr, t, tileStart, tileEnd, 700);
                    if (this.cacheSummaryTiles && !FrameManager.isGeneListMode()) {
                        LRUCache<String, SummaryTile> lRUCache = this.summaryTileCache;
                        synchronized (lRUCache) {
                            this.summaryTileCache.put(key, summaryTile);
                        }
                    }
                }
                if (summaryTile == null) continue;
                tiles.add(summaryTile);
            }
            return tiles;
        }
        SummaryTile summaryTile = this.computeSummaryTile(chr, 0, startLocation, endLocation, 700);
        return Arrays.asList(summaryTile);
    }

    SummaryTile computeSummaryTile(String chr, int tileNumber, int startLocation, int endLocation, int nBins) {
        int longestGene = this.getLongestFeature(chr);
        int adjustedStart = Math.max(startLocation - longestGene, 0);
        DataTile rawTile = this.getRawData(chr, adjustedStart, endLocation);
        SummaryTile tile = null;
        if (rawTile != null && !rawTile.isEmpty() && nBins > 0) {
            int[] starts = rawTile.getStartLocations();
            int[] ends = rawTile.getEndLocations();
            float[] values = rawTile.getValues();
            String[] features = rawTile.getFeatureNames();
            tile = new SummaryTile(tileNumber, startLocation);
            if (this.windowFunction == WindowFunction.none) {
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    int e2;
                    int s = starts[i2];
                    int n2 = e2 = ends == null ? s + 1 : Math.max(s + 1, ends[i2]);
                    if (e2 < startLocation) continue;
                    if (s <= endLocation) {
                        String probeName = features == null ? null : features[i2];
                        float v = values[i2];
                        NamedScore score = new NamedScore(s, e2, v, probeName);
                        tile.addScore(score);
                        continue;
                    }
                    break;
                }
            } else {
                float normalizationFactor = 1.0f;
                ArrayList<NamedScore> scores = new ArrayList<NamedScore>(nBins);
                double scale = (double)(endLocation - startLocation) / (double)nBins;
                Accumulator accumulator = new Accumulator(this.windowFunction, 5);
                int accumulatedStart = -1;
                int accumulatedEnd = -1;
                int lastEndBin = 0;
                int size = starts.length;
                for (int i3 = 0; i3 < size; ++i3) {
                    int s = Math.max(startLocation, starts[i3]);
                    int e3 = ends == null ? s + 1 : Math.min(endLocation, ends[i3]);
                    String probeName = features == null ? null : features[i3];
                    float v = values[i3] * normalizationFactor;
                    if (e3 < startLocation || Float.isNaN(v)) continue;
                    if (s > endLocation) break;
                    int endBin = (int)((double)(e3 - startLocation) / scale);
                    if (endBin == lastEndBin) {
                        accumulator.add(v, probeName);
                        if (accumulatedStart < 0) {
                            accumulatedStart = s;
                        }
                        accumulatedEnd = e3;
                    } else {
                        int startBin;
                        if (accumulator.hasData()) {
                            LocusScore ls;
                            if (accumulator.getNpts() == 1) {
                                ls = new NamedScore(accumulatedStart, accumulatedEnd, accumulator.getData()[0], accumulator.getNames()[0]);
                            } else {
                                float value = accumulator.getValue();
                                ls = new CompositeScore(accumulatedStart, accumulatedEnd, value, accumulator.getData(), accumulator.getNames(), this.windowFunction);
                            }
                            scores.add((NamedScore)ls);
                            accumulator = new Accumulator(this.windowFunction, 5);
                        }
                        if (endBin - (startBin = Math.max(0, (int)((double)(s - startLocation) / scale))) > 1) {
                            scores.add(new NamedScore(s, e3, v, probeName));
                        } else {
                            accumulator.add(v, probeName);
                            accumulatedStart = s;
                            accumulatedEnd = e3;
                        }
                    }
                    lastEndBin = endBin;
                }
                if (accumulator.hasData()) {
                    LocusScore ls;
                    if (accumulator.getNpts() == 1) {
                        ls = new NamedScore(accumulatedStart, accumulatedEnd, accumulator.getData()[0], accumulator.getNames()[0]);
                    } else {
                        float value = accumulator.getValue();
                        ls = new CompositeScore(accumulatedStart, accumulatedEnd, value, accumulator.getData(), accumulator.getNames(), this.windowFunction);
                    }
                    scores.add((NamedScore)ls);
                }
                tile.addAllScores(scores);
            }
        }
        return tile;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.windowFunction = statType;
        this.summaryTileCache.clear();
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return wfs;
    }

    static {
        wfs.add(WindowFunction.min);
        wfs.add(WindowFunction.percentile10);
        wfs.add(WindowFunction.median);
        wfs.add(WindowFunction.mean);
        wfs.add(WindowFunction.percentile90);
        wfs.add(WindowFunction.max);
    }

    static class PendingScore {
        int start;
        int end;
        FloatArrayList scores = new FloatArrayList();

        PendingScore(int start, int end, FloatArrayList scores, float newVal) {
            this.end = end;
            this.scores.addAll(scores);
            this.scores.add(newVal);
            this.start = start;
        }

        PendingScore(int start, int end, FloatArrayList scores) {
            this.end = end;
            this.scores.addAll(scores);
            this.start = start;
        }

        PendingScore(int start, int end, float newVal) {
            this.end = end;
            this.scores.add(newVal);
            this.start = start;
        }
    }
}

