/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.samtools.util.SeekableStream;

public class SeekableFileStream
extends SeekableStream {
    File file;
    RandomAccessFile fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "r");
    }

    public long length() {
        return this.file.length();
    }

    public boolean eof() throws IOException {
        return this.fis.length() == this.fis.getFilePointer();
    }

    public void seek(long position) throws IOException {
        this.fis.seek(position);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n2 = 0; n2 < length; n2 += count) {
            count = this.fis.read(buffer, offset + n2, length - n2);
            if (count >= 0) continue;
            return n2;
        }
        return n2;
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int read() throws IOException {
        return this.fis.read();
    }

    public String getSource() {
        return this.file.getAbsolutePath();
    }
}

