/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class Util {
    private static final NumberFormat FORMAT_DOUBLE = new DecimalFormat("#,##0.00");
    private static final NumberFormat FORMAT_LONG = new DecimalFormat("#,###");
    private static final Runtime RUNTIME = Runtime.getRuntime();

    private Util() {
    }

    public static String format(double d2) {
        StringBuffer s = new StringBuffer();
        return FORMAT_DOUBLE.format(d2, s, new FieldPosition(0)).toString();
    }

    public static String format(long l2) {
        StringBuffer s = new StringBuffer();
        return FORMAT_LONG.format(l2, s, new FieldPosition(0)).toString();
    }

    public static String formatSize(long l2) {
        if (l2 >= 1000000000000L) {
            return Util.format((double)l2 / 1.0E12) + "T";
        }
        if (l2 >= 1000000000L) {
            return Util.format((double)l2 / 1.0E9) + "G";
        }
        if (l2 >= 1000000L) {
            return Util.format((double)l2 / 1000000.0) + "M";
        }
        if (l2 >= 1000L) {
            return Util.format((double)l2 / 1000.0) + "K";
        }
        return Long.toString(l2);
    }

    public static String formatBinarySize(long l2) {
        if ((l2 & -l2) != l2) {
            throw new IllegalArgumentException("Not a power of 2: " + l2);
        }
        if (l2 >= 0x10000000000L) {
            return Util.format(l2 >> 40) + "Ti";
        }
        if (l2 >= 0x40000000L) {
            return Util.format(l2 >> 30) + "Gi";
        }
        if (l2 >= 0x100000L) {
            return Util.format(l2 >> 20) + "Mi";
        }
        if (l2 >= 1024L) {
            return Util.format(l2 >> 10) + "Ki";
        }
        return Long.toString(l2);
    }

    public static boolean log4JIsConfigured() {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public static void ensureLog4JIsConfigured(Class<?> klass) {
        Util.ensureLog4JIsConfigured(klass, Level.INFO);
    }

    public static void ensureLog4JIsConfigured(Class<?> klass, Level level) {
        if (!Util.log4JIsConfigured()) {
            System.err.println("WARNING: " + (klass != null ? klass.getSimpleName() + " is" : "We are") + " autoconfiguring Log4J (level: " + level + "). You should configure Log4J properly instead.");
            BasicConfigurator.configure();
            LogManager.getRootLogger().setLevel(level);
        }
    }

    public static void ensureLog4JIsConfigured() {
        Util.ensureLog4JIsConfigured(null, Level.INFO);
    }

    public static void ensureLog4JIsConfigured(Level level) {
        Util.ensureLog4JIsConfigured(null, level);
    }

    public static Logger getLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass);
        return logger;
    }

    public static Logger getDebugLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass, Level.DEBUG);
        return logger;
    }

    public static boolean memoryIsLow() {
        return Util.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Util.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i2 = unused.length;
            while (i2-- != 0) {
                unused[i2] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }

    public static long randomSeed() {
        long seed = System.nanoTime();
        seed ^= seed >>> 33;
        seed *= -49064778989728563L;
        seed ^= seed >>> 33;
        seed *= -4265267296055464877L;
        seed ^= seed >>> 33;
        return seed;
    }

    public static byte[] randomSeedBytes() {
        long seed = Util.randomSeed();
        byte[] s = new byte[8];
        int i2 = 8;
        while (i2-- != 0) {
            s[i2] = (byte)(seed >>> i2);
        }
        return s;
    }

    public static int[] invertPermutationInPlace(int[] perm) {
        int n2 = perm.length;
        block0: while (n2-- != 0) {
            int i2 = perm[n2];
            if (i2 < 0) {
                perm[n2] = -i2 - 1;
                continue;
            }
            if (i2 == n2) continue;
            int k2 = n2;
            while (true) {
                int j2 = perm[i2];
                perm[i2] = -k2 - 1;
                if (j2 == n2) {
                    perm[n2] = i2;
                    continue block0;
                }
                k2 = i2;
                i2 = j2;
            }
        }
        return perm;
    }

    public static int[] invertPermutation(int[] perm, int[] inv) {
        int i2 = perm.length;
        while (i2-- != 0) {
            inv[perm[i2]] = i2;
        }
        return inv;
    }

    public static int[] invertPermutation(int[] perm) {
        return Util.invertPermutation(perm, new int[perm.length]);
    }

    public static int[] identity(int[] perm) {
        int i2 = perm.length;
        while (i2-- != 0) {
            perm[i2] = i2;
        }
        return perm;
    }

    public static int[] identity(int n2) {
        return Util.identity(new int[n2]);
    }
}

