/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.counts;

import edu.cornell.med.icb.goby.counts.CountsReader;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bdval.io.compound.CompoundDataInput;
import org.bdval.io.compound.CompoundDirectoryEntry;
import org.bdval.io.compound.CompoundFileReader;

public class CountsArchiveReader
implements Closeable {
    private final CompoundFileReader compoundReader;
    private final Int2ObjectMap<String> indexToIdentifierMap;
    private Object2IntMap<String> identifierToIndexMap;
    private long totalBasesSeen;
    private long totalSitesSeen;
    private static final Logger LOG = Logger.getLogger(CountsArchiveReader.class);

    public long getTotalBasesSeen() {
        return this.totalBasesSeen;
    }

    public long getTotalSitesSeen() {
        return this.totalSitesSeen;
    }

    public boolean isStatsParsed() {
        return this.totalBasesSeen != 0L && this.totalSitesSeen != 0L;
    }

    public CountsArchiveReader(String basename) throws IOException {
        this(basename, "counts");
    }

    public CountsArchiveReader(String basename, String alternativeCountArchiveExtension) throws IOException {
        this.compoundReader = new CompoundFileReader(basename + "." + alternativeCountArchiveExtension);
        this.indexToIdentifierMap = new Int2ObjectOpenHashMap<String>();
        this.identifierToIndexMap = new Object2IntOpenHashMap<String>();
        this.scanDirectory();
    }

    public CountsReader getCountReader(String identifier) throws IOException {
        CompoundDataInput input = this.compoundReader.readFile(this.makeFileIdentifier(identifier));
        byte[] bytes = new byte[(int)input.length()];
        input.readFully(bytes);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        return new CountsReader(stream);
    }

    public CountsReader getCountReader(int countInfoIndex) throws IOException {
        return this.getCountReader(this.makeFileIdentifier(countInfoIndex));
    }

    private String makeFileIdentifier(int countInfoIndex) {
        return countInfoIndex + "," + (String)this.indexToIdentifierMap.get(countInfoIndex);
    }

    public String getIdentifier(int index) {
        return (String)this.indexToIdentifierMap.get(index);
    }

    private String makeFileIdentifier(String countId) {
        return countId.indexOf(44) == -1 ? this.identifierToIndexMap.get(countId) + "," + countId : countId;
    }

    public int getNumberOfIndices() {
        return this.identifierToIndexMap.size();
    }

    public ObjectSet<String> getIdentifiers() {
        ObjectOpenHashSet<String> result = new ObjectOpenHashSet<String>();
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (name.startsWith("#")) continue;
            String[] tokens = name.split(",");
            if (tokens.length < 2) {
                return null;
            }
            result.add(tokens[1]);
        }
        return result;
    }

    private void scanDirectory() {
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (!name.startsWith("#")) {
                String[] tokens = name.split(",");
                assert (tokens.length == 2) : "archive count filenames must be of the form int,String";
                int index = Integer.parseInt(tokens[0]);
                String id = tokens[1];
                this.indexToIdentifierMap.put(index, id);
                this.identifierToIndexMap.put(id, index);
                continue;
            }
            this.parseSpecialFile(entry);
        }
    }

    private void parseSpecialFile(CompoundDirectoryEntry entry) {
        if ("#stats".equals(entry.getName())) {
            try {
                CompoundDataInput input = this.compoundReader.readFile("#stats");
                boolean done = false;
                while (!done) {
                    String key = input.readUTF();
                    if ("totalBasesSeen".equals(key)) {
                        this.totalBasesSeen = input.readLong();
                    } else if ("totalSitesSeen".equals(key)) {
                        this.totalSitesSeen = input.readLong();
                    }
                    if (!"END".equals(key)) continue;
                    done = true;
                }
            }
            catch (IOException e2) {
                LOG.error("could not access special file #stats in counts archive");
            }
        }
    }

    public IntSet getIndices() {
        IntArraySet result = new IntArraySet();
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (name.startsWith("#")) continue;
            String[] tokens = name.split(",");
            if (tokens.length < 1) {
                return null;
            }
            result.add(Integer.parseInt(tokens[0]));
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.compoundReader.close();
    }
}

