/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.counts;

import edu.cornell.med.icb.goby.counts.CountBinningAdapterI;
import edu.cornell.med.icb.goby.counts.CountsReaderI;
import java.io.IOException;
import java.util.NoSuchElementException;

public class CountBinningAdaptor
implements CountBinningAdapterI {
    final CountsReaderI delegate;
    private final int binSize;
    int position = -1;
    int length;
    double average;
    int max;
    long sumBasesOverBin;
    private boolean binLoaded;
    private int nextCount;
    private int nextLength;
    private int nextPosition;
    private boolean haveCachedNextTransition;

    public CountBinningAdaptor(CountsReaderI delegate, int binSize) {
        this.delegate = delegate;
        this.binSize = binSize;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        if (this.binLoaded) {
            return true;
        }
        if (!this.delegate.hasNextTransition()) {
            return false;
        }
        this.length = 0;
        this.sumBasesOverBin = 0L;
        int numSitesObserved = 0;
        this.max = 0;
        this.position = Integer.MAX_VALUE;
        while (this.delegate.hasNextTransition() && numSitesObserved < this.binSize) {
            this.delegate.nextTransition();
            int delegateLength = this.delegate.getLength();
            int newLength = Math.max(delegateLength, this.delegate.getPosition() - this.position + delegateLength);
            int count = this.delegate.getCount();
            this.length = newLength;
            if (count != 0) {
                numSitesObserved += delegateLength;
            }
            this.sumBasesOverBin += (long)count * (long)delegateLength;
            this.max = Math.max(count, this.max);
            if (count == 0) continue;
            this.position = Math.min(this.delegate.getPosition(), this.position);
        }
        this.average = (double)this.sumBasesOverBin / (double)numSitesObserved;
        this.binLoaded = true;
        return true;
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new NoSuchElementException("No such element.");
        }
        this.binLoaded = false;
    }

    @Override
    public int getCount() {
        return (int)this.average;
    }

    @Override
    public double getAverage() {
        return this.average;
    }

    @Override
    public void skipTo(int position) throws IOException {
        while (this.hasNextTransition() && this.getPosition() < position) {
            this.nextTransition();
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

