/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix matrix) {
        int n2;
        double d2;
        int n3;
        int n4;
        double[][] dArray = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        int n5 = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][n5];
        this.V = new double[this.n][this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.m];
        boolean bl = true;
        boolean bl2 = true;
        int n6 = Math.min(this.m - 1, this.n);
        int n7 = Math.max(0, Math.min(this.n - 2, this.m));
        for (n4 = 0; n4 < Math.max(n6, n7); ++n4) {
            int n8;
            if (n4 < n6) {
                this.s[n4] = 0.0;
                for (n3 = n4; n3 < this.m; ++n3) {
                    this.s[n4] = Maths.hypot(this.s[n4], dArray[n3][n4]);
                }
                if (this.s[n4] != 0.0) {
                    if (dArray[n4][n4] < 0.0) {
                        this.s[n4] = -this.s[n4];
                    }
                    for (n3 = n4; n3 < this.m; ++n3) {
                        double[] dArray4 = dArray[n3];
                        int n9 = n4;
                        dArray4[n9] = dArray4[n9] / this.s[n4];
                    }
                    double[] dArray5 = dArray[n4];
                    int n10 = n4;
                    dArray5[n10] = dArray5[n10] + 1.0;
                }
                this.s[n4] = -this.s[n4];
            }
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                if (n4 < n6 & this.s[n4] != 0.0) {
                    double d3 = 0.0;
                    for (n8 = n4; n8 < this.m; ++n8) {
                        d3 += dArray[n8][n4] * dArray[n8][n3];
                    }
                    d3 = -d3 / dArray[n4][n4];
                    for (n8 = n4; n8 < this.m; ++n8) {
                        double[] dArray6 = dArray[n8];
                        int n11 = n3;
                        dArray6[n11] = dArray6[n11] + d3 * dArray[n8][n4];
                    }
                }
                dArray2[n3] = dArray[n4][n3];
            }
            if (bl & n4 < n6) {
                for (n3 = n4; n3 < this.m; ++n3) {
                    this.U[n3][n4] = dArray[n3][n4];
                }
            }
            if (n4 >= n7) continue;
            dArray2[n4] = 0.0;
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                dArray2[n4] = Maths.hypot(dArray2[n4], dArray2[n3]);
            }
            if (dArray2[n4] != 0.0) {
                if (dArray2[n4 + 1] < 0.0) {
                    dArray2[n4] = -dArray2[n4];
                }
                n3 = n4 + 1;
                while (n3 < this.n) {
                    int n12 = n3++;
                    dArray2[n12] = dArray2[n12] / dArray2[n4];
                }
                int n13 = n4 + 1;
                dArray2[n13] = dArray2[n13] + 1.0;
            }
            dArray2[n4] = -dArray2[n4];
            if (n4 + 1 < this.m & dArray2[n4] != 0.0) {
                for (n3 = n4 + 1; n3 < this.m; ++n3) {
                    dArray3[n3] = 0.0;
                }
                for (n3 = n4 + 1; n3 < this.n; ++n3) {
                    for (int i2 = n4 + 1; i2 < this.m; ++i2) {
                        int n14 = i2;
                        dArray3[n14] = dArray3[n14] + dArray2[n3] * dArray[i2][n3];
                    }
                }
                for (n3 = n4 + 1; n3 < this.n; ++n3) {
                    double d4 = -dArray2[n3] / dArray2[n4 + 1];
                    for (n8 = n4 + 1; n8 < this.m; ++n8) {
                        double[] dArray7 = dArray[n8];
                        int n15 = n3;
                        dArray7[n15] = dArray7[n15] + d4 * dArray3[n8];
                    }
                }
            }
            if (!bl2) continue;
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                this.V[n3][n4] = dArray2[n3];
            }
        }
        n4 = Math.min(this.n, this.m + 1);
        if (n6 < this.n) {
            this.s[n6] = dArray[n6][n6];
        }
        if (this.m < n4) {
            this.s[n4 - 1] = 0.0;
        }
        if (n7 + 1 < n4) {
            dArray2[n7] = dArray[n7][n4 - 1];
        }
        dArray2[n4 - 1] = 0.0;
        if (bl) {
            for (n3 = n6; n3 < n5; ++n3) {
                for (int i3 = 0; i3 < this.m; ++i3) {
                    this.U[i3][n3] = 0.0;
                }
                this.U[n3][n3] = 1.0;
            }
            for (n3 = n6 - 1; n3 >= 0; --n3) {
                int n16;
                if (this.s[n3] != 0.0) {
                    for (n16 = n3 + 1; n16 < n5; ++n16) {
                        d2 = 0.0;
                        for (n2 = n3; n2 < this.m; ++n2) {
                            d2 += this.U[n2][n3] * this.U[n2][n16];
                        }
                        d2 = -d2 / this.U[n3][n3];
                        for (n2 = n3; n2 < this.m; ++n2) {
                            double[] dArray8 = this.U[n2];
                            int n17 = n16;
                            dArray8[n17] = dArray8[n17] + d2 * this.U[n2][n3];
                        }
                    }
                    for (n16 = n3; n16 < this.m; ++n16) {
                        this.U[n16][n3] = -this.U[n16][n3];
                    }
                    this.U[n3][n3] = 1.0 + this.U[n3][n3];
                    for (n16 = 0; n16 < n3 - 1; ++n16) {
                        this.U[n16][n3] = 0.0;
                    }
                    continue;
                }
                for (n16 = 0; n16 < this.m; ++n16) {
                    this.U[n16][n3] = 0.0;
                }
                this.U[n3][n3] = 1.0;
            }
        }
        if (bl2) {
            for (n3 = this.n - 1; n3 >= 0; --n3) {
                int n18;
                if (n3 < n7 & dArray2[n3] != 0.0) {
                    for (n18 = n3 + 1; n18 < n5; ++n18) {
                        d2 = 0.0;
                        for (n2 = n3 + 1; n2 < this.n; ++n2) {
                            d2 += this.V[n2][n3] * this.V[n2][n18];
                        }
                        d2 = -d2 / this.V[n3 + 1][n3];
                        for (n2 = n3 + 1; n2 < this.n; ++n2) {
                            double[] dArray9 = this.V[n2];
                            int n19 = n18;
                            dArray9[n19] = dArray9[n19] + d2 * this.V[n2][n3];
                        }
                    }
                }
                for (n18 = 0; n18 < this.n; ++n18) {
                    this.V[n18][n3] = 0.0;
                }
                this.V[n3][n3] = 1.0;
            }
        }
        n3 = n4 - 1;
        int n20 = 0;
        d2 = Math.pow(2.0, -52.0);
        double d5 = Math.pow(2.0, -966.0);
        block35: while (n4 > 0) {
            int n21;
            int n22;
            int n23;
            for (n23 = n4 - 2; n23 >= -1 && n23 != -1; --n23) {
                if (!(Math.abs(dArray2[n23]) <= d5 + d2 * (Math.abs(this.s[n23]) + Math.abs(this.s[n23 + 1])))) continue;
                dArray2[n23] = 0.0;
                break;
            }
            if (n23 == n4 - 2) {
                n22 = 4;
            } else {
                for (n21 = n4 - 1; n21 >= n23 && n21 != n23; --n21) {
                    double d6 = (n21 != n4 ? Math.abs(dArray2[n21]) : 0.0) + (n21 != n23 + 1 ? Math.abs(dArray2[n21 - 1]) : 0.0);
                    if (!(Math.abs(this.s[n21]) <= d5 + d2 * d6)) continue;
                    this.s[n21] = 0.0;
                    break;
                }
                if (n21 == n23) {
                    n22 = 3;
                } else if (n21 == n4 - 1) {
                    n22 = 1;
                } else {
                    n22 = 2;
                    n23 = n21;
                }
            }
            ++n23;
            switch (n22) {
                case 1: {
                    int n24;
                    double d7;
                    double d8;
                    double d9;
                    double d10 = dArray2[n4 - 2];
                    dArray2[n4 - 2] = 0.0;
                    for (int i4 = n4 - 2; i4 >= n23; --i4) {
                        d9 = Maths.hypot(this.s[i4], d10);
                        d8 = this.s[i4] / d9;
                        d7 = d10 / d9;
                        this.s[i4] = d9;
                        if (i4 != n23) {
                            d10 = -d7 * dArray2[i4 - 1];
                            dArray2[i4 - 1] = d8 * dArray2[i4 - 1];
                        }
                        if (!bl2) continue;
                        for (n24 = 0; n24 < this.n; ++n24) {
                            d9 = d8 * this.V[n24][i4] + d7 * this.V[n24][n4 - 1];
                            this.V[n24][n4 - 1] = -d7 * this.V[n24][i4] + d8 * this.V[n24][n4 - 1];
                            this.V[n24][i4] = d9;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int n24;
                    double d7;
                    double d8;
                    double d9;
                    double d11 = dArray2[n23 - 1];
                    dArray2[n23 - 1] = 0.0;
                    for (int i5 = n23; i5 < n4; ++i5) {
                        d9 = Maths.hypot(this.s[i5], d11);
                        d8 = this.s[i5] / d9;
                        d7 = d11 / d9;
                        this.s[i5] = d9;
                        d11 = -d7 * dArray2[i5];
                        dArray2[i5] = d8 * dArray2[i5];
                        if (!bl) continue;
                        for (n24 = 0; n24 < this.m; ++n24) {
                            d9 = d8 * this.U[n24][i5] + d7 * this.U[n24][n23 - 1];
                            this.U[n24][n23 - 1] = -d7 * this.U[n24][i5] + d8 * this.U[n24][n23 - 1];
                            this.U[n24][i5] = d9;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double d12 = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[n4 - 1]), Math.abs(this.s[n4 - 2])), Math.abs(dArray2[n4 - 2])), Math.abs(this.s[n23])), Math.abs(dArray2[n23]));
                    double d13 = this.s[n4 - 1] / d12;
                    double d14 = this.s[n4 - 2] / d12;
                    double d15 = dArray2[n4 - 2] / d12;
                    double d16 = this.s[n23] / d12;
                    double d17 = dArray2[n23] / d12;
                    double d18 = ((d14 + d13) * (d14 - d13) + d15 * d15) / 2.0;
                    double d19 = d13 * d15 * (d13 * d15);
                    double d20 = 0.0;
                    if (d18 != 0.0 | d19 != 0.0) {
                        d20 = Math.sqrt(d18 * d18 + d19);
                        if (d18 < 0.0) {
                            d20 = -d20;
                        }
                        d20 = d19 / (d18 + d20);
                    }
                    double d21 = (d16 + d13) * (d16 - d13) + d20;
                    double d22 = d16 * d17;
                    for (int i6 = n23; i6 < n4 - 1; ++i6) {
                        int n25;
                        double d23 = Maths.hypot(d21, d22);
                        double d24 = d21 / d23;
                        double d25 = d22 / d23;
                        if (i6 != n23) {
                            dArray2[i6 - 1] = d23;
                        }
                        d21 = d24 * this.s[i6] + d25 * dArray2[i6];
                        dArray2[i6] = d24 * dArray2[i6] - d25 * this.s[i6];
                        d22 = d25 * this.s[i6 + 1];
                        this.s[i6 + 1] = d24 * this.s[i6 + 1];
                        if (bl2) {
                            for (n25 = 0; n25 < this.n; ++n25) {
                                d23 = d24 * this.V[n25][i6] + d25 * this.V[n25][i6 + 1];
                                this.V[n25][i6 + 1] = -d25 * this.V[n25][i6] + d24 * this.V[n25][i6 + 1];
                                this.V[n25][i6] = d23;
                            }
                        }
                        d23 = Maths.hypot(d21, d22);
                        d24 = d21 / d23;
                        d25 = d22 / d23;
                        this.s[i6] = d23;
                        d21 = d24 * dArray2[i6] + d25 * this.s[i6 + 1];
                        this.s[i6 + 1] = -d25 * dArray2[i6] + d24 * this.s[i6 + 1];
                        d22 = d25 * dArray2[i6 + 1];
                        dArray2[i6 + 1] = d24 * dArray2[i6 + 1];
                        if (!bl || i6 >= this.m - 1) continue;
                        for (n25 = 0; n25 < this.m; ++n25) {
                            d23 = d24 * this.U[n25][i6] + d25 * this.U[n25][i6 + 1];
                            this.U[n25][i6 + 1] = -d25 * this.U[n25][i6] + d24 * this.U[n25][i6 + 1];
                            this.U[n25][i6] = d23;
                        }
                    }
                    dArray2[n4 - 2] = d21;
                    ++n20;
                    break;
                }
                case 4: {
                    if (this.s[n23] <= 0.0) {
                        double d26 = this.s[n23] = this.s[n23] < 0.0 ? -this.s[n23] : 0.0;
                        if (bl2) {
                            for (n21 = 0; n21 <= n3; ++n21) {
                                this.V[n21][n23] = -this.V[n21][n23];
                            }
                        }
                    }
                    while (n23 < n3 && !(this.s[n23] >= this.s[n23 + 1])) {
                        int n26;
                        double d27 = this.s[n23];
                        this.s[n23] = this.s[n23 + 1];
                        this.s[n23 + 1] = d27;
                        if (bl2 && n23 < this.n - 1) {
                            for (n26 = 0; n26 < this.n; ++n26) {
                                d27 = this.V[n26][n23 + 1];
                                this.V[n26][n23 + 1] = this.V[n26][n23];
                                this.V[n26][n23] = d27;
                            }
                        }
                        if (bl && n23 < this.m - 1) {
                            for (n26 = 0; n26 < this.m; ++n26) {
                                d27 = this.U[n26][n23 + 1];
                                this.U[n26][n23 + 1] = this.U[n26][n23];
                                this.U[n26][n23] = d27;
                            }
                        }
                        ++n23;
                    }
                    n20 = 0;
                    --n4;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getS() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = 0.0;
            }
            dArray[i2][i2] = this.s[i2];
        }
        return matrix;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double d2 = Math.pow(2.0, -52.0);
        double d3 = (double)Math.max(this.m, this.n) * this.s[0] * d2;
        int n2 = 0;
        for (int i2 = 0; i2 < this.s.length; ++i2) {
            if (!(this.s[i2] > d3)) continue;
            ++n2;
        }
        return n2;
    }
}

