/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix matrix) {
        this.QR = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            int n2;
            double d2 = 0.0;
            for (n2 = i2; n2 < this.m; ++n2) {
                d2 = Maths.hypot(d2, this.QR[n2][i2]);
            }
            if (d2 != 0.0) {
                if (this.QR[i2][i2] < 0.0) {
                    d2 = -d2;
                }
                for (n2 = i2; n2 < this.m; ++n2) {
                    double[] dArray = this.QR[n2];
                    int n3 = i2;
                    dArray[n3] = dArray[n3] / d2;
                }
                double[] dArray = this.QR[i2];
                int n4 = i2;
                dArray[n4] = dArray[n4] + 1.0;
                for (n2 = i2 + 1; n2 < this.n; ++n2) {
                    int n5;
                    double d3 = 0.0;
                    for (n5 = i2; n5 < this.m; ++n5) {
                        d3 += this.QR[n5][i2] * this.QR[n5][n2];
                    }
                    d3 = -d3 / this.QR[i2][i2];
                    for (n5 = i2; n5 < this.m; ++n5) {
                        double[] dArray2 = this.QR[n5];
                        int n6 = n2;
                        dArray2[n6] = dArray2[n6] + d3 * this.QR[n5][i2];
                    }
                }
            }
            this.Rdiag[i2] = -d2;
        }
    }

    public boolean isFullRank() {
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.Rdiag[i2] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = i2 >= i3 ? this.QR[i2][i3] : 0.0;
            }
        }
        return matrix;
    }

    public Matrix getR() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = i2 < i3 ? this.QR[i2][i3] : (i2 == i3 ? this.Rdiag[i2] : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getQ() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = this.n - 1; i2 >= 0; --i2) {
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2][i2] = 0.0;
            }
            dArray[i2][i2] = 1.0;
            for (n2 = i2; n2 < this.n; ++n2) {
                int n3;
                if (this.QR[i2][i2] == 0.0) continue;
                double d2 = 0.0;
                for (n3 = i2; n3 < this.m; ++n3) {
                    d2 += this.QR[n3][i2] * dArray[n3][n2];
                }
                d2 = -d2 / this.QR[i2][i2];
                for (n3 = i2; n3 < this.m; ++n3) {
                    double[] dArray2 = dArray[n3];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + d2 * this.QR[n3][i2];
                }
            }
        }
        return matrix;
    }

    public Matrix solve(Matrix matrix) {
        int n2;
        int n3;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n4 = matrix.getColumnDimension();
        double[][] dArray = matrix.getArrayCopy();
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n5;
                double d2 = 0.0;
                for (n5 = n3; n5 < this.m; ++n5) {
                    d2 += this.QR[n5][n3] * dArray[n5][n2];
                }
                d2 = -d2 / this.QR[n3][n3];
                for (n5 = n3; n5 < this.m; ++n5) {
                    double[] dArray2 = dArray[n5];
                    int n6 = n2;
                    dArray2[n6] = dArray2[n6] + d2 * this.QR[n5][n3];
                }
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                double[] dArray3 = dArray[n3];
                int n7 = n2++;
                dArray3[n7] = dArray3[n7] / this.Rdiag[n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    double[] dArray4 = dArray[n2];
                    int n8 = i2;
                    dArray4[n8] = dArray4[n8] - dArray[n3][i2] * this.QR[n2][n3];
                }
            }
        }
        return new Matrix(dArray, this.n, n4).getMatrix(0, this.n - 1, 0, n4 - 1);
    }
}

