/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFConstants;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class AbstractVCFCodec
implements FeatureCodec,
NameAwareCodec,
VCFParser {
    protected static final Logger log = Logger.getLogger(VCFCodec.class);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeaderVersion version;
    protected VCFHeader header = null;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    protected String[] GTValueArray = new String[100];
    protected String[] genotypeKeyArray = new String[100];
    protected String[] infoValueArray = new String[1000];
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected HashMap<String, LinkedHashSet<String>> filterHash = new HashMap();
    TreeMap<String, VCFHeaderLineType> infoFields = new TreeMap();
    TreeMap<String, VCFHeaderLineType> formatFields = new TreeMap();
    Set<String> filterFields = new HashSet<String>();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();

    public abstract Object readHeader(LineReader var1);

    @Override
    public abstract Map<String, Genotype> createGenotypeMap(String var1, List<Allele> var2, String var3, int var4);

    protected abstract Set<String> parseFilters(String var1);

    protected Object createHeader(List<String> headerStrings, String line) {
        headerStrings.add(line);
        TreeSet<VCFHeaderLine> metaData = new TreeSet<VCFHeaderLine>();
        LinkedHashSet<String> auxTags = new LinkedHashSet<String>();
        for (String str : headerStrings) {
            if (!str.startsWith("##")) {
                String[] strings = str.substring(1).split("\t");
                if (strings.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + str);
                }
                int arrayIndex = 0;
                for (VCFHeader.HEADER_FIELDS field : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (field != VCFHeader.HEADER_FIELDS.valueOf(strings[arrayIndex])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)field) + "' but we saw '" + strings[arrayIndex] + "'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + strings[arrayIndex] + "'; it does not match a legal column header name.");
                    }
                    ++arrayIndex;
                }
                if (arrayIndex < strings.length) {
                    if (!strings[arrayIndex].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + strings[arrayIndex] + "'");
                    }
                    ++arrayIndex;
                }
                while (arrayIndex < strings.length) {
                    auxTags.add(strings[arrayIndex++]);
                }
                continue;
            }
            if (str.startsWith("##INFO=")) {
                VCFInfoHeaderLine info = new VCFInfoHeaderLine(str.substring(7), this.version);
                metaData.add(info);
                this.infoFields.put(info.getName(), info.getType());
                continue;
            }
            if (str.startsWith("##FILTER=")) {
                VCFFilterHeaderLine filter = new VCFFilterHeaderLine(str.substring(9), this.version);
                metaData.add(filter);
                this.filterFields.add(filter.getName());
                continue;
            }
            if (str.startsWith("##FORMAT=")) {
                VCFFormatHeaderLine format = new VCFFormatHeaderLine(str.substring(9), this.version);
                metaData.add(format);
                this.formatFields.put(format.getName(), format.getType());
                continue;
            }
            int equals = str.indexOf("=");
            if (equals == -1) continue;
            metaData.add(new VCFHeaderLine(str.substring(2, equals), str.substring(equals + 1)));
        }
        this.header = new VCFHeader(metaData, auxTags);
        return this.header;
    }

    public Feature decodeLoc(String line) {
        return this.reallyDecode(line);
    }

    public Feature decode(String line) {
        return this.reallyDecode(line);
    }

    private Feature reallyDecode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new ReviewedStingException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int nParts = ParsingUtils.split((String)line, (String[])this.parts, (char)'\t', (boolean)true);
        if ((this.header == null || this.header != null && !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
            throw new UserException.MalformedVCF("there aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )", this.lineNo);
        }
        return this.parseVCFLine(this.parts);
    }

    protected void generateException(String message) {
        throw new UserException.MalformedVCF(message, this.lineNo);
    }

    private static void generateException(String message, int lineNo) {
        throw new UserException.MalformedVCF(message, lineNo);
    }

    private VariantContext parseVCFLine(String[] parts) {
        ++this.lineNo;
        String contig = this.getCachedString(parts[0]);
        long pos = Long.valueOf(parts[1]);
        String id = null;
        if (parts[2].length() == 0) {
            this.generateException("The VCF specification requires a valid ID field");
        } else {
            id = parts[2].equals(".") ? "." : new String(parts[2]);
        }
        String ref = this.getCachedString(parts[3].toUpperCase());
        String alts = this.getCachedString(parts[4].toUpperCase());
        Double qual = AbstractVCFCodec.parseQual(parts[5]);
        String filter = this.getCachedString(parts[6]);
        String info = new String(parts[7]);
        List<Allele> alleles = AbstractVCFCodec.parseAlleles(ref, alts, this.lineNo);
        Set<String> filters = this.parseFilters(filter);
        Map<String, Object> attributes = this.parseInfo(info, id);
        long loc = pos;
        if (alleles.size() == 1) {
            loc = pos + (long)alleles.get(0).length() - 1L;
        } else if (!AbstractVCFCodec.isSingleNucleotideEvent(alleles)) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            loc = AbstractVCFCodec.clipAlleles(pos, ref, alleles, newAlleles, this.lineNo);
            alleles = newAlleles;
        }
        if (parts.length > 8) {
            attributes.put("_UNPARSED_GENOTYPE_MAP_", new String(parts[8]));
            attributes.put("_UNPARSED_GENOTYPE_PARSER_", this);
        }
        VariantContext vc = null;
        try {
            vc = new VariantContext(this.name, contig, pos, loc, alleles, qual, filters, attributes);
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        if (!this.header.samplesWereAlreadySorted()) {
            vc.getGenotypes();
        }
        return AbstractVCFCodec.createVariantContextWithTrimmedAlleles(vc);
    }

    public Class getFeatureType() {
        return VariantContext.class;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getCachedString(String str) {
        String internedString = this.stringCache.get(str);
        if (internedString == null) {
            internedString = new String(str);
            this.stringCache.put(internedString, internedString);
        }
        return internedString;
    }

    private Map<String, Object> parseInfo(String infoField, String id) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (infoField.length() == 0) {
            this.generateException("The VCF specification requires a valid info field");
        }
        if (!infoField.equals(".")) {
            int infoValueSplitSize = ParsingUtils.split((String)infoField, (String[])this.infoValueArray, (char)';');
            for (int i = 0; i < infoValueSplitSize; ++i) {
                Object value;
                String key;
                int eqI = this.infoValueArray[i].indexOf("=");
                if (eqI != -1) {
                    key = this.infoValueArray[i].substring(0, eqI);
                    String str = this.infoValueArray[i].substring(eqI + 1, this.infoValueArray[i].length());
                    value = str.contains(",") ? Arrays.asList(str.split(",")) : str;
                } else {
                    key = this.infoValueArray[i];
                    value = true;
                }
                attributes.put(key, value);
            }
        }
        attributes.put("ID", id);
        return attributes;
    }

    protected static Allele oneAllele(String index, List<Allele> alleles) {
        if (index.equals(".")) {
            return Allele.NO_CALL;
        }
        int i = Integer.valueOf(index);
        if (i >= alleles.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + index + " is not defined in the REF/ALT columns in the record");
        }
        return alleles.get(i);
    }

    protected static List<Allele> parseGenotypeAlleles(String GT, List<Allele> alleles, Map<String, List<Allele>> cache) {
        List<Allele> GTAlleles = cache.get(GT);
        if (GTAlleles == null) {
            StringTokenizer st = new StringTokenizer(GT, "/|\\");
            GTAlleles = new ArrayList<Allele>(st.countTokens());
            while (st.hasMoreTokens()) {
                String genotype = st.nextToken();
                GTAlleles.add(AbstractVCFCodec.oneAllele(genotype, alleles));
            }
            cache.put(GT, GTAlleles);
        }
        return GTAlleles;
    }

    protected static Double parseQual(String qualString) {
        if (qualString.equals(".")) {
            return -1.0;
        }
        Double val = Double.valueOf(qualString);
        if (val < 0.0 && Math.abs(val - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return -1.0;
        }
        return val / 10.0;
    }

    protected static List<Allele> parseAlleles(String ref, String alts, int lineNo) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(ref, true, lineNo);
        Allele refAllele = Allele.create(ref, true);
        alleles.add(refAllele);
        if (alts.indexOf(",") == -1) {
            AbstractVCFCodec.parseSingleAltAllele(alleles, alts, lineNo);
        } else {
            for (String alt : alts.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(alleles, alt, lineNo);
            }
        }
        return alleles;
    }

    private static void checkAllele(String allele, boolean isRef, int lineNo) {
        if (allele == null || allele.length() == 0) {
            AbstractVCFCodec.generateException("Empty alleles are not permitted in VCF records", lineNo);
        }
        if (AbstractVCFCodec.isSymbolicAllele(allele)) {
            if (isRef) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + allele, lineNo);
            }
        } else {
            if (allele.charAt(0) == 'D' || allele.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", lineNo);
            }
            if (!Allele.acceptableAlleleBases(allele)) {
                AbstractVCFCodec.generateException("Unparsable vcf record with allele " + allele, lineNo);
            }
            if (isRef && allele.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", lineNo);
            }
        }
    }

    private static boolean isSymbolicAllele(String allele) {
        return allele != null && allele.startsWith("<") && allele.endsWith(">") && allele.length() > 2;
    }

    private static void parseSingleAltAllele(List<Allele> alleles, String alt, int lineNo) {
        AbstractVCFCodec.checkAllele(alt, false, lineNo);
        Allele allele = Allele.create(alt, false);
        if (!allele.isNoCall()) {
            alleles.add(allele);
        }
    }

    protected static boolean isSingleNucleotideEvent(List<Allele> alleles) {
        for (Allele a : alleles) {
            if (a.length() == 1) continue;
            return false;
        }
        return true;
    }

    private static int computeForwardClipping(List<Allele> unclippedAlleles, String ref) {
        boolean clipping = true;
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic() || a.length() >= 1 && a.getBases()[0] == ref.getBytes()[0]) continue;
            clipping = false;
        }
        return clipping ? 1 : 0;
    }

    protected static long clipAlleles(long position, String ref, List<Allele> unclippedAlleles, List<Allele> clippedAlleles, int lineNo) {
        int forwardClipping = AbstractVCFCodec.computeForwardClipping(unclippedAlleles, ref);
        int reverseClipped = 0;
        boolean clipping = true;
        while (clipping) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) continue;
                if (a.length() - reverseClipped <= forwardClipping || a.length() - forwardClipping == 0) {
                    clipping = false;
                    continue;
                }
                if (ref.length() == reverseClipped) {
                    AbstractVCFCodec.generateException("bad alleles encountered", lineNo);
                    continue;
                }
                if (a.getBases()[a.length() - reverseClipped - 1] == ref.getBytes()[ref.length() - reverseClipped - 1]) continue;
                clipping = false;
            }
            if (!clipping) continue;
            ++reverseClipped;
        }
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic()) {
                clippedAlleles.add(a);
                continue;
            }
            clippedAlleles.add(Allele.create(Arrays.copyOfRange(a.getBases(), 0, a.getBases().length - reverseClipped), a.isReference()));
        }
        int refLength = ref.length() - reverseClipped;
        return position + (long)Math.max(refLength - 1, 0);
    }

    public static VariantContext createVariantContextWithTrimmedAlleles(VariantContext inputVC) {
        boolean trimVC;
        Allele refAllele = inputVC.getReference();
        if (!inputVC.isVariant()) {
            trimVC = false;
        } else if (refAllele.isNull()) {
            trimVC = false;
        } else {
            boolean bl = trimVC = AbstractVCFCodec.computeForwardClipping(new ArrayList<Allele>(inputVC.getAlternateAlleles()), inputVC.getReference().getDisplayString()) > 0;
        }
        if (trimVC) {
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            TreeMap<String, Genotype> genotypes = new TreeMap<String, Genotype>();
            TreeMap<String, Object> attributes = new TreeMap<String, Object>(inputVC.getAttributes());
            attributes.put("_REFERENCE_BASE_FOR_INDEL_", new Byte(inputVC.getReference().getBases()[0]));
            HashMap<Allele, Allele> originalToTrimmedAlleleMap = new HashMap<Allele, Allele>();
            for (Allele a : inputVC.getAlleles()) {
                if (a.isSymbolic()) {
                    alleles.add(a);
                    originalToTrimmedAlleleMap.put(a, a);
                    continue;
                }
                byte[] byArray = Arrays.copyOfRange(a.getBases(), 1, a.length());
                Allele trimmedAllele = Allele.create(byArray, a.isReference());
                alleles.add(trimmedAllele);
                originalToTrimmedAlleleMap.put(a, trimmedAllele);
            }
            boolean hasNullAlleles = false;
            for (Allele allele : originalToTrimmedAlleleMap.values()) {
                if (allele.isNull()) {
                    hasNullAlleles = true;
                }
                if (!allele.isReference()) continue;
                refAllele = allele;
            }
            if (!hasNullAlleles) {
                return inputVC;
            }
            for (Map.Entry entry : inputVC.getGenotypes().entrySet()) {
                List<Allele> originalAlleles = ((Genotype)entry.getValue()).getAlleles();
                ArrayList<Allele> trimmedAlleles = new ArrayList<Allele>();
                for (Allele a : originalAlleles) {
                    if (a.isCalled()) {
                        trimmedAlleles.add((Allele)originalToTrimmedAlleleMap.get(a));
                        continue;
                    }
                    trimmedAlleles.add(Allele.NO_CALL);
                }
                genotypes.put((String)entry.getKey(), Genotype.modifyAlleles((Genotype)entry.getValue(), trimmedAlleles));
            }
            return new VariantContext(inputVC.getSource(), inputVC.getChr(), (long)inputVC.getStart(), (long)inputVC.getEnd(), alleles, genotypes, inputVC.getNegLog10PError(), inputVC.filtersWereApplied() ? inputVC.getFilters() : null, attributes);
        }
        return inputVC;
    }
}

