/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private TreeMap freqTable = null;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        Iterator iter = this.freqTable.keySet().iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            outBuffer.append(value);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    public void addValue(Object v) {
        Object obj = v;
        if (v instanceof Integer) {
            obj = new Long(((Integer)v).longValue());
        }
        try {
            Long count = (Long)this.freqTable.get(obj);
            if (count == null) {
                this.freqTable.put(obj, new Long(1L));
            } else {
                this.freqTable.put(obj, new Long(count + 1L));
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Value not comparable to existing values.");
        }
    }

    public void addValue(int v) {
        this.addValue(new Long(v));
    }

    public void addValue(Integer v) {
        this.addValue(new Long(v.longValue()));
    }

    public void addValue(long v) {
        this.addValue(new Long(v));
    }

    public void addValue(char v) {
        this.addValue(new Character(v));
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public long getSumFreq() {
        long result = 0L;
        Iterator iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            result += ((Long)iterator.next()).longValue();
        }
        return result;
    }

    public long getCount(Object v) {
        if (v instanceof Integer) {
            return this.getCount(((Integer)v).longValue());
        }
        long result = 0L;
        try {
            Long count = (Long)this.freqTable.get(v);
            if (count != null) {
                result = count;
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        return result;
    }

    public long getCount(int v) {
        return this.getCount(new Long(v));
    }

    public long getCount(long v) {
        return this.getCount(new Long(v));
    }

    public long getCount(char v) {
        return this.getCount(new Character(v));
    }

    public double getPct(Object v) {
        if (this.getSumFreq() == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v) / (double)this.getSumFreq();
    }

    public double getPct(int v) {
        return this.getPct(new Long(v));
    }

    public double getPct(long v) {
        return this.getPct(new Long(v));
    }

    public double getPct(char v) {
        return this.getPct(new Character(v));
    }

    public long getCumFreq(Object v) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (v instanceof Integer) {
            return this.getCumFreq(((Integer)v).longValue());
        }
        NaturalComparator c = this.freqTable.comparator();
        if (c == null) {
            c = new NaturalComparator();
        }
        long result = 0L;
        try {
            Long value = (Long)this.freqTable.get(v);
            if (value != null) {
                result = value;
            }
        }
        catch (ClassCastException ex) {
            return result;
        }
        if (c.compare(v, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c.compare(v, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator values = this.valuesIterator();
        while (values.hasNext()) {
            Object nextValue = values.next();
            if (c.compare(v, nextValue) > 0) {
                result += this.getCount(nextValue);
                continue;
            }
            return result;
        }
        return result;
    }

    public long getCumFreq(int v) {
        return this.getCumFreq(new Long(v));
    }

    public long getCumFreq(long v) {
        return this.getCumFreq(new Long(v));
    }

    public long getCumFreq(char v) {
        return this.getCumFreq(new Character(v));
    }

    public double getCumPct(Object v) {
        if (this.getSumFreq() == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v) / (double)this.getSumFreq();
    }

    public double getCumPct(int v) {
        return this.getCumPct(new Long(v));
    }

    public double getCumPct(long v) {
        return this.getCumPct(new Long(v));
    }

    public double getCumPct(char v) {
        return this.getCumPct(new Character(v));
    }

    private static class NaturalComparator
    implements Comparator {
        private NaturalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

